/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.ch;

import com.carrotsearch.hppc.IntArrayList;
import com.carrotsearch.hppc.IntObjectHashMap;
import com.carrotsearch.hppc.IntObjectMap;
import com.graphhopper.apache.commons.collections.IntDoubleBinaryHeap;
import com.graphhopper.routing.ch.CHEntry;
import com.graphhopper.routing.ch.OnFlyStatisticsCalculator;
import com.graphhopper.routing.util.DefaultEdgeFilter;
import com.graphhopper.routing.weighting.TurnWeighting;
import com.graphhopper.storage.CHGraph;
import com.graphhopper.storage.SPTEntry;
import com.graphhopper.util.EdgeExplorer;
import com.graphhopper.util.EdgeIterator;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.GHUtility;
import com.graphhopper.util.PMap;
import java.util.Arrays;
import java.util.Locale;

public class WitnessPathSearcher {
    private static final int NO_NODE = -1;
    private static final double MAX_ZERO_WEIGHT_LOOP = 0.001;
    private final CHGraph chGraph;
    private final TurnWeighting turnWeighting;
    private final EdgeExplorer outEdgeExplorer;
    private final EdgeExplorer origInEdgeExplorer;
    private final int maxLevel;
    private final Params params = new Params();
    private int sourceEdge;
    private int sourceNode;
    private int centerNode;
    private double bestPathWeight;
    private int bestPathIncEdge;
    private boolean bestPathIsBridgePath;
    private int numPathsToCenter;
    private int numSettledEdges;
    private int numPolledEdges;
    private double[] weights;
    private int[] edges;
    private int[] incEdges;
    private int[] parents;
    private int[] adjNodes;
    private boolean[] isPathToCenters;
    private IntObjectMap<CHEntry> initialEntryParents;
    private IntArrayList changedEdges;
    private IntDoubleBinaryHeap dijkstraHeap;
    private int maxSettledEdges;
    private final OnFlyStatisticsCalculator settledEdgesStats = new OnFlyStatisticsCalculator();
    private final Stats currentBatchStats = new Stats();
    private final Stats totalStats = new Stats();

    public WitnessPathSearcher(CHGraph chGraph, TurnWeighting turnWeighting, PMap pMap) {
        this.chGraph = chGraph;
        this.turnWeighting = turnWeighting;
        this.extractParams(pMap);
        DefaultEdgeFilter inEdgeFilter = DefaultEdgeFilter.inEdges(turnWeighting.getFlagEncoder());
        DefaultEdgeFilter outEdgeFilter = DefaultEdgeFilter.outEdges(turnWeighting.getFlagEncoder());
        this.outEdgeExplorer = chGraph.createEdgeExplorer(outEdgeFilter);
        this.origInEdgeExplorer = chGraph.createOriginalEdgeExplorer(inEdgeFilter);
        this.maxLevel = chGraph.getNodes();
        this.maxSettledEdges = this.params.minimumMaxSettledEdges;
        int numOriginalEdges = chGraph.getOriginalEdges();
        this.initStorage(2 * numOriginalEdges);
        this.initCollections();
    }

    private void extractParams(PMap pMap) {
        this.params.sigmaFactor = pMap.getDouble("prepare.ch.edge.witness_search.sigma_factor", this.params.sigmaFactor);
        this.params.minimumMaxSettledEdges = pMap.getInt("prepare.ch.edge.witness_search.min_max_settled_edges", this.params.minimumMaxSettledEdges);
        this.params.settledEdgeStatsResetInterval = pMap.getInt("prepare.ch.edge.witness_search.reset_interval", this.params.settledEdgeStatsResetInterval);
    }

    public int initSearch(int centerNode, int sourceNode, int sourceEdge) {
        this.reset();
        this.sourceEdge = sourceEdge;
        this.sourceNode = sourceNode;
        this.centerNode = centerNode;
        this.setInitialEntries(sourceNode, sourceEdge, centerNode);
        if (this.numPathsToCenter < 1) {
            this.reset();
            return 0;
        }
        this.currentBatchStats.numSearches++;
        Stats stats = this.currentBatchStats;
        stats.maxNumSettledEdges = stats.maxNumSettledEdges + (long)this.maxSettledEdges;
        this.totalStats.numSearches++;
        stats = this.totalStats;
        stats.maxNumSettledEdges = stats.maxNumSettledEdges + (long)this.maxSettledEdges;
        return this.dijkstraHeap.getSize();
    }

    public CHEntry runSearch(int targetNode, int targetEdge) {
        int currKey;
        this.bestPathWeight = this.sourceNode == targetNode ? this.calcTurnWeight(this.sourceEdge, this.sourceNode, targetEdge) : Double.POSITIVE_INFINITY;
        this.bestPathIncEdge = -1;
        this.bestPathIsBridgePath = false;
        EdgeIterator inIter = this.origInEdgeExplorer.setBaseNode(targetNode);
        while (inIter.next()) {
            boolean isZeroWeightLoop;
            int incEdge = inIter.getOrigEdgeLast();
            int edgeKey = this.getEdgeKey(incEdge, targetNode);
            if (this.edges[edgeKey] == -1 || (isZeroWeightLoop = this.parents[edgeKey] >= 0 && targetNode == this.adjNodes[this.parents[edgeKey]] && this.weights[edgeKey] - this.weights[this.parents[edgeKey]] <= 0.001)) continue;
            this.updateBestPath(targetNode, targetEdge, edgeKey);
        }
        while (!this.dijkstraHeap.isEmpty() && (this.numPathsToCenter >= 1 || this.bestPathIsBridgePath && !Double.isInfinite(this.bestPathWeight)) && !(this.weights[currKey = this.dijkstraHeap.peek_element()] > this.bestPathWeight)) {
            this.dijkstraHeap.poll_element();
            ++this.numPolledEdges;
            this.currentBatchStats.numPolledEdges++;
            this.totalStats.numPolledEdges++;
            if (this.isPathToCenters[currKey]) {
                --this.numPathsToCenter;
            }
            if (this.numSettledEdges > this.maxSettledEdges && !this.isPathToCenters[currKey]) continue;
            int fromNode = this.adjNodes[currKey];
            EdgeIterator iter = this.outEdgeExplorer.setBaseNode(fromNode);
            while (iter.next()) {
                double edgeWeight;
                double weight;
                if (this.isContracted(iter.getAdjNode()) || iter.getOrigEdgeFirst() == this.incEdges[currKey] || Double.isInfinite(weight = (edgeWeight = this.turnWeighting.calcWeight(iter, false, this.incEdges[currKey])) + this.weights[currKey])) continue;
                boolean isPathToCenter = this.isPathToCenters[currKey] && iter.getAdjNode() == this.centerNode;
                boolean isZeroWeightLoop = fromNode == targetNode && edgeWeight <= 0.001;
                int key = this.getEdgeKey(iter.getOrigEdgeLast(), iter.getAdjNode());
                if (this.edges[key] == -1) {
                    this.setEntry(key, iter, weight, currKey, isPathToCenter);
                    this.changedEdges.add(key);
                    this.dijkstraHeap.insert_(weight, key);
                    if (isZeroWeightLoop) continue;
                    this.updateBestPath(targetNode, targetEdge, key);
                    continue;
                }
                if (!(weight < this.weights[key])) continue;
                this.updateEntry(key, iter, weight, currKey, isPathToCenter);
                this.dijkstraHeap.update_(weight, key);
                if (isZeroWeightLoop) continue;
                this.updateBestPath(targetNode, targetEdge, key);
            }
            ++this.numSettledEdges;
            this.currentBatchStats.numSettledEdges++;
            this.totalStats.numSettledEdges++;
        }
        if (this.bestPathIsBridgePath) {
            CHEntry result;
            int edgeKey = this.getEdgeKey(this.bestPathIncEdge, targetNode);
            CHEntry entry = result = this.getEntryForKey(edgeKey);
            while (this.parents[edgeKey] >= 0) {
                edgeKey = this.parents[edgeKey];
                CHEntry parent = this.getEntryForKey(edgeKey);
                entry.parent = parent;
                entry = parent;
            }
            entry.parent = (SPTEntry)this.initialEntryParents.get(this.parents[edgeKey]);
            return result;
        }
        return null;
    }

    public String getStatisticsString() {
        return "last batch: " + this.currentBatchStats.toString() + " total: " + this.totalStats.toString();
    }

    public long getNumPolledEdges() {
        return this.numPolledEdges;
    }

    public long getTotalNumSearches() {
        return this.totalStats.numSearches;
    }

    public void resetStats() {
        this.currentBatchStats.reset();
    }

    private void initStorage(int numEntries) {
        this.weights = new double[numEntries];
        Arrays.fill(this.weights, Double.POSITIVE_INFINITY);
        this.edges = new int[numEntries];
        Arrays.fill(this.edges, -1);
        this.incEdges = new int[numEntries];
        Arrays.fill(this.incEdges, -1);
        this.parents = new int[numEntries];
        Arrays.fill(this.parents, -1);
        this.adjNodes = new int[numEntries];
        Arrays.fill(this.adjNodes, -1);
        this.isPathToCenters = new boolean[numEntries];
        Arrays.fill(this.isPathToCenters, false);
    }

    private void initCollections() {
        this.initialEntryParents = new IntObjectHashMap(10);
        this.changedEdges = new IntArrayList(1000);
        this.dijkstraHeap = new IntDoubleBinaryHeap(1000);
    }

    private void setInitialEntries(int sourceNode, int sourceEdge, int centerNode) {
        EdgeIterator outIter = this.outEdgeExplorer.setBaseNode(sourceNode);
        while (outIter.next()) {
            double turnWeight;
            if (this.isContracted(outIter.getAdjNode()) || Double.isInfinite(turnWeight = this.calcTurnWeight(sourceEdge, sourceNode, outIter.getOrigEdgeFirst()))) continue;
            double edgeWeight = this.turnWeighting.calcWeight(outIter, false, -1);
            double weight = turnWeight + edgeWeight;
            boolean isPathToCenter = outIter.getAdjNode() == centerNode;
            int incEdge = outIter.getOrigEdgeLast();
            int adjNode = outIter.getAdjNode();
            int key = this.getEdgeKey(incEdge, adjNode);
            int parentKey = -key - 1;
            CHEntry parent = new CHEntry(-1, outIter.getOrigEdgeFirst(), sourceNode, turnWeight);
            if (this.edges[key] == -1) {
                this.edges[key] = outIter.getEdge();
                this.incEdges[key] = incEdge;
                this.adjNodes[key] = adjNode;
                this.weights[key] = weight;
                this.parents[key] = parentKey;
                this.isPathToCenters[key] = isPathToCenter;
                this.initialEntryParents.put(parentKey, (Object)parent);
                this.changedEdges.add(key);
                continue;
            }
            if (!(weight < this.weights[key])) continue;
            this.edges[key] = outIter.getEdge();
            this.weights[key] = weight;
            this.parents[key] = parentKey;
            this.isPathToCenters[key] = isPathToCenter;
            this.initialEntryParents.put(parentKey, (Object)parent);
        }
        for (int i = 0; i < this.changedEdges.size(); ++i) {
            int key = this.changedEdges.get(i);
            if (this.isPathToCenters[key]) {
                ++this.numPathsToCenter;
            }
            this.dijkstraHeap.insert_(this.weights[key], key);
        }
    }

    private void reset() {
        this.updateMaxSettledEdges();
        this.numSettledEdges = 0;
        this.numPolledEdges = 0;
        this.numPathsToCenter = 0;
        this.resetShortestPathTree();
    }

    private void updateMaxSettledEdges() {
        this.settledEdgesStats.addObservation(this.numSettledEdges);
        if (this.settledEdgesStats.getCount() == (long)this.params.settledEdgeStatsResetInterval) {
            this.maxSettledEdges = Math.max(this.params.minimumMaxSettledEdges, (int)(this.settledEdgesStats.getMean() + this.params.sigmaFactor * Math.sqrt(this.settledEdgesStats.getVariance())));
            this.settledEdgesStats.reset();
        }
    }

    private void resetShortestPathTree() {
        for (int i = 0; i < this.changedEdges.size(); ++i) {
            this.resetEntry(this.changedEdges.get(i));
        }
        this.changedEdges.elementsCount = 0;
        this.initialEntryParents.clear();
        this.dijkstraHeap.clear();
    }

    private void updateBestPath(int targetNode, int targetEdge, int edgeKey) {
        if (this.adjNodes[edgeKey] == targetNode) {
            double tolerance;
            double totalWeight = this.weights[edgeKey] + this.calcTurnWeight(this.incEdges[edgeKey], targetNode, targetEdge);
            boolean isBridgePath = this.parents[edgeKey] >= 0 && this.isPathToCenters[this.parents[edgeKey]];
            double d = tolerance = isBridgePath ? 0.0 : 1.0E-6;
            if (totalWeight - tolerance < this.bestPathWeight) {
                this.bestPathWeight = totalWeight;
                this.bestPathIncEdge = this.incEdges[edgeKey];
                this.bestPathIsBridgePath = isBridgePath;
            }
        }
    }

    private void setEntry(int key, EdgeIteratorState edge, double weight, int parent, boolean isPathToCenter) {
        this.edges[key] = edge.getEdge();
        this.incEdges[key] = edge.getOrigEdgeLast();
        this.adjNodes[key] = edge.getAdjNode();
        this.weights[key] = weight;
        this.parents[key] = parent;
        if (isPathToCenter) {
            this.isPathToCenters[key] = true;
            ++this.numPathsToCenter;
        }
    }

    private void updateEntry(int key, EdgeIteratorState edge, double weight, int currKey, boolean isPathToCenter) {
        this.edges[key] = edge.getEdge();
        this.weights[key] = weight;
        this.parents[key] = currKey;
        if (isPathToCenter) {
            if (!this.isPathToCenters[key]) {
                ++this.numPathsToCenter;
            }
        } else if (this.isPathToCenters[key]) {
            --this.numPathsToCenter;
        }
        this.isPathToCenters[key] = isPathToCenter;
    }

    private void resetEntry(int key) {
        this.weights[key] = Double.POSITIVE_INFINITY;
        this.edges[key] = -1;
        this.incEdges[key] = -1;
        this.parents[key] = -1;
        this.adjNodes[key] = -1;
        this.isPathToCenters[key] = false;
    }

    private CHEntry getEntryForKey(int edgeKey) {
        return new CHEntry(this.edges[edgeKey], this.incEdges[edgeKey], this.adjNodes[edgeKey], this.weights[edgeKey]);
    }

    private int getEdgeKey(int edge, int adjNode) {
        int baseNode = this.chGraph.getOtherNode(edge, adjNode);
        return GHUtility.createEdgeKey(baseNode, adjNode, edge, false);
    }

    private double calcTurnWeight(int inEdge, int viaNode, int outEdge) {
        if (inEdge == outEdge) {
            return Double.POSITIVE_INFINITY;
        }
        return this.turnWeighting.calcTurnWeight(inEdge, viaNode, outEdge);
    }

    private boolean isContracted(int node) {
        return this.chGraph.getLevel(node) != this.maxLevel;
    }

    static class Stats {
        private long numSearches;
        private long numPolledEdges;
        private long numSettledEdges;
        private long maxNumSettledEdges;

        Stats() {
        }

        public String toString() {
            return String.format(Locale.ROOT, "limit-exhaustion: %s %%, avg-settled: %s, avg-max-settled: %s, avg-polled-edges: %s", this.quotient(this.numSettledEdges * 100L, this.maxNumSettledEdges), this.quotient(this.numSettledEdges, this.numSearches), this.quotient(this.maxNumSettledEdges, this.numSearches), this.quotient(this.numPolledEdges, this.numSearches));
        }

        private String quotient(long a, long b) {
            return b == 0L ? "NaN" : String.format(Locale.ROOT, "%5.1f", (double)a / (double)b);
        }

        void reset() {
            this.numSearches = 0L;
            this.numPolledEdges = 0L;
            this.numSettledEdges = 0L;
            this.maxNumSettledEdges = 0L;
        }
    }

    static class Params {
        private double sigmaFactor = 3.0;
        private int minimumMaxSettledEdges = 100;
        private int settledEdgeStatsResetInterval = 10000;

        Params() {
        }
    }
}

