/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.profiles;

import com.graphhopper.routing.profiles.DecimalEncodedValue;
import com.graphhopper.routing.profiles.SimpleIntEncodedValue;
import com.graphhopper.storage.IntsRef;

public final class FactorizedDecimalEncodedValue
extends SimpleIntEncodedValue
implements DecimalEncodedValue {
    private final double factor;

    public FactorizedDecimalEncodedValue(String name, int bits, double factor, boolean store2DirectedValues) {
        super(name, bits, store2DirectedValues);
        this.factor = factor;
    }

    private int toInt(double val) {
        return (int)Math.round(val / this.factor);
    }

    @Override
    public final void setDecimal(boolean reverse, IntsRef ints, double value) {
        if (this.maxValue <= 0L) {
            throw new IllegalStateException("Call init before usage for EncodedValue " + this.toString());
        }
        if (value > (double)this.maxValue * this.factor) {
            throw new IllegalArgumentException(this.getName() + " value " + value + " too large for encoding. maxValue:" + (double)this.maxValue * this.factor);
        }
        if (value < 0.0) {
            throw new IllegalArgumentException("Negative value for " + this.getName() + " not allowed! " + value);
        }
        if (Double.isNaN(value)) {
            throw new IllegalArgumentException("NaN value for " + this.getName() + " not allowed!");
        }
        super.setInt(reverse, ints, this.toInt(value));
    }

    @Override
    public final double getDecimal(boolean reverse, IntsRef ref) {
        int value = this.getInt(reverse, ref);
        return (double)value * this.factor;
    }
}

