/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.subnetwork;

import com.carrotsearch.hppc.IntArrayList;
import com.carrotsearch.hppc.IntIndexedContainer;
import com.graphhopper.coll.GHBitSet;
import com.graphhopper.coll.GHBitSetImpl;
import com.graphhopper.routing.profiles.BooleanEncodedValue;
import com.graphhopper.routing.subnetwork.TarjansSCCAlgorithm;
import com.graphhopper.routing.util.DefaultEdgeFilter;
import com.graphhopper.routing.util.FlagEncoder;
import com.graphhopper.storage.GraphHopperStorage;
import com.graphhopper.util.BreadthFirstSearch;
import com.graphhopper.util.EdgeExplorer;
import com.graphhopper.util.EdgeIterator;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.Helper;
import com.graphhopper.util.StopWatch;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrepareRoutingSubnetworks {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final GraphHopperStorage ghStorage;
    private final AtomicInteger maxEdgesPerNode = new AtomicInteger(0);
    private final List<FlagEncoder> encoders;
    private final List<BooleanEncodedValue> accessEncList;
    private int minNetworkSize = 200;
    private int minOneWayNetworkSize = 0;
    private int subnetworks = -1;

    public PrepareRoutingSubnetworks(GraphHopperStorage ghStorage, List<FlagEncoder> encoders) {
        this.ghStorage = ghStorage;
        this.encoders = encoders;
        this.accessEncList = new ArrayList<BooleanEncodedValue>();
        for (FlagEncoder flagEncoder : encoders) {
            this.accessEncList.add(flagEncoder.getAccessEnc());
        }
    }

    public PrepareRoutingSubnetworks setMinNetworkSize(int minNetworkSize) {
        this.minNetworkSize = minNetworkSize;
        return this;
    }

    public PrepareRoutingSubnetworks setMinOneWayNetworkSize(int minOnewayNetworkSize) {
        this.minOneWayNetworkSize = minOnewayNetworkSize;
        return this;
    }

    public void doWork() {
        if (this.minNetworkSize <= 0 && this.minOneWayNetworkSize <= 0) {
            return;
        }
        this.logger.info("start finding subnetworks (min:" + this.minNetworkSize + ", min one way:" + this.minOneWayNetworkSize + ") " + Helper.getMemInfo());
        int unvisitedDeadEnds = 0;
        for (FlagEncoder encoder : this.encoders) {
            PrepEdgeFilter filter = new PrepEdgeFilter(encoder);
            if (this.minOneWayNetworkSize > 0) {
                unvisitedDeadEnds += this.removeDeadEndUnvisitedNetworks(filter);
            }
            List<IntArrayList> components = this.findSubnetworks(filter);
            this.keepLargeNetworks(filter, components);
            this.subnetworks = Math.max(components.size(), this.subnetworks);
            this.logger.info(components.size() + " subnetworks found for " + encoder + ", " + Helper.getMemInfo());
        }
        this.markNodesRemovedIfUnreachable();
        this.logger.info("optimize to remove subnetworks (" + this.subnetworks + "), unvisited-dead-end-nodes (" + unvisitedDeadEnds + "), maxEdges/node (" + this.maxEdgesPerNode.get() + ")");
        this.ghStorage.optimize();
    }

    public int getMaxSubnetworks() {
        return this.subnetworks;
    }

    List<IntArrayList> findSubnetworks(PrepEdgeFilter filter) {
        final BooleanEncodedValue accessEnc = filter.getAccessEnc();
        EdgeExplorer explorer = this.ghStorage.createEdgeExplorer(filter);
        int locs = this.ghStorage.getNodes();
        ArrayList<IntArrayList> list = new ArrayList<IntArrayList>(100);
        final GHBitSetImpl bs = new GHBitSetImpl(locs);
        for (int start = 0; start < locs; ++start) {
            if (bs.contains(start)) continue;
            final IntArrayList intList = new IntArrayList(20);
            list.add(intList);
            new BreadthFirstSearch(){
                int tmpCounter = 0;

                @Override
                protected GHBitSet createBitSet() {
                    return bs;
                }

                @Override
                protected final boolean goFurther(int nodeId) {
                    if (this.tmpCounter > PrepareRoutingSubnetworks.this.maxEdgesPerNode.get()) {
                        PrepareRoutingSubnetworks.this.maxEdgesPerNode.set(this.tmpCounter);
                    }
                    this.tmpCounter = 0;
                    intList.add(nodeId);
                    return true;
                }

                @Override
                protected final boolean checkAdjacent(EdgeIteratorState edge) {
                    if (edge.get(accessEnc) || edge.getReverse(accessEnc)) {
                        ++this.tmpCounter;
                        return true;
                    }
                    return false;
                }
            }.start(explorer, start);
            intList.trimToSize();
        }
        return list;
    }

    int keepLargeNetworks(PrepEdgeFilter filter, List<IntArrayList> components) {
        if (components.size() <= 1) {
            return 0;
        }
        int maxCount = -1;
        IntArrayList oldComponent = null;
        int allRemoved = 0;
        BooleanEncodedValue accessEnc = filter.getAccessEnc();
        EdgeExplorer explorer = this.ghStorage.createEdgeExplorer(filter);
        for (IntArrayList component : components) {
            int removedEdges;
            if (maxCount < 0) {
                maxCount = component.size();
                oldComponent = component;
                continue;
            }
            if (maxCount < component.size()) {
                removedEdges = this.removeEdges(explorer, accessEnc, (IntIndexedContainer)oldComponent, this.minNetworkSize);
                maxCount = component.size();
                oldComponent = component;
            } else {
                removedEdges = this.removeEdges(explorer, accessEnc, (IntIndexedContainer)component, this.minNetworkSize);
            }
            allRemoved += removedEdges;
        }
        if (allRemoved > this.ghStorage.getAllEdges().length() / 2) {
            throw new IllegalStateException("Too many total edges were removed: " + allRemoved + ", all edges:" + this.ghStorage.getAllEdges().length());
        }
        return allRemoved;
    }

    int removeDeadEndUnvisitedNetworks(PrepEdgeFilter bothFilter) {
        StopWatch sw = new StopWatch(bothFilter.getAccessEnc() + " findComponents").start();
        DefaultEdgeFilter outFilter = DefaultEdgeFilter.outEdges(bothFilter.getAccessEnc());
        TarjansSCCAlgorithm tarjan = new TarjansSCCAlgorithm(this.ghStorage, outFilter, true);
        List<IntArrayList> components = tarjan.findComponents();
        this.logger.info(sw.stop() + ", size:" + components.size());
        return this.removeEdges(bothFilter, components, this.minOneWayNetworkSize);
    }

    int removeEdges(PrepEdgeFilter bothFilter, List<IntArrayList> components, int min) {
        EdgeExplorer explorer = this.ghStorage.createEdgeExplorer(bothFilter);
        int removedEdges = 0;
        for (IntArrayList component : components) {
            removedEdges += this.removeEdges(explorer, bothFilter.getAccessEnc(), (IntIndexedContainer)component, min);
        }
        return removedEdges;
    }

    int removeEdges(EdgeExplorer explorer, BooleanEncodedValue accessEnc, IntIndexedContainer component, int min) {
        int removedEdges = 0;
        if (component.size() < min) {
            for (int i = 0; i < component.size(); ++i) {
                EdgeIterator edge = explorer.setBaseNode(component.get(i));
                while (edge.next()) {
                    edge.set(accessEnc, false).setReverse(accessEnc, false);
                    ++removedEdges;
                }
            }
        }
        return removedEdges;
    }

    void markNodesRemovedIfUnreachable() {
        EdgeExplorer edgeExplorer = this.ghStorage.createEdgeExplorer();
        for (int nodeIndex = 0; nodeIndex < this.ghStorage.getNodes(); ++nodeIndex) {
            if (!this.detectNodeRemovedForAllEncoders(edgeExplorer, nodeIndex)) continue;
            this.ghStorage.markNodeRemoved(nodeIndex);
        }
    }

    boolean detectNodeRemovedForAllEncoders(EdgeExplorer edgeExplorerAllEdges, int nodeIndex) {
        EdgeIterator iter = edgeExplorerAllEdges.setBaseNode(nodeIndex);
        while (iter.next()) {
            for (BooleanEncodedValue accessEnc : this.accessEncList) {
                if (!iter.get(accessEnc) && !iter.getReverse(accessEnc)) continue;
                return false;
            }
        }
        return true;
    }

    static class PrepEdgeFilter
    extends DefaultEdgeFilter {
        public PrepEdgeFilter(FlagEncoder encoder) {
            super(encoder.getAccessEnc(), true, true);
        }

        public BooleanEncodedValue getAccessEnc() {
            return this.accessEnc;
        }
    }
}

