/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util;

import com.graphhopper.reader.ReaderRelation;
import com.graphhopper.reader.ReaderWay;
import com.graphhopper.routing.profiles.BooleanEncodedValue;
import com.graphhopper.routing.profiles.DecimalEncodedValue;
import com.graphhopper.routing.profiles.EncodedValue;
import com.graphhopper.routing.profiles.FactorizedDecimalEncodedValue;
import com.graphhopper.routing.profiles.IntEncodedValue;
import com.graphhopper.routing.profiles.SimpleBooleanEncodedValue;
import com.graphhopper.routing.profiles.SimpleIntEncodedValue;
import com.graphhopper.routing.util.AbstractFlagEncoder;
import com.graphhopper.routing.util.EncodedValueOld;
import com.graphhopper.routing.util.EncodingManager;
import com.graphhopper.routing.util.PriorityCode;
import com.graphhopper.routing.weighting.PriorityWeighting;
import com.graphhopper.storage.IntsRef;
import com.graphhopper.util.Helper;
import com.graphhopper.util.InstructionAnnotation;
import com.graphhopper.util.Translation;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public abstract class BikeCommonFlagEncoder
extends AbstractFlagEncoder {
    public static final int K_UNPAVED = 100;
    protected static final int PUSHING_SECTION_SPEED = 4;
    protected final HashSet<String> pushingSectionsHighways = new HashSet();
    protected final HashSet<String> oppositeLanes = new HashSet();
    protected final Set<String> preferHighwayTags = new HashSet<String>();
    protected final Set<String> avoidHighwayTags = new HashSet<String>();
    protected final Set<String> unpavedSurfaceTags = new HashSet<String>();
    private final Map<String, Integer> trackTypeSpeeds = new HashMap<String, Integer>();
    private final Map<String, Integer> surfaceSpeeds = new HashMap<String, Integer>();
    private final Set<String> roadValues = new HashSet<String>();
    private final Map<String, Integer> highwaySpeeds = new HashMap<String, Integer>();
    private final Map<String, Integer> bikeNetworkToCode = new HashMap<String, Integer>();
    protected EncodedValueOld relationCodeEncoder;
    protected boolean speedTwoDirections;
    DecimalEncodedValue priorityWayEncoder;
    private BooleanEncodedValue unpavedEncoder;
    private IntEncodedValue wayTypeEncoder;
    private int avoidSpeedLimit;
    private String classBicycleKey;

    protected BikeCommonFlagEncoder(int speedBits, double speedFactor, int maxTurnCosts) {
        super(speedBits, speedFactor, maxTurnCosts);
        this.restrictions.addAll(Arrays.asList("bicycle", "vehicle", "access"));
        this.restrictedValues.add("private");
        this.restrictedValues.add("no");
        this.restrictedValues.add("restricted");
        this.restrictedValues.add("military");
        this.restrictedValues.add("emergency");
        this.intendedValues.add("yes");
        this.intendedValues.add("designated");
        this.intendedValues.add("official");
        this.intendedValues.add("permissive");
        this.oppositeLanes.add("opposite");
        this.oppositeLanes.add("opposite_lane");
        this.oppositeLanes.add("opposite_track");
        this.setBlockByDefault(false);
        this.potentialBarriers.add("gate");
        this.potentialBarriers.add("swing_gate");
        this.potentialBarriers.add("cattle_grid");
        this.absoluteBarriers.add("fence");
        this.absoluteBarriers.add("stile");
        this.absoluteBarriers.add("turnstile");
        this.unpavedSurfaceTags.add("unpaved");
        this.unpavedSurfaceTags.add("gravel");
        this.unpavedSurfaceTags.add("ground");
        this.unpavedSurfaceTags.add("dirt");
        this.unpavedSurfaceTags.add("grass");
        this.unpavedSurfaceTags.add("compacted");
        this.unpavedSurfaceTags.add("earth");
        this.unpavedSurfaceTags.add("fine_gravel");
        this.unpavedSurfaceTags.add("grass_paver");
        this.unpavedSurfaceTags.add("ice");
        this.unpavedSurfaceTags.add("mud");
        this.unpavedSurfaceTags.add("salt");
        this.unpavedSurfaceTags.add("sand");
        this.unpavedSurfaceTags.add("wood");
        this.roadValues.add("living_street");
        this.roadValues.add("road");
        this.roadValues.add("service");
        this.roadValues.add("unclassified");
        this.roadValues.add("residential");
        this.roadValues.add("trunk");
        this.roadValues.add("trunk_link");
        this.roadValues.add("primary");
        this.roadValues.add("primary_link");
        this.roadValues.add("secondary");
        this.roadValues.add("secondary_link");
        this.roadValues.add("tertiary");
        this.roadValues.add("tertiary_link");
        this.maxPossibleSpeed = 30;
        this.setTrackTypeSpeed("grade1", 18);
        this.setTrackTypeSpeed("grade2", 12);
        this.setTrackTypeSpeed("grade3", 8);
        this.setTrackTypeSpeed("grade4", 6);
        this.setTrackTypeSpeed("grade5", 4);
        this.setSurfaceSpeed("paved", 18);
        this.setSurfaceSpeed("asphalt", 18);
        this.setSurfaceSpeed("cobblestone", 8);
        this.setSurfaceSpeed("cobblestone:flattened", 10);
        this.setSurfaceSpeed("sett", 10);
        this.setSurfaceSpeed("concrete", 18);
        this.setSurfaceSpeed("concrete:lanes", 16);
        this.setSurfaceSpeed("concrete:plates", 16);
        this.setSurfaceSpeed("paving_stones", 12);
        this.setSurfaceSpeed("paving_stones:30", 12);
        this.setSurfaceSpeed("unpaved", 14);
        this.setSurfaceSpeed("compacted", 16);
        this.setSurfaceSpeed("dirt", 10);
        this.setSurfaceSpeed("earth", 12);
        this.setSurfaceSpeed("fine_gravel", 18);
        this.setSurfaceSpeed("grass", 8);
        this.setSurfaceSpeed("grass_paver", 8);
        this.setSurfaceSpeed("gravel", 12);
        this.setSurfaceSpeed("ground", 12);
        this.setSurfaceSpeed("ice", 2);
        this.setSurfaceSpeed("metal", 10);
        this.setSurfaceSpeed("mud", 10);
        this.setSurfaceSpeed("pebblestone", 16);
        this.setSurfaceSpeed("salt", 6);
        this.setSurfaceSpeed("sand", 6);
        this.setSurfaceSpeed("wood", 6);
        this.setHighwaySpeed("living_street", 6);
        this.setHighwaySpeed("steps", 2);
        int CYCLEWAY_SPEED = 18;
        this.setHighwaySpeed("cycleway", 18);
        this.setHighwaySpeed("path", 10);
        this.setHighwaySpeed("footway", 6);
        this.setHighwaySpeed("pedestrian", 6);
        this.setHighwaySpeed("track", 12);
        this.setHighwaySpeed("service", 14);
        this.setHighwaySpeed("residential", 18);
        this.setHighwaySpeed("unclassified", 16);
        this.setHighwaySpeed("road", 12);
        this.setHighwaySpeed("trunk", 18);
        this.setHighwaySpeed("trunk_link", 18);
        this.setHighwaySpeed("primary", 18);
        this.setHighwaySpeed("primary_link", 18);
        this.setHighwaySpeed("secondary", 18);
        this.setHighwaySpeed("secondary_link", 18);
        this.setHighwaySpeed("tertiary", 18);
        this.setHighwaySpeed("tertiary_link", 18);
        this.setHighwaySpeed("motorway", 18);
        this.setHighwaySpeed("motorway_link", 18);
        this.avoidHighwayTags.add("motorway");
        this.avoidHighwayTags.add("motorway_link");
        this.setCyclingNetworkPreference("icn", PriorityCode.BEST.getValue());
        this.setCyclingNetworkPreference("ncn", PriorityCode.BEST.getValue());
        this.setCyclingNetworkPreference("rcn", PriorityCode.VERY_NICE.getValue());
        this.setCyclingNetworkPreference("lcn", PriorityCode.PREFER.getValue());
        this.setCyclingNetworkPreference("mtb", PriorityCode.UNCHANGED.getValue());
        this.setCyclingNetworkPreference("deprecated", PriorityCode.AVOID_AT_ALL_COSTS.getValue());
        this.speedDefault = this.highwaySpeeds.get("cycleway").intValue();
        this.setAvoidSpeedLimit(71);
    }

    @Override
    public int getVersion() {
        return 3;
    }

    @Override
    public void createEncodedValues(List<EncodedValue> registerNewEncodedValue, String prefix, int index) {
        super.createEncodedValues(registerNewEncodedValue, prefix, index);
        this.speedEncoder = new FactorizedDecimalEncodedValue(prefix + "average_speed", this.speedBits, this.speedFactor, this.speedTwoDirections);
        registerNewEncodedValue.add(this.speedEncoder);
        this.unpavedEncoder = new SimpleBooleanEncodedValue(prefix + "paved", false);
        registerNewEncodedValue.add(this.unpavedEncoder);
        this.wayTypeEncoder = new SimpleIntEncodedValue(prefix + "waytype", 2, false);
        registerNewEncodedValue.add(this.wayTypeEncoder);
        this.priorityWayEncoder = new FactorizedDecimalEncodedValue(prefix + "priority", 3, PriorityCode.getFactor(1), false);
        registerNewEncodedValue.add(this.priorityWayEncoder);
    }

    @Override
    public int defineRelationBits(int index, int shift) {
        this.relationCodeEncoder = new EncodedValueOld("RelationCode", shift, 3, 1.0, 0L, 7);
        return shift + this.relationCodeEncoder.getBits();
    }

    @Override
    public EncodingManager.Access getAccess(ReaderWay way) {
        String highwayValue = way.getTag("highway");
        if (highwayValue == null) {
            String bikeTag;
            EncodingManager.Access accept = EncodingManager.Access.CAN_SKIP;
            if (way.hasTag("route", (Set<String>)this.ferries) && ((bikeTag = way.getTag("bicycle")) == null && !way.hasTag("foot", new String[0]) || this.intendedValues.contains(bikeTag))) {
                accept = EncodingManager.Access.FERRY;
            }
            if (way.hasTag("railway", (Object)"platform")) {
                accept = EncodingManager.Access.WAY;
            }
            if (way.hasTag("man_made", (Object)"pier")) {
                accept = EncodingManager.Access.WAY;
            }
            if (!accept.canSkip()) {
                if (way.hasTag(this.restrictions, (Set<String>)this.restrictedValues) && !this.getConditionalTagInspector().isRestrictedWayConditionallyPermitted(way)) {
                    return EncodingManager.Access.CAN_SKIP;
                }
                return accept;
            }
            return EncodingManager.Access.CAN_SKIP;
        }
        if (!this.highwaySpeeds.containsKey(highwayValue)) {
            return EncodingManager.Access.CAN_SKIP;
        }
        String sacScale = way.getTag("sac_scale");
        if (sacScale != null) {
            if (way.hasTag("highway", (Object)"cycleway") && way.hasTag("sac_scale", (Object)"hiking")) {
                return EncodingManager.Access.WAY;
            }
            if (!this.isSacScaleAllowed(sacScale)) {
                return EncodingManager.Access.CAN_SKIP;
            }
        }
        if (way.hasTag("bicycle", (Set<String>)this.intendedValues) || way.hasTag("bicycle", (Object)"dismount") || way.hasTag("highway", (Object)"cycleway")) {
            return EncodingManager.Access.WAY;
        }
        if ("motorway".equals(highwayValue) || "motorway_link".equals(highwayValue)) {
            return EncodingManager.Access.CAN_SKIP;
        }
        if (way.hasTag("motorroad", (Object)"yes")) {
            return EncodingManager.Access.CAN_SKIP;
        }
        if (this.isBlockFords() && (way.hasTag("highway", (Object)"ford") || way.hasTag("ford", new String[0]))) {
            return EncodingManager.Access.CAN_SKIP;
        }
        if (way.hasTag(this.restrictions, (Set<String>)this.restrictedValues) && !this.getConditionalTagInspector().isRestrictedWayConditionallyPermitted(way)) {
            return EncodingManager.Access.CAN_SKIP;
        }
        if (this.getConditionalTagInspector().isPermittedWayConditionallyRestricted(way)) {
            return EncodingManager.Access.CAN_SKIP;
        }
        return EncodingManager.Access.WAY;
    }

    boolean isSacScaleAllowed(String sacScale) {
        return "hiking".equals(sacScale);
    }

    @Override
    public long handleRelationTags(long oldRelationFlags, ReaderRelation relation) {
        int code = 0;
        if (relation.hasTag("route", (Object)"bicycle")) {
            Integer val = this.bikeNetworkToCode.get(relation.getTag("network"));
            code = val != null ? val.intValue() : PriorityCode.PREFER.getValue();
        } else if (relation.hasTag("route", (Object)"ferry")) {
            code = PriorityCode.AVOID_IF_POSSIBLE.getValue();
        }
        int oldCode = (int)this.relationCodeEncoder.getValue(oldRelationFlags);
        if (oldCode < code) {
            return this.relationCodeEncoder.setValue(0L, code);
        }
        return oldRelationFlags;
    }

    @Override
    protected double applyMaxSpeed(ReaderWay way, double speed) {
        double maxSpeed = this.getMaxSpeed(way);
        if (maxSpeed >= 0.0 && speed > maxSpeed) {
            return maxSpeed;
        }
        if (speed > (double)this.maxPossibleSpeed) {
            return this.maxPossibleSpeed;
        }
        return speed;
    }

    @Override
    public IntsRef handleWayTags(IntsRef edgeFlags, ReaderWay way, EncodingManager.Access access, long relationFlags) {
        if (access.canSkip()) {
            return edgeFlags;
        }
        double wayTypeSpeed = this.getSpeed(way);
        if (!access.isFerry()) {
            wayTypeSpeed = this.applyMaxSpeed(way, wayTypeSpeed);
            this.handleSpeed(edgeFlags, way, wayTypeSpeed);
            this.handleBikeRelated(edgeFlags, way, relationFlags > (long)PriorityCode.UNCHANGED.getValue());
        } else {
            double ferrySpeed = this.getFerrySpeed(way);
            this.handleSpeed(edgeFlags, way, ferrySpeed);
            this.accessEnc.setBool(false, edgeFlags, true);
            this.accessEnc.setBool(true, edgeFlags, true);
        }
        int priorityFromRelation = 0;
        if (relationFlags != 0L) {
            priorityFromRelation = (int)this.relationCodeEncoder.getValue(relationFlags);
        }
        this.priorityWayEncoder.setDecimal(false, edgeFlags, PriorityCode.getFactor(this.handlePriority(way, wayTypeSpeed, priorityFromRelation)));
        return edgeFlags;
    }

    int getSpeed(ReaderWay way) {
        String s;
        int speed = 4;
        String highwayTag = way.getTag("highway");
        Integer highwaySpeed = this.highwaySpeeds.get(highwayTag);
        if (way.hasTag("highway", this.pushingSectionsHighways) && (way.hasTag("foot", (Object)"yes") && way.hasTag("segregated", (Object)"yes") || way.hasTag("bicycle", (Object)"designated") || way.hasTag("bicycle", (Object)"official"))) {
            highwaySpeed = this.getHighwaySpeed("cycleway");
        }
        if (!Helper.isEmpty((String)(s = way.getTag("surface")))) {
            Integer surfaceSpeed = this.surfaceSpeeds.get(s);
            if (surfaceSpeed != null) {
                speed = surfaceSpeed;
                if (highwaySpeed != null && surfaceSpeed > highwaySpeed) {
                    speed = this.pushingSectionsHighways.contains(highwayTag) ? highwaySpeed.intValue() : surfaceSpeed.intValue();
                }
            }
        } else {
            String tt = way.getTag("tracktype");
            if (!Helper.isEmpty((String)tt)) {
                Integer tInt = this.trackTypeSpeeds.get(tt);
                if (tInt != null) {
                    speed = tInt;
                }
            } else if (highwaySpeed != null) {
                speed = !way.hasTag("service", new String[0]) ? highwaySpeed.intValue() : this.highwaySpeeds.get("living_street").intValue();
            }
        }
        if (speed > 4 && (way.hasTag("highway", this.pushingSectionsHighways) || way.hasTag("bicycle", (Object)"dismount"))) {
            speed = !way.hasTag("bicycle", (Set<String>)this.intendedValues) ? (way.hasTag("highway", (Object)"steps") ? 2 : 4) : (way.hasTag("bicycle", (Object)"designated") || way.hasTag("bicycle", (Object)"official") ? this.highwaySpeeds.get("cycleway") : 4);
            if (speed <= 4 && way.hasTag("segregated", (Object)"yes")) {
                speed = 8;
            }
        }
        return speed;
    }

    @Override
    public InstructionAnnotation getAnnotation(IntsRef edgeFlags, Translation tr) {
        int paveType = 0;
        if (this.unpavedEncoder.getBool(false, edgeFlags)) {
            paveType = 1;
        }
        int wayType = this.wayTypeEncoder.getInt(false, edgeFlags);
        String wayName = this.getWayName(paveType, wayType, tr);
        return new InstructionAnnotation(0, wayName);
    }

    String getWayName(int pavementType, int wayType, Translation tr) {
        String pavementName = "";
        if (pavementType == 1) {
            pavementName = tr.tr("unpaved", new Object[0]);
        }
        String wayTypeName = "";
        switch (wayType) {
            case 0: {
                wayTypeName = "";
                break;
            }
            case 1: {
                wayTypeName = tr.tr("off_bike", new Object[0]);
                break;
            }
            case 2: {
                wayTypeName = tr.tr("cycleway", new Object[0]);
                break;
            }
            case 3: {
                wayTypeName = tr.tr("small_way", new Object[0]);
            }
        }
        if (pavementName.isEmpty()) {
            if (wayType == 0 || wayType == 3) {
                return "";
            }
            return wayTypeName;
        }
        if (wayTypeName.isEmpty()) {
            return pavementName;
        }
        return wayTypeName + ", " + pavementName;
    }

    protected int handlePriority(ReaderWay way, double wayTypeSpeed, int priorityFromRelation) {
        TreeMap<Double, Integer> weightToPrioMap = new TreeMap<Double, Integer>();
        if (priorityFromRelation == 0) {
            weightToPrioMap.put(0.0, PriorityCode.UNCHANGED.getValue());
        } else {
            weightToPrioMap.put(110.0, priorityFromRelation);
        }
        this.collect(way, wayTypeSpeed, weightToPrioMap);
        return weightToPrioMap.lastEntry().getValue();
    }

    private PriorityCode convertClassValueToPriority(String tagvalue) {
        int classvalue;
        try {
            classvalue = Integer.parseInt(tagvalue);
        }
        catch (NumberFormatException e) {
            return PriorityCode.UNCHANGED;
        }
        switch (classvalue) {
            case 3: {
                return PriorityCode.BEST;
            }
            case 2: {
                return PriorityCode.VERY_NICE;
            }
            case 1: {
                return PriorityCode.PREFER;
            }
            case 0: {
                return PriorityCode.UNCHANGED;
            }
            case -1: {
                return PriorityCode.AVOID_IF_POSSIBLE;
            }
            case -2: {
                return PriorityCode.REACH_DEST;
            }
            case -3: {
                return PriorityCode.AVOID_AT_ALL_COSTS;
            }
        }
        return PriorityCode.UNCHANGED;
    }

    void collect(ReaderWay way, double wayTypeSpeed, TreeMap<Double, Integer> weightToPrioMap) {
        String classBicycleValue;
        String service = way.getTag("service");
        String highway = way.getTag("highway");
        if (way.hasTag("bicycle", (Object)"designated") || way.hasTag("bicycle", (Object)"official")) {
            if ("path".equals(highway)) {
                weightToPrioMap.put(100.0, PriorityCode.VERY_NICE.getValue());
            } else {
                weightToPrioMap.put(100.0, PriorityCode.PREFER.getValue());
            }
        }
        if ("cycleway".equals(highway)) {
            if (way.hasTag("foot", (Set<String>)this.intendedValues) && !way.hasTag("segregated", (Object)"yes")) {
                weightToPrioMap.put(100.0, PriorityCode.PREFER.getValue());
            } else {
                weightToPrioMap.put(100.0, PriorityCode.VERY_NICE.getValue());
            }
        }
        double maxSpeed = this.getMaxSpeed(way);
        if (this.preferHighwayTags.contains(highway) || maxSpeed > 0.0 && maxSpeed <= 30.0) {
            if (maxSpeed < (double)this.avoidSpeedLimit) {
                weightToPrioMap.put(40.0, PriorityCode.PREFER.getValue());
                if (way.hasTag("tunnel", (Set<String>)this.intendedValues)) {
                    weightToPrioMap.put(40.0, PriorityCode.UNCHANGED.getValue());
                }
            }
        } else if (this.avoidHighwayTags.contains(highway) || maxSpeed >= (double)this.avoidSpeedLimit && !"track".equals(highway)) {
            weightToPrioMap.put(50.0, PriorityCode.REACH_DEST.getValue());
            if (way.hasTag("tunnel", (Set<String>)this.intendedValues)) {
                weightToPrioMap.put(50.0, PriorityCode.AVOID_AT_ALL_COSTS.getValue());
            }
        }
        if (this.pushingSectionsHighways.contains(highway) || way.hasTag("bicycle", (Object)"use_sidepath") || "parking_aisle".equals(service)) {
            int pushingSectionPrio = PriorityCode.AVOID_IF_POSSIBLE.getValue();
            if (way.hasTag("bicycle", (Object)"yes") || way.hasTag("bicycle", (Object)"permissive")) {
                pushingSectionPrio = PriorityCode.PREFER.getValue();
            }
            if (way.hasTag("bicycle", (Object)"designated") || way.hasTag("bicycle", (Object)"official")) {
                pushingSectionPrio = PriorityCode.VERY_NICE.getValue();
            }
            if (way.hasTag("foot", (Object)"yes")) {
                pushingSectionPrio = Math.max(pushingSectionPrio - 1, PriorityCode.WORST.getValue());
                if (way.hasTag("segregated", (Object)"yes")) {
                    pushingSectionPrio = Math.min(pushingSectionPrio + 1, PriorityCode.BEST.getValue());
                }
            }
            weightToPrioMap.put(100.0, pushingSectionPrio);
        }
        if (way.hasTag("railway", (Object)"tram")) {
            weightToPrioMap.put(50.0, PriorityCode.AVOID_AT_ALL_COSTS.getValue());
        }
        if ((classBicycleValue = way.getTag(this.classBicycleKey)) != null) {
            weightToPrioMap.put(100.0, this.convertClassValueToPriority(classBicycleValue).getValue());
        } else {
            String classBicycle = way.getTag("class:bicycle");
            if (classBicycle != null) {
                weightToPrioMap.put(100.0, this.convertClassValueToPriority(classBicycle).getValue());
            }
        }
        if ((way.hasTag("scenic", (Object)"yes") || maxSpeed > 0.0 && maxSpeed < wayTypeSpeed) && weightToPrioMap.lastEntry().getValue() < PriorityCode.BEST.getValue()) {
            weightToPrioMap.put(110.0, weightToPrioMap.lastEntry().getValue() + 1);
        }
    }

    void handleBikeRelated(IntsRef edgeFlags, ReaderWay way, boolean partOfCycleRelation) {
        String surfaceTag = way.getTag("surface");
        String highway = way.getTag("highway");
        String trackType = way.getTag("tracktype");
        if ("track".equals(highway) && (trackType == null || !"grade1".equals(trackType)) || "path".equals(highway) && surfaceTag == null || this.unpavedSurfaceTags.contains(surfaceTag)) {
            this.unpavedEncoder.setBool(false, edgeFlags, true);
        }
        WayType wayType = this.roadValues.contains(highway) ? WayType.ROAD : WayType.OTHER_SMALL_WAY;
        boolean isPushingSection = this.isPushingSection(way);
        if (isPushingSection && !partOfCycleRelation || "steps".equals(highway)) {
            wayType = WayType.PUSHING_SECTION;
        }
        if (way.hasTag("bicycle", (Set<String>)this.intendedValues)) {
            if (isPushingSection && !way.hasTag("bicycle", (Object)"designated")) {
                wayType = WayType.OTHER_SMALL_WAY;
            } else if (wayType == WayType.OTHER_SMALL_WAY || wayType == WayType.PUSHING_SECTION) {
                wayType = WayType.CYCLEWAY;
            }
        } else if ("cycleway".equals(highway)) {
            wayType = WayType.CYCLEWAY;
        }
        this.wayTypeEncoder.setInt(false, edgeFlags, wayType.getValue());
    }

    boolean isPushingSection(ReaderWay way) {
        return way.hasTag("highway", this.pushingSectionsHighways) || way.hasTag("railway", (Object)"platform") || way.hasTag("bicycle", (Object)"dismount");
    }

    protected void handleSpeed(IntsRef edgeFlags, ReaderWay way, double speed) {
        boolean isOneway;
        this.speedEncoder.setDecimal(false, edgeFlags, speed);
        boolean bl = isOneway = way.hasTag("oneway", (Set<String>)this.oneways) || way.hasTag("oneway:bicycle", (Set<String>)this.oneways) || way.hasTag("vehicle:backward", new String[0]) || way.hasTag("vehicle:forward", new String[0]) || way.hasTag("bicycle:forward", new String[0]);
        if (!(!isOneway && !this.roundaboutEnc.getBool(false, edgeFlags) || way.hasTag("oneway:bicycle", (Object)"no") || way.hasTag("bicycle:backward", new String[0]) || way.hasTag("cycleway", this.oppositeLanes) || way.hasTag("cycleway:left", this.oppositeLanes) || way.hasTag("cycleway:right", this.oppositeLanes))) {
            boolean isBackward;
            boolean bl2 = isBackward = way.hasTag("oneway", (Object)"-1") || way.hasTag("oneway:bicycle", (Object)"-1") || way.hasTag("vehicle:forward", (Object)"no") || way.hasTag("bicycle:forward", (Object)"no");
            if (isBackward) {
                this.accessEnc.setBool(true, edgeFlags, true);
            } else {
                this.accessEnc.setBool(false, edgeFlags, true);
            }
        } else {
            this.accessEnc.setBool(false, edgeFlags, true);
            this.accessEnc.setBool(true, edgeFlags, true);
        }
    }

    protected void setHighwaySpeed(String highway, int speed) {
        this.highwaySpeeds.put(highway, speed);
    }

    protected int getHighwaySpeed(String key) {
        return this.highwaySpeeds.get(key);
    }

    void setTrackTypeSpeed(String tracktype, int speed) {
        this.trackTypeSpeeds.put(tracktype, speed);
    }

    void setSurfaceSpeed(String surface, int speed) {
        this.surfaceSpeeds.put(surface, speed);
    }

    void setCyclingNetworkPreference(String network, int code) {
        this.bikeNetworkToCode.put(network, code);
    }

    void addPushingSection(String highway) {
        this.pushingSectionsHighways.add(highway);
    }

    @Override
    public boolean supports(Class<?> feature) {
        if (super.supports(feature)) {
            return true;
        }
        return PriorityWeighting.class.isAssignableFrom(feature);
    }

    public void setAvoidSpeedLimit(int limit) {
        this.avoidSpeedLimit = limit;
    }

    protected void setSpecificClassBicycle(String subkey) {
        this.classBicycleKey = "class:bicycle:" + subkey;
    }

    private static enum WayType {
        ROAD(0),
        PUSHING_SECTION(1),
        CYCLEWAY(2),
        OTHER_SMALL_WAY(3);

        private final int value;

        private WayType(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }
}

