/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util;

import com.graphhopper.reader.ReaderRelation;
import com.graphhopper.reader.ReaderWay;
import com.graphhopper.routing.profiles.EncodedValue;
import com.graphhopper.routing.profiles.FactorizedDecimalEncodedValue;
import com.graphhopper.routing.util.AbstractFlagEncoder;
import com.graphhopper.routing.util.EncodingManager;
import com.graphhopper.storage.IntsRef;
import com.graphhopper.util.Helper;
import com.graphhopper.util.PMap;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CarFlagEncoder
extends AbstractFlagEncoder {
    protected final Map<String, Integer> trackTypeSpeedMap = new HashMap<String, Integer>();
    protected final Set<String> badSurfaceSpeedMap = new HashSet<String>();
    protected int badSurfaceSpeed;
    protected int destinationSpeed;
    protected boolean speedTwoDirections;
    protected final Map<String, Integer> defaultSpeedMap = new HashMap<String, Integer>();

    public CarFlagEncoder() {
        this(5, 5.0, 0);
    }

    public CarFlagEncoder(PMap properties) {
        this((int)properties.getLong("speed_bits", 5L), properties.getDouble("speed_factor", 5.0), properties.getBool("turn_costs", false) ? 1 : 0);
        this.properties = properties;
        this.speedTwoDirections = properties.getBool("speed_two_directions", false);
        this.setBlockFords(properties.getBool("block_fords", true));
        this.setBlockByDefault(properties.getBool("block_barriers", true));
    }

    public CarFlagEncoder(String propertiesStr) {
        this(new PMap(propertiesStr));
    }

    public CarFlagEncoder(int speedBits, double speedFactor, int maxTurnCosts) {
        super(speedBits, speedFactor, maxTurnCosts);
        this.restrictions.addAll(Arrays.asList("motorcar", "motor_vehicle", "vehicle", "access"));
        this.restrictedValues.add("private");
        this.restrictedValues.add("agricultural");
        this.restrictedValues.add("forestry");
        this.restrictedValues.add("no");
        this.restrictedValues.add("restricted");
        this.restrictedValues.add("delivery");
        this.restrictedValues.add("military");
        this.restrictedValues.add("emergency");
        this.intendedValues.add("yes");
        this.intendedValues.add("permissive");
        this.potentialBarriers.add("gate");
        this.potentialBarriers.add("lift_gate");
        this.potentialBarriers.add("kissing_gate");
        this.potentialBarriers.add("swing_gate");
        this.potentialBarriers.add("cattle_grid");
        this.absoluteBarriers.add("fence");
        this.absoluteBarriers.add("bollard");
        this.absoluteBarriers.add("stile");
        this.absoluteBarriers.add("turnstile");
        this.absoluteBarriers.add("cycle_barrier");
        this.absoluteBarriers.add("motorcycle_barrier");
        this.absoluteBarriers.add("block");
        this.absoluteBarriers.add("bus_trap");
        this.absoluteBarriers.add("sump_buster");
        this.trackTypeSpeedMap.put("grade1", 20);
        this.trackTypeSpeedMap.put("grade2", 15);
        this.trackTypeSpeedMap.put("grade3", 10);
        this.badSurfaceSpeedMap.add("cobblestone");
        this.badSurfaceSpeedMap.add("grass_paver");
        this.badSurfaceSpeedMap.add("gravel");
        this.badSurfaceSpeedMap.add("sand");
        this.badSurfaceSpeedMap.add("paving_stones");
        this.badSurfaceSpeedMap.add("dirt");
        this.badSurfaceSpeedMap.add("ground");
        this.badSurfaceSpeedMap.add("grass");
        this.badSurfaceSpeedMap.add("unpaved");
        this.badSurfaceSpeedMap.add("compacted");
        this.defaultSpeedMap.put("motorway", 100);
        this.defaultSpeedMap.put("motorway_link", 70);
        this.defaultSpeedMap.put("motorroad", 90);
        this.defaultSpeedMap.put("trunk", 70);
        this.defaultSpeedMap.put("trunk_link", 65);
        this.defaultSpeedMap.put("primary", 65);
        this.defaultSpeedMap.put("primary_link", 60);
        this.defaultSpeedMap.put("secondary", 60);
        this.defaultSpeedMap.put("secondary_link", 50);
        this.defaultSpeedMap.put("tertiary", 50);
        this.defaultSpeedMap.put("tertiary_link", 40);
        this.defaultSpeedMap.put("unclassified", 30);
        this.defaultSpeedMap.put("residential", 30);
        this.defaultSpeedMap.put("living_street", 5);
        this.defaultSpeedMap.put("service", 20);
        this.defaultSpeedMap.put("road", 20);
        this.defaultSpeedMap.put("track", 15);
        this.badSurfaceSpeed = 30;
        this.destinationSpeed = 5;
        this.maxPossibleSpeed = 140;
        this.speedDefault = this.defaultSpeedMap.get("secondary").intValue();
        this.init();
    }

    @Override
    public int getVersion() {
        return 2;
    }

    @Override
    public void createEncodedValues(List<EncodedValue> registerNewEncodedValue, String prefix, int index) {
        super.createEncodedValues(registerNewEncodedValue, prefix, index);
        this.speedEncoder = new FactorizedDecimalEncodedValue(prefix + "average_speed", this.speedBits, this.speedFactor, this.speedTwoDirections);
        registerNewEncodedValue.add(this.speedEncoder);
    }

    protected double getSpeed(ReaderWay way) {
        Integer tInt;
        String tt;
        Integer speed;
        String highwayValue = way.getTag("highway");
        if (!Helper.isEmpty((String)highwayValue) && way.hasTag("motorroad", (Object)"yes") && highwayValue != "motorway" && highwayValue != "motorway_link") {
            highwayValue = "motorroad";
        }
        if ((speed = this.defaultSpeedMap.get(highwayValue)) == null) {
            throw new IllegalStateException(this.toString() + ", no speed found for: " + highwayValue + ", tags: " + way);
        }
        if (highwayValue.equals("track") && !Helper.isEmpty((String)(tt = way.getTag("tracktype"))) && (tInt = this.trackTypeSpeedMap.get(tt)) != null) {
            speed = tInt;
        }
        return speed.intValue();
    }

    @Override
    public EncodingManager.Access getAccess(ReaderWay way) {
        String tt;
        String highwayValue = way.getTag("highway");
        String firstValue = way.getFirstPriorityTag(this.restrictions);
        if (highwayValue == null) {
            if (way.hasTag("route", (Set<String>)this.ferries)) {
                if (this.restrictedValues.contains(firstValue)) {
                    return EncodingManager.Access.CAN_SKIP;
                }
                if (this.intendedValues.contains(firstValue) || firstValue.isEmpty() && !way.hasTag("foot", new String[0]) && !way.hasTag("bicycle", new String[0])) {
                    return EncodingManager.Access.FERRY;
                }
            }
            return EncodingManager.Access.CAN_SKIP;
        }
        if ("track".equals(highwayValue) && (tt = way.getTag("tracktype")) != null && !tt.equals("grade1") && !tt.equals("grade2") && !tt.equals("grade3")) {
            return EncodingManager.Access.CAN_SKIP;
        }
        if (!this.defaultSpeedMap.containsKey(highwayValue)) {
            return EncodingManager.Access.CAN_SKIP;
        }
        if (way.hasTag("impassable", (Object)"yes") || way.hasTag("status", (Object)"impassable")) {
            return EncodingManager.Access.CAN_SKIP;
        }
        if (!firstValue.isEmpty()) {
            if (this.restrictedValues.contains(firstValue) && !this.getConditionalTagInspector().isRestrictedWayConditionallyPermitted(way)) {
                return EncodingManager.Access.CAN_SKIP;
            }
            if (this.intendedValues.contains(firstValue)) {
                return EncodingManager.Access.WAY;
            }
        }
        if (this.isBlockFords() && ("ford".equals(highwayValue) || way.hasTag("ford", new String[0]))) {
            return EncodingManager.Access.CAN_SKIP;
        }
        if (this.getConditionalTagInspector().isPermittedWayConditionallyRestricted(way)) {
            return EncodingManager.Access.CAN_SKIP;
        }
        return EncodingManager.Access.WAY;
    }

    @Override
    public long handleRelationTags(long oldRelationFlags, ReaderRelation relation) {
        return oldRelationFlags;
    }

    @Override
    public IntsRef handleWayTags(IntsRef edgeFlags, ReaderWay way, EncodingManager.Access accept, long relationFlags) {
        if (accept.canSkip()) {
            return edgeFlags;
        }
        if (!accept.isFerry()) {
            double speed = this.getSpeed(way);
            speed = this.applyMaxSpeed(way, speed);
            speed = this.applyBadSurfaceSpeed(way, speed);
            this.setSpeed(false, edgeFlags, speed);
            this.setSpeed(true, edgeFlags, speed);
            boolean isRoundabout = this.roundaboutEnc.getBool(false, edgeFlags);
            if (this.isOneway(way) || isRoundabout) {
                if (this.isForwardOneway(way)) {
                    this.accessEnc.setBool(false, edgeFlags, true);
                }
                if (this.isBackwardOneway(way)) {
                    this.accessEnc.setBool(true, edgeFlags, true);
                }
            } else {
                this.accessEnc.setBool(false, edgeFlags, true);
                this.accessEnc.setBool(true, edgeFlags, true);
            }
        } else {
            double ferrySpeed = this.getFerrySpeed(way);
            this.accessEnc.setBool(false, edgeFlags, true);
            this.accessEnc.setBool(true, edgeFlags, true);
            this.setSpeed(false, edgeFlags, ferrySpeed);
            this.setSpeed(true, edgeFlags, ferrySpeed);
        }
        for (String restriction : this.restrictions) {
            if (!way.hasTag(restriction, (Object)"destination")) continue;
            this.setSpeed(false, edgeFlags, this.destinationSpeed);
            this.setSpeed(true, edgeFlags, this.destinationSpeed);
        }
        return edgeFlags;
    }

    protected boolean isBackwardOneway(ReaderWay way) {
        return way.hasTag("oneway", (Object)"-1") || way.hasTag("vehicle:forward", (Object)"no") || way.hasTag("motor_vehicle:forward", (Object)"no");
    }

    protected boolean isForwardOneway(ReaderWay way) {
        return !way.hasTag("oneway", (Object)"-1") && !way.hasTag("vehicle:forward", (Object)"no") && !way.hasTag("motor_vehicle:forward", (Object)"no");
    }

    protected boolean isOneway(ReaderWay way) {
        return way.hasTag("oneway", (Set<String>)this.oneways) || way.hasTag("vehicle:backward", new String[0]) || way.hasTag("vehicle:forward", new String[0]) || way.hasTag("motor_vehicle:backward", new String[0]) || way.hasTag("motor_vehicle:forward", new String[0]);
    }

    public String getWayInfo(ReaderWay way) {
        String destination;
        String str = "";
        String highwayValue = way.getTag("highway");
        if ("motorway_link".equals(highwayValue) && !Helper.isEmpty((String)(destination = way.getTag("destination")))) {
            int counter = 0;
            for (String d : destination.split(";")) {
                if (d.trim().isEmpty()) continue;
                if (counter > 0) {
                    str = str + ", ";
                }
                str = str + d.trim();
                ++counter;
            }
        }
        if (str.isEmpty()) {
            return str;
        }
        if (str.contains(",")) {
            return "destinations: " + str;
        }
        return "destination: " + str;
    }

    protected double applyBadSurfaceSpeed(ReaderWay way, double speed) {
        if (this.badSurfaceSpeed > 0 && speed > (double)this.badSurfaceSpeed && way.hasTag("surface", this.badSurfaceSpeedMap)) {
            speed = this.badSurfaceSpeed;
        }
        return speed;
    }

    public String toString() {
        return "car";
    }
}

