/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.weighting;

import com.graphhopper.routing.profiles.BooleanEncodedValue;
import com.graphhopper.routing.profiles.DecimalEncodedValue;
import com.graphhopper.routing.util.FlagEncoder;
import com.graphhopper.routing.util.HintsMap;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.Helper;

public abstract class AbstractWeighting
implements Weighting {
    protected final FlagEncoder flagEncoder;
    protected final DecimalEncodedValue avSpeedEnc;
    protected final BooleanEncodedValue accessEnc;

    protected AbstractWeighting(FlagEncoder encoder) {
        this.flagEncoder = encoder;
        if (!this.flagEncoder.isRegistered()) {
            throw new IllegalStateException("Make sure you add the FlagEncoder " + this.flagEncoder + " to an EncodingManager before using it elsewhere");
        }
        if (!AbstractWeighting.isValidName(this.getName())) {
            throw new IllegalStateException("Not a valid name for a Weighting: " + this.getName());
        }
        this.avSpeedEnc = encoder.getAverageSpeedEnc();
        this.accessEnc = encoder.getAccessEnc();
    }

    @Override
    public long calcMillis(EdgeIteratorState edgeState, boolean reverse, int prevOrNextEdgeId) {
        double speed;
        if (reverse && !edgeState.getReverse(this.accessEnc) || !reverse && !edgeState.get(this.accessEnc)) {
            throw new IllegalStateException("Calculating time should not require to read speed from edge in wrong direction. (" + edgeState.getBaseNode() + " - " + edgeState.getAdjNode() + ") " + edgeState.fetchWayGeometry(3) + " " + edgeState.getDistance() + " Reverse:" + reverse + ", fwd:" + edgeState.get(this.accessEnc) + ", bwd:" + edgeState.getReverse(this.accessEnc));
        }
        double d = speed = reverse ? edgeState.getReverse(this.avSpeedEnc) : edgeState.get(this.avSpeedEnc);
        if (Double.isInfinite(speed) || Double.isNaN(speed) || speed < 0.0) {
            throw new IllegalStateException("Invalid speed stored in edge! " + speed);
        }
        if (speed == 0.0) {
            throw new IllegalStateException("Speed cannot be 0 for unblocked edge, use access properties to mark edge blocked! Should only occur for shortest path calculation. See #242.");
        }
        return (long)(edgeState.getDistance() * 3600.0 / speed);
    }

    @Override
    public boolean matches(HintsMap reqMap) {
        return this.getName().equals(reqMap.getWeighting()) && this.flagEncoder.toString().equals(reqMap.getVehicle());
    }

    @Override
    public FlagEncoder getFlagEncoder() {
        return this.flagEncoder;
    }

    public int hashCode() {
        int hash = 7;
        hash = 71 * hash + this.toString().hashCode();
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Weighting other = (Weighting)obj;
        return this.toString().equals(other.toString());
    }

    static final boolean isValidName(String name) {
        if (name == null || name.isEmpty()) {
            return false;
        }
        return name.matches("[\\|_a-z]+");
    }

    public static String weightingToFileName(Weighting w, boolean edgeBased) {
        return Helper.toLowerCase((String)w.toString()).replaceAll("\\|", "_") + (edgeBased ? "_edge" : "_node");
    }

    public String toString() {
        return this.getName() + "|" + this.flagEncoder;
    }
}

