/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.weighting;

import com.graphhopper.routing.util.FlagEncoder;
import com.graphhopper.routing.util.HintsMap;
import com.graphhopper.routing.util.TurnCostEncoder;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.storage.TurnCostExtension;
import com.graphhopper.util.EdgeIteratorState;

public class TurnWeighting
implements Weighting {
    private final TurnCostEncoder turnCostEncoder;
    private final TurnCostExtension turnCostExt;
    private final Weighting superWeighting;
    private double defaultUTurnCost = 40.0;

    public TurnWeighting(Weighting superWeighting, TurnCostExtension turnCostExt) {
        this.turnCostEncoder = superWeighting.getFlagEncoder();
        this.superWeighting = superWeighting;
        this.turnCostExt = turnCostExt;
        if (turnCostExt == null) {
            throw new RuntimeException("No storage set to calculate turn weight");
        }
    }

    public TurnWeighting setDefaultUTurnCost(double costInSeconds) {
        this.defaultUTurnCost = costInSeconds;
        return this;
    }

    @Override
    public double getMinWeight(double distance) {
        return this.superWeighting.getMinWeight(distance);
    }

    @Override
    public double calcWeight(EdgeIteratorState edgeState, boolean reverse, int prevOrNextEdgeId) {
        double turnCosts;
        double weight = this.superWeighting.calcWeight(edgeState, reverse, prevOrNextEdgeId);
        if (prevOrNextEdgeId == -1) {
            return weight;
        }
        int origEdgeId = reverse ? edgeState.getOrigEdgeLast() : edgeState.getOrigEdgeFirst();
        double d = turnCosts = reverse ? this.calcTurnWeight(origEdgeId, edgeState.getBaseNode(), prevOrNextEdgeId) : this.calcTurnWeight(prevOrNextEdgeId, edgeState.getBaseNode(), origEdgeId);
        if (turnCosts == 0.0 && origEdgeId == prevOrNextEdgeId) {
            return weight + this.defaultUTurnCost;
        }
        return weight + turnCosts;
    }

    @Override
    public long calcMillis(EdgeIteratorState edgeState, boolean reverse, int prevOrNextEdgeId) {
        long millis = this.superWeighting.calcMillis(edgeState, reverse, prevOrNextEdgeId);
        if (prevOrNextEdgeId == -1) {
            return millis;
        }
        long turnCostsInMillis = reverse ? (long)this.calcTurnWeight(edgeState.getEdge(), edgeState.getBaseNode(), prevOrNextEdgeId) : (long)this.calcTurnWeight(prevOrNextEdgeId, edgeState.getBaseNode(), edgeState.getEdge());
        return millis + turnCostsInMillis;
    }

    public double calcTurnWeight(int edgeFrom, int nodeVia, int edgeTo) {
        long turnFlags = this.turnCostExt.getTurnCostFlags(edgeFrom, nodeVia, edgeTo);
        if (this.turnCostEncoder.isTurnRestricted(turnFlags)) {
            return Double.POSITIVE_INFINITY;
        }
        return this.turnCostEncoder.getTurnCost(turnFlags);
    }

    @Override
    public FlagEncoder getFlagEncoder() {
        return this.superWeighting.getFlagEncoder();
    }

    @Override
    public boolean matches(HintsMap weightingMap) {
        return this.superWeighting.matches(weightingMap);
    }

    public String toString() {
        return "turn|" + this.superWeighting.toString();
    }

    @Override
    public String getName() {
        return "turn|" + this.superWeighting.getName();
    }
}

