/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.storage;

import com.graphhopper.routing.ch.NodeOrderingProvider;
import com.graphhopper.routing.ch.PrepareEncoder;
import com.graphhopper.routing.profiles.BooleanEncodedValue;
import com.graphhopper.routing.util.AllCHEdgesIterator;
import com.graphhopper.routing.util.EdgeFilter;
import com.graphhopper.routing.weighting.AbstractWeighting;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.storage.BaseGraph;
import com.graphhopper.storage.CHGraph;
import com.graphhopper.storage.DAType;
import com.graphhopper.storage.DataAccess;
import com.graphhopper.storage.Directory;
import com.graphhopper.storage.EdgeAccess;
import com.graphhopper.storage.Graph;
import com.graphhopper.storage.GraphExtension;
import com.graphhopper.storage.IntsRef;
import com.graphhopper.storage.NodeAccess;
import com.graphhopper.storage.Storable;
import com.graphhopper.util.CHEdgeExplorer;
import com.graphhopper.util.CHEdgeIterator;
import com.graphhopper.util.CHEdgeIteratorState;
import com.graphhopper.util.EdgeExplorer;
import com.graphhopper.util.EdgeIterator;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.Helper;
import com.graphhopper.util.PointList;
import com.graphhopper.util.shapes.BBox;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CHGraphImpl
implements CHGraph,
Storable<CHGraph> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CHGraphImpl.class);
    private static final double WEIGHT_FACTOR = 1000.0;
    private static final int MAX_WEIGHT_31 = 0x7FFFFFFC;
    private static final double MAX_WEIGHT = 536870.911;
    private static final double MIN_WEIGHT = 0.001;
    final DataAccess shortcuts;
    final DataAccess nodesCH;
    final int scDirMask = PrepareEncoder.getScDirMask();
    private final boolean edgeBased;
    private final BaseGraph baseGraph;
    private final CHEdgeAccess chEdgeAccess;
    private final Weighting weighting;
    int N_CH_REF;
    int shortcutEntryBytes;
    int nodeCHEntryBytes;
    final int shortcutBytesForFlags = 4;
    private int N_LEVEL;
    private int S_SKIP_EDGE1;
    private int S_SKIP_EDGE2;
    private int S_ORIG_FIRST;
    private int S_ORIG_LAST;
    private int shortcutCount = 0;
    private boolean isReadyForContraction;

    CHGraphImpl(Weighting w, Directory dir, BaseGraph baseGraph, boolean edgeBased) {
        if (w == null) {
            throw new IllegalStateException("Weighting for CHGraph cannot be null");
        }
        this.weighting = w;
        this.baseGraph = baseGraph;
        String name = AbstractWeighting.weightingToFileName(w, edgeBased);
        this.edgeBased = edgeBased;
        this.nodesCH = dir.find("nodes_ch_" + name, DAType.getPreferredInt(dir.getDefaultType()));
        this.shortcuts = dir.find("shortcuts_" + name, DAType.getPreferredInt(dir.getDefaultType()));
        this.chEdgeAccess = new CHEdgeAccess(name);
    }

    public final Weighting getWeighting() {
        return this.weighting;
    }

    @Override
    public boolean isShortcut(int edgeId) {
        assert (this.baseGraph.isFrozen()) : "level graph not yet frozen";
        return edgeId >= this.baseGraph.edgeCount;
    }

    @Override
    public final void setLevel(int nodeIndex, int level) {
        this.checkNodeId(nodeIndex);
        this.nodesCH.setInt((long)nodeIndex * (long)this.nodeCHEntryBytes + (long)this.N_LEVEL, level);
    }

    @Override
    public final int getLevel(int nodeIndex) {
        this.checkNodeId(nodeIndex);
        return this.nodesCH.getInt((long)nodeIndex * (long)this.nodeCHEntryBytes + (long)this.N_LEVEL);
    }

    final void checkNodeId(int nodeId) {
        assert (nodeId < this.baseGraph.getNodes()) : "node " + nodeId + " is invalid. Not in [0," + this.baseGraph.getNodes() + ")";
    }

    @Override
    public CHEdgeIteratorState shortcut(int a, int b) {
        if (!this.baseGraph.isFrozen()) {
            throw new IllegalStateException("Cannot create shortcut if graph is not yet frozen");
        }
        this.checkNodeId(a);
        this.checkNodeId(b);
        int scId = this.chEdgeAccess.internalEdgeAdd(this.nextShortcutId(), a, b);
        CHEdgeIteratorImpl iter = new CHEdgeIteratorImpl(this.baseGraph, this.chEdgeAccess, EdgeFilter.ALL_EDGES);
        boolean ret = iter.init(scId, b);
        assert (ret);
        iter.setSkippedEdges(-1, -1);
        return iter;
    }

    @Override
    public int shortcut(int a, int b, int accessFlags, double weight, double distance, int skippedEdge1, int skippedEdge2) {
        if (!this.baseGraph.isFrozen()) {
            throw new IllegalStateException("Cannot create shortcut if graph is not yet frozen");
        }
        this.checkNodeId(a);
        this.checkNodeId(b);
        int scId = this.chEdgeAccess.internalEdgeAdd(this.nextShortcutId(), a, b);
        long edgePointer = this.chEdgeAccess.toPointer(scId);
        this.chEdgeAccess.setAccessAndWeight(edgePointer, accessFlags & this.scDirMask, weight);
        this.chEdgeAccess.setDist(edgePointer, distance);
        this.chEdgeAccess.setSkippedEdges(edgePointer, skippedEdge1, skippedEdge2);
        return scId;
    }

    @Override
    public int shortcutEdgeBased(int a, int b, int accessFlags, double weight, double distance, int skippedEdge1, int skippedEdge2, int origFirst, int origLast) {
        assert (this.edgeBased) : "Edge-based shortcuts should only be added when CHGraph is edge-based";
        int scId = this.shortcut(a, b, accessFlags, weight, distance, skippedEdge1, skippedEdge2);
        this.chEdgeAccess.setFirstAndLastOrigEdges(this.chEdgeAccess.toPointer(scId), origFirst, origLast);
        return scId;
    }

    protected int nextShortcutId() {
        int nextSC = this.shortcutCount++;
        if (this.shortcutCount < 0) {
            throw new IllegalStateException("too many shortcuts. new shortcut id would be negative. " + this.toString());
        }
        this.shortcuts.ensureCapacity(((long)this.shortcutCount + 1L) * (long)this.shortcutEntryBytes);
        return nextSC + this.baseGraph.edgeCount;
    }

    @Override
    public EdgeIteratorState edge(int a, int b, double distance, boolean bothDirections) {
        return this.edge(a, b).setDistance(distance).setFlags(this.baseGraph.encodingManager.flagsDefault(true, bothDirections));
    }

    @Override
    public CHEdgeIteratorState edge(int a, int b) {
        this.baseGraph.ensureNodeIndex(Math.max(a, b));
        int edgeId = this.baseGraph.edgeAccess.internalEdgeAdd(this.baseGraph.nextEdgeId(), a, b);
        CHEdgeIteratorImpl iter = new CHEdgeIteratorImpl(this.baseGraph, this.baseGraph.edgeAccess, EdgeFilter.ALL_EDGES);
        boolean ret = iter.init(edgeId, b);
        assert (ret);
        return iter;
    }

    @Override
    public CHEdgeExplorer createEdgeExplorer() {
        return this.createEdgeExplorer(EdgeFilter.ALL_EDGES);
    }

    @Override
    public CHEdgeExplorer createEdgeExplorer(EdgeFilter filter) {
        return new CHEdgeIteratorImpl(this.baseGraph, this.chEdgeAccess, filter);
    }

    @Override
    public EdgeExplorer createOriginalEdgeExplorer() {
        return this.createOriginalEdgeExplorer(EdgeFilter.ALL_EDGES);
    }

    @Override
    public EdgeExplorer createOriginalEdgeExplorer(EdgeFilter filter) {
        return this.baseGraph.createEdgeExplorer(filter);
    }

    @Override
    public final CHEdgeIteratorState getEdgeIteratorState(int edgeId, int endNode) {
        if (this.isShortcut(edgeId)) {
            if (!this.chEdgeAccess.isInBounds(edgeId)) {
                throw new IllegalStateException("shortcutId " + edgeId + " out of bounds");
            }
        } else if (!this.baseGraph.edgeAccess.isInBounds(edgeId)) {
            throw new IllegalStateException("edgeId " + edgeId + " out of bounds");
        }
        return (CHEdgeIteratorState)this.chEdgeAccess.getEdgeProps(edgeId, endNode);
    }

    @Override
    public int getNodes() {
        return this.baseGraph.getNodes();
    }

    @Override
    public int getEdges() {
        return this.getAllEdges().length();
    }

    @Override
    public int getOriginalEdges() {
        return this.baseGraph.getEdges();
    }

    @Override
    public NodeAccess getNodeAccess() {
        return this.baseGraph.getNodeAccess();
    }

    @Override
    public BBox getBounds() {
        return this.baseGraph.getBounds();
    }

    @Override
    public boolean isReadyForContraction() {
        return this.isReadyForContraction;
    }

    @Override
    public int getOtherNode(int edge, int node) {
        EdgeAccess edgeAccess = this.isShortcut(edge) ? this.chEdgeAccess : this.baseGraph.edgeAccess;
        long edgePointer = edgeAccess.toPointer(edge);
        return edgeAccess.getOtherNode(node, edgePointer);
    }

    void _prepareForContraction() {
        if (this.isReadyForContraction) {
            return;
        }
        long maxCapacity = (long)this.getNodes() * (long)this.nodeCHEntryBytes;
        this.nodesCH.ensureCapacity(maxCapacity);
        long baseCapacity = this.baseGraph.nodes.getCapacity();
        long pointer = this.N_CH_REF;
        long basePointer = this.baseGraph.N_EDGE_REF;
        while (pointer < maxCapacity) {
            if (basePointer >= baseCapacity) {
                throw new IllegalStateException("Cannot copy edge refs into ch graph. pointer:" + pointer + ", cap:" + maxCapacity + ", basePtr:" + basePointer + ", baseCap:" + baseCapacity);
            }
            this.nodesCH.setInt(pointer, this.baseGraph.nodes.getInt(basePointer));
            pointer += (long)this.nodeCHEntryBytes;
            basePointer += (long)this.baseGraph.nodeEntryBytes;
        }
        this.isReadyForContraction = true;
    }

    String toDetailsString() {
        return this.toString() + ", shortcuts:" + Helper.nf((long)this.shortcutCount) + ", nodesCH:(" + this.nodesCH.getCapacity() / 0x100000L + "MB)";
    }

    @Override
    public void disconnect(CHEdgeExplorer explorer, EdgeIteratorState edgeState) {
        CHEdgeIterator tmpIter = explorer.setBaseNode(edgeState.getAdjNode());
        int tmpPrevEdge = -1;
        while (tmpIter.next()) {
            if (tmpIter.isShortcut() && tmpIter.getEdge() == edgeState.getEdge()) {
                long edgePointer = tmpPrevEdge == -1 ? -1L : (this.isShortcut(tmpPrevEdge) ? this.chEdgeAccess.toPointer(tmpPrevEdge) : this.baseGraph.edgeAccess.toPointer(tmpPrevEdge));
                this.chEdgeAccess.internalEdgeDisconnect(edgeState.getEdge(), edgePointer, edgeState.getAdjNode());
                break;
            }
            tmpPrevEdge = tmpIter.getEdge();
        }
    }

    @Override
    public AllCHEdgesIterator getAllEdges() {
        return new AllCHEdgesIteratorImpl(this.baseGraph);
    }

    void loadNodesHeader() {
        this.isReadyForContraction = this.nodesCH.getHeader(0) == 1;
    }

    void setNodesHeader() {
        this.nodesCH.setHeader(0, this.isReadyForContraction ? 1 : 0);
    }

    protected int loadEdgesHeader() {
        this.shortcutCount = this.shortcuts.getHeader(0);
        this.shortcutEntryBytes = this.shortcuts.getHeader(4);
        return 3;
    }

    protected int setEdgesHeader() {
        this.shortcuts.setHeader(0, this.shortcutCount);
        this.shortcuts.setHeader(4, this.shortcutEntryBytes);
        return 3;
    }

    @Override
    public GraphExtension getExtension() {
        return this.baseGraph.getExtension();
    }

    @Override
    public Graph getBaseGraph() {
        return this.baseGraph;
    }

    @Override
    public Graph copyTo(Graph g) {
        CHGraphImpl tmpG = (CHGraphImpl)g;
        this.nodesCH.copyTo(tmpG.nodesCH);
        this.shortcuts.copyTo(tmpG.shortcuts);
        tmpG.N_LEVEL = this.N_LEVEL;
        tmpG.N_CH_REF = this.N_CH_REF;
        tmpG.nodeCHEntryBytes = this.nodeCHEntryBytes;
        return g;
    }

    void initStorage() {
        EdgeAccess ea = this.baseGraph.edgeAccess;
        this.chEdgeAccess.init(ea.E_NODEA, ea.E_NODEB, ea.E_LINKA, ea.E_LINKB, ea.E_DIST, ea.E_FLAGS);
        this.S_SKIP_EDGE1 = ea.E_FLAGS + 4;
        this.S_SKIP_EDGE2 = this.S_SKIP_EDGE1 + 4;
        if (this.edgeBased) {
            this.S_ORIG_FIRST = this.S_SKIP_EDGE2 + 4;
            this.S_ORIG_LAST = this.S_ORIG_FIRST + 4;
            this.shortcutEntryBytes = this.S_ORIG_LAST + 4;
        } else {
            this.shortcutEntryBytes = this.S_SKIP_EDGE2 + 4;
        }
        this.N_LEVEL = 0;
        this.N_CH_REF = this.N_LEVEL + 4;
        this.nodeCHEntryBytes = this.N_CH_REF + 4;
    }

    void setSegmentSize(int bytes) {
        this.nodesCH.setSegmentSize(bytes);
        this.shortcuts.setSegmentSize(bytes);
    }

    @Override
    public CHGraph create(long bytes) {
        this.nodesCH.create(bytes);
        this.shortcuts.create(bytes);
        return this;
    }

    @Override
    public boolean loadExisting() {
        if (!this.nodesCH.loadExisting() || !this.shortcuts.loadExisting()) {
            return false;
        }
        this.loadNodesHeader();
        this.loadEdgesHeader();
        return true;
    }

    @Override
    public void flush() {
        this.nodesCH.flush();
        this.shortcuts.flush();
    }

    @Override
    public void close() {
        this.nodesCH.close();
        this.shortcuts.close();
    }

    @Override
    public boolean isClosed() {
        return this.nodesCH.isClosed();
    }

    @Override
    public long getCapacity() {
        return this.nodesCH.getCapacity() + this.shortcuts.getCapacity();
    }

    public String toString() {
        return "CHGraph|" + this.getWeighting().toString();
    }

    public void debugPrint() {
        int printMax = 100;
        System.out.println("nodesCH:");
        String formatNodes = "%12s | %12s | %12s \n";
        System.out.format(Locale.ROOT, formatNodes, "#", "N_CH_REF", "N_LEVEL");
        for (int i = 0; i < Math.min(this.baseGraph.getNodes(), 100); ++i) {
            System.out.format(Locale.ROOT, formatNodes, i, this.chEdgeAccess.getEdgeRef(i), this.getLevel(i));
        }
        if (this.baseGraph.getNodes() > 100) {
            System.out.format(Locale.ROOT, " ... %d more nodes", this.baseGraph.getNodes() - 100);
        }
        System.out.println("shortcuts:");
        String formatShortcutsBase = "%12s | %12s | %12s | %12s | %12s | %12s | %12s | %12s | %12s";
        String formatShortcutExt = " | %12s | %12s";
        String header = String.format(Locale.ROOT, formatShortcutsBase, "#", "E_NODEA", "E_NODEB", "E_LINKA", "E_LINKB", "E_DIST", "E_FLAGS", "S_SKIP_EDGE1", "S_SKIP_EDGE2");
        if (this.edgeBased) {
            header = header + String.format(Locale.ROOT, formatShortcutExt, "S_ORIG_FIRST", "S_ORIG_LAST");
        }
        System.out.println(header);
        for (int i = this.baseGraph.edgeCount; i < this.baseGraph.edgeCount + Math.min(this.shortcutCount, 100); ++i) {
            long edgePointer = this.chEdgeAccess.toPointer(i);
            String edgeString = String.format(Locale.ROOT, formatShortcutsBase, i, this.chEdgeAccess.getNodeA(edgePointer), this.chEdgeAccess.getNodeB(edgePointer), this.chEdgeAccess.getLinkA(edgePointer), this.chEdgeAccess.getLinkB(edgePointer), this.chEdgeAccess.getDist(edgePointer), this.chEdgeAccess.getShortcutFlags(edgePointer), this.shortcuts.getInt(edgePointer + (long)this.S_SKIP_EDGE1), this.shortcuts.getInt(edgePointer + (long)this.S_SKIP_EDGE2));
            if (this.edgeBased) {
                edgeString = edgeString + String.format(Locale.ROOT, formatShortcutExt, this.shortcuts.getInt(edgePointer + (long)this.S_ORIG_FIRST), this.shortcuts.getInt(edgePointer + (long)this.S_ORIG_LAST));
            }
            System.out.println(edgeString);
        }
        if (this.shortcutCount > 100) {
            System.out.printf(Locale.ROOT, " ... %d more shortcut edges\n", this.shortcutCount - 100);
        }
    }

    @Override
    public NodeOrderingProvider getNodeOrderingProvider() {
        int numNodes = this.getNodes();
        final int[] nodeOrdering = new int[numNodes];
        int i = 0;
        while (i < numNodes) {
            int level = this.getLevel(i);
            nodeOrdering[level] = i++;
        }
        return new NodeOrderingProvider(){

            @Override
            public int getNodeIdForLevel(int level) {
                return nodeOrdering[level];
            }

            @Override
            public int getNumNodes() {
                return nodeOrdering.length;
            }
        };
    }

    private class CHEdgeAccess
    extends EdgeAccess {
        private final String name;

        public CHEdgeAccess(String name) {
            super(CHGraphImpl.this.shortcuts);
            this.name = name;
        }

        @Override
        final BaseGraph.EdgeIterable createSingleEdge(EdgeFilter edgeFilter) {
            return new CHEdgeIteratorImpl(CHGraphImpl.this.baseGraph, this, edgeFilter);
        }

        @Override
        final int getEdgeRef(int nodeId) {
            return CHGraphImpl.this.nodesCH.getInt((long)nodeId * (long)CHGraphImpl.this.nodeCHEntryBytes + (long)CHGraphImpl.this.N_CH_REF);
        }

        @Override
        final void setEdgeRef(int nodeId, int edgeId) {
            CHGraphImpl.this.nodesCH.setInt((long)nodeId * (long)CHGraphImpl.this.nodeCHEntryBytes + (long)CHGraphImpl.this.N_CH_REF, edgeId);
        }

        @Override
        final int getEntryBytes() {
            return CHGraphImpl.this.shortcutEntryBytes;
        }

        void setShortcutFlags(long edgePointer, int flags) {
            this.edges.setInt(edgePointer + (long)this.E_FLAGS, flags);
        }

        int getShortcutFlags(long edgePointer) {
            return this.edges.getInt(edgePointer + (long)this.E_FLAGS);
        }

        void setShortcutWeight(long edgePointer, double weight) {
            int accessFlags = this.getShortcutFlags(edgePointer) & CHGraphImpl.this.scDirMask;
            this.setAccessAndWeight(edgePointer, accessFlags, weight);
        }

        void setAccessAndWeight(long edgePointer, int accessFlags, double weight) {
            int weightFlags = this.weightToWeightFlags(edgePointer, weight);
            this.setShortcutFlags(edgePointer, weightFlags | accessFlags);
        }

        int weightToWeightFlags(long edgePointer, double weight) {
            if (weight < 0.0) {
                throw new IllegalArgumentException("weight cannot be negative but was " + weight);
            }
            if (weight < 0.001) {
                NodeAccess nodeAccess = CHGraphImpl.this.getNodeAccess();
                int edgeId = -1;
                LOGGER.warn("Setting weights smaller than 0.001 is not allowed in CHGraphImpl#setWeight. You passed: " + weight + " for the edge " + edgeId + " nodeA " + nodeAccess.getLat(this.getNodeA(edgePointer)) + "," + nodeAccess.getLon(this.getNodeA(edgePointer)) + " nodeB " + nodeAccess.getLat(this.getNodeB(edgePointer)) + "," + nodeAccess.getLon(this.getNodeB(edgePointer)));
                weight = 0.001;
            }
            int weightInt = weight > 536870.911 ? 0x7FFFFFFC : (int)Math.round(weight * 1000.0) << 2;
            return weightInt;
        }

        double getShortcutWeight(long edgePointer) {
            long flags32bit = this.getShortcutFlags(edgePointer);
            double weight = (double)(flags32bit >>> 2) / 1000.0;
            if (weight >= 536870.911) {
                return Double.POSITIVE_INFINITY;
            }
            return weight;
        }

        void setSkippedEdges(long edgePointer, int edge1, int edge2) {
            if (EdgeIterator.Edge.isValid(edge1) != EdgeIterator.Edge.isValid(edge2)) {
                throw new IllegalStateException("Skipped edges of a shortcut needs to be both valid or invalid but they were not " + edge1 + ", " + edge2);
            }
            CHGraphImpl.this.shortcuts.setInt(edgePointer + (long)CHGraphImpl.this.S_SKIP_EDGE1, edge1);
            CHGraphImpl.this.shortcuts.setInt(edgePointer + (long)CHGraphImpl.this.S_SKIP_EDGE2, edge2);
        }

        public void setFirstAndLastOrigEdges(long edgePointer, int origFirst, int origLast) {
            CHGraphImpl.this.shortcuts.setInt(edgePointer + (long)CHGraphImpl.this.S_ORIG_FIRST, origFirst);
            CHGraphImpl.this.shortcuts.setInt(edgePointer + (long)CHGraphImpl.this.S_ORIG_LAST, origLast);
        }

        @Override
        final long toPointer(int shortcutId) {
            assert (this.isInBounds(shortcutId)) : "shortcutId " + shortcutId + " not in bounds [" + CHGraphImpl.access$700((CHGraphImpl)CHGraphImpl.this).edgeCount + ", " + (CHGraphImpl.access$700((CHGraphImpl)CHGraphImpl.this).edgeCount + CHGraphImpl.access$600(CHGraphImpl.this)) + ")";
            return (long)(shortcutId - ((CHGraphImpl)CHGraphImpl.this).baseGraph.edgeCount) * (long)CHGraphImpl.this.shortcutEntryBytes;
        }

        @Override
        final boolean isInBounds(int shortcutId) {
            int tmp = shortcutId - ((CHGraphImpl)CHGraphImpl.this).baseGraph.edgeCount;
            return tmp < CHGraphImpl.this.shortcutCount && tmp >= 0;
        }

        public String toString() {
            return "ch edge access " + this.name;
        }
    }

    class AllCHEdgesIteratorImpl
    extends BaseGraph.AllEdgeIterator
    implements AllCHEdgesIterator {
        public AllCHEdgesIteratorImpl(BaseGraph baseGraph) {
            super(baseGraph);
        }

        @Override
        protected final boolean checkRange() {
            if (this.isShortcut()) {
                return this.edgeId < CHGraphImpl.this.shortcutCount;
            }
            if (super.checkRange()) {
                return true;
            }
            this.edgeAccess = CHGraphImpl.this.chEdgeAccess;
            this.edgeId = 0;
            this.edgePointer = (long)this.edgeId * (long)CHGraphImpl.this.shortcutEntryBytes;
            return this.edgeId < CHGraphImpl.this.shortcutCount;
        }

        int getShortcutFlags() {
            if (!this.freshFlags) {
                this.chFlags = CHGraphImpl.this.chEdgeAccess.getShortcutFlags(this.edgePointer);
                this.freshFlags = true;
            }
            return this.chFlags;
        }

        @Override
        public int getEdge() {
            if (this.isShortcut()) {
                return this.baseGraph.edgeCount + this.edgeId;
            }
            return super.getEdge();
        }

        @Override
        public boolean get(BooleanEncodedValue property) {
            if (this.isShortcut()) {
                return (this.getShortcutFlags() & (this.reverse ? PrepareEncoder.getScBwdDir() : PrepareEncoder.getScFwdDir())) != 0;
            }
            return property.getBool(this.reverse, this.getFlags());
        }

        @Override
        public boolean getReverse(BooleanEncodedValue property) {
            if (this.isShortcut()) {
                return (this.getShortcutFlags() & (this.reverse ? PrepareEncoder.getScFwdDir() : PrepareEncoder.getScBwdDir())) != 0;
            }
            return property.getBool(!this.reverse, this.getFlags());
        }

        @Override
        public final IntsRef getFlags() {
            if (this.isShortcut()) {
                throw new IllegalStateException("Shortcut should not need to return raw flags!");
            }
            return super.getFlags();
        }

        @Override
        public int length() {
            return super.length() + CHGraphImpl.this.shortcutCount;
        }

        @Override
        public final CHEdgeIteratorState setSkippedEdges(int edge1, int edge2) {
            this.checkShortcut(true, "setSkippedEdges");
            CHGraphImpl.this.chEdgeAccess.setSkippedEdges(this.edgePointer, edge1, edge2);
            return this;
        }

        @Override
        public final int getSkippedEdge1() {
            this.checkShortcut(true, "getSkippedEdge1");
            return CHGraphImpl.this.shortcuts.getInt(this.edgePointer + (long)CHGraphImpl.this.S_SKIP_EDGE1);
        }

        @Override
        public final int getSkippedEdge2() {
            this.checkShortcut(true, "getSkippedEdge2");
            return CHGraphImpl.this.shortcuts.getInt(this.edgePointer + (long)CHGraphImpl.this.S_SKIP_EDGE2);
        }

        @Override
        public CHEdgeIteratorState setFirstAndLastOrigEdges(int firstOrigEdge, int lastOrigEdge) {
            this.checkShortcutAndEdgeBased("setFirstAndLastOrigEdges");
            CHGraphImpl.this.shortcuts.setInt(this.edgePointer + (long)CHGraphImpl.this.S_ORIG_FIRST, firstOrigEdge);
            CHGraphImpl.this.shortcuts.setInt(this.edgePointer + (long)CHGraphImpl.this.S_ORIG_LAST, lastOrigEdge);
            return this;
        }

        @Override
        public int getOrigEdgeFirst() {
            this.checkShortcutAndEdgeBased("getOrigEdgeFirst");
            return CHGraphImpl.this.shortcuts.getInt(this.edgePointer + (long)CHGraphImpl.this.S_ORIG_FIRST);
        }

        @Override
        public int getOrigEdgeLast() {
            this.checkShortcutAndEdgeBased("getOrigEdgeLast");
            return CHGraphImpl.this.shortcuts.getInt(this.edgePointer + (long)CHGraphImpl.this.S_ORIG_LAST);
        }

        @Override
        public final boolean isShortcut() {
            assert (this.baseGraph.isFrozen()) : "level graph not yet frozen";
            return this.edgeAccess == CHGraphImpl.this.chEdgeAccess;
        }

        @Override
        public final CHEdgeIteratorState setWeight(double weight) {
            this.checkShortcut(true, "setWeight");
            CHGraphImpl.this.chEdgeAccess.setShortcutWeight(this.edgePointer, weight);
            return this;
        }

        @Override
        public void setFlagsAndWeight(int flags, double weight) {
            this.checkShortcut(true, "setFlagsAndWeight");
            CHGraphImpl.this.chEdgeAccess.setAccessAndWeight(this.edgePointer, flags, weight);
            this.chFlags = flags;
            this.freshFlags = true;
        }

        @Override
        public final double getWeight() {
            this.checkShortcut(true, "getWeight");
            return CHGraphImpl.this.chEdgeAccess.getShortcutWeight(this.edgePointer);
        }

        @Override
        public int getMergeStatus(int flags) {
            return PrepareEncoder.getScMergeStatus(this.getShortcutFlags(), flags);
        }

        void checkShortcut(boolean shouldBeShortcut, String methodName) {
            if (this.isShortcut()) {
                if (!shouldBeShortcut) {
                    throw new IllegalStateException("Cannot call " + methodName + " on shortcut " + this.getEdge());
                }
            } else if (shouldBeShortcut) {
                throw new IllegalStateException("Method " + methodName + " only for shortcuts " + this.getEdge());
            }
        }

        private void checkShortcutAndEdgeBased(String method) {
            this.checkShortcut(true, method);
            if (!CHGraphImpl.this.edgeBased) {
                throw new IllegalStateException("Method " + method + " not supported when turn costs are disabled");
            }
        }
    }

    class CHEdgeIteratorImpl
    extends BaseGraph.EdgeIterable
    implements CHEdgeExplorer,
    CHEdgeIterator {
        public CHEdgeIteratorImpl(BaseGraph baseGraph, EdgeAccess edgeAccess, EdgeFilter filter) {
            super(baseGraph, edgeAccess, filter);
        }

        @Override
        public final IntsRef getFlags() {
            this.checkShortcut(false, "getFlags");
            return super.getFlags();
        }

        int getShortcutFlags() {
            if (!this.freshFlags) {
                this.chFlags = CHGraphImpl.this.chEdgeAccess.getShortcutFlags(this.edgePointer);
                this.freshFlags = true;
            }
            return this.chFlags;
        }

        @Override
        public final CHEdgeIterator setBaseNode(int baseNode) {
            assert (this.baseGraph.isFrozen()) : "Traversal CHGraph is only possible if BaseGraph is frozen";
            this.setEdgeId(CHGraphImpl.this.chEdgeAccess.getEdgeRef(baseNode));
            this._setBaseNode(baseNode);
            return this;
        }

        @Override
        public final CHEdgeIteratorState setSkippedEdges(int edge1, int edge2) {
            this.checkShortcut(true, "setSkippedEdges");
            CHGraphImpl.this.chEdgeAccess.setSkippedEdges(this.edgePointer, edge1, edge2);
            return this;
        }

        @Override
        public final int getSkippedEdge1() {
            this.checkShortcut(true, "getSkippedEdge1");
            return CHGraphImpl.this.shortcuts.getInt(this.edgePointer + (long)CHGraphImpl.this.S_SKIP_EDGE1);
        }

        @Override
        public final int getSkippedEdge2() {
            this.checkShortcut(true, "getSkippedEdge2");
            return CHGraphImpl.this.shortcuts.getInt(this.edgePointer + (long)CHGraphImpl.this.S_SKIP_EDGE2);
        }

        @Override
        public CHEdgeIteratorState setFirstAndLastOrigEdges(int firstOrigEdge, int lastOrigEdge) {
            this.checkShortcutAndEdgeBased("setFirstAndLastOrigEdges");
            CHGraphImpl.this.chEdgeAccess.setFirstAndLastOrigEdges(this.edgePointer, firstOrigEdge, lastOrigEdge);
            return this;
        }

        @Override
        public int getOrigEdgeFirst() {
            if (!this.isShortcut()) {
                return this.getEdge();
            }
            this.checkShortcutAndEdgeBased("getOrigEdgeFirst");
            return CHGraphImpl.this.shortcuts.getInt(this.edgePointer + (long)CHGraphImpl.this.S_ORIG_FIRST);
        }

        @Override
        public int getOrigEdgeLast() {
            if (!this.isShortcut()) {
                return this.getEdge();
            }
            this.checkShortcutAndEdgeBased("getOrigEdgeLast");
            return CHGraphImpl.this.shortcuts.getInt(this.edgePointer + (long)CHGraphImpl.this.S_ORIG_LAST);
        }

        @Override
        public final boolean isShortcut() {
            return this.edgeId >= this.baseGraph.edgeCount;
        }

        @Override
        public boolean get(BooleanEncodedValue property) {
            if (this.isShortcut()) {
                return (this.getShortcutFlags() & (this.reverse ? PrepareEncoder.getScBwdDir() : PrepareEncoder.getScFwdDir())) != 0;
            }
            return property.getBool(this.reverse, this.getFlags());
        }

        @Override
        public boolean getReverse(BooleanEncodedValue property) {
            if (this.isShortcut()) {
                return (this.getShortcutFlags() & (this.reverse ? PrepareEncoder.getScFwdDir() : PrepareEncoder.getScBwdDir())) != 0;
            }
            return property.getBool(!this.reverse, this.getFlags());
        }

        @Override
        public final CHEdgeIteratorState setWeight(double weight) {
            this.checkShortcut(true, "setWeight");
            CHGraphImpl.this.chEdgeAccess.setShortcutWeight(this.edgePointer, weight);
            return this;
        }

        @Override
        public void setFlagsAndWeight(int flags, double weight) {
            this.checkShortcut(true, "setFlagsAndWeight");
            CHGraphImpl.this.chEdgeAccess.setAccessAndWeight(this.edgePointer, flags, weight);
            this.chFlags = flags;
            this.freshFlags = true;
        }

        @Override
        public final double getWeight() {
            this.checkShortcut(true, "getWeight");
            return CHGraphImpl.this.chEdgeAccess.getShortcutWeight(this.edgePointer);
        }

        @Override
        protected final void selectEdgeAccess() {
            this.edgeAccess = this.nextEdgeId < this.baseGraph.edgeCount ? this.baseGraph.edgeAccess : CHGraphImpl.this.chEdgeAccess;
        }

        public void checkShortcut(boolean shouldBeShortcut, String methodName) {
            if (this.isShortcut()) {
                if (!shouldBeShortcut) {
                    throw new IllegalStateException("Cannot call " + methodName + " on shortcut " + this.getEdge());
                }
            } else if (shouldBeShortcut) {
                throw new IllegalStateException("Method " + methodName + " only for shortcuts " + this.getEdge());
            }
        }

        private void checkShortcutAndEdgeBased(String method) {
            this.checkShortcut(true, method);
            if (!CHGraphImpl.this.edgeBased) {
                throw new IllegalStateException("Method " + method + " only allowed when CH graph is configured for edge based traversal");
            }
        }

        @Override
        public final String getName() {
            this.checkShortcut(false, "getName");
            return super.getName();
        }

        @Override
        public final EdgeIteratorState setName(String name) {
            this.checkShortcut(false, "setName");
            return super.setName(name);
        }

        @Override
        public final PointList fetchWayGeometry(int mode) {
            this.checkShortcut(false, "fetchWayGeometry");
            return super.fetchWayGeometry(mode);
        }

        @Override
        public final EdgeIteratorState setWayGeometry(PointList list) {
            this.checkShortcut(false, "setWayGeometry");
            return super.setWayGeometry(list);
        }

        @Override
        public int getMergeStatus(int flags) {
            return PrepareEncoder.getScMergeStatus(this.getShortcutFlags(), flags);
        }
    }
}

