/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.storage;

import com.graphhopper.routing.util.EdgeFilter;
import com.graphhopper.storage.BaseGraph;
import com.graphhopper.storage.DataAccess;
import com.graphhopper.storage.IntsRef;
import com.graphhopper.util.EdgeIteratorState;

abstract class EdgeAccess {
    private static final int NO_NODE = -1;
    private static final double INT_DIST_FACTOR = 1000.0;
    static double MAX_DIST = 2147483.647;
    final DataAccess edges;
    int E_NODEA;
    int E_NODEB;
    int E_LINKA;
    int E_LINKB;
    int E_DIST;
    int E_FLAGS;

    EdgeAccess(DataAccess edges) {
        this.edges = edges;
    }

    final void init(int E_NODEA, int E_NODEB, int E_LINKA, int E_LINKB, int E_DIST, int E_FLAGS) {
        this.E_NODEA = E_NODEA;
        this.E_NODEB = E_NODEB;
        this.E_LINKA = E_LINKA;
        this.E_LINKB = E_LINKB;
        this.E_DIST = E_DIST;
        this.E_FLAGS = E_FLAGS;
    }

    abstract BaseGraph.EdgeIterable createSingleEdge(EdgeFilter var1);

    abstract long toPointer(int var1);

    abstract boolean isInBounds(int var1);

    abstract int getEdgeRef(int var1);

    abstract void setEdgeRef(int var1, int var2);

    abstract int getEntryBytes();

    final void invalidateEdge(long edgePointer) {
        this.edges.setInt(edgePointer + (long)this.E_NODEB, -1);
    }

    static final boolean isInvalidNodeB(int node) {
        return node == -1;
    }

    final void setDist(long edgePointer, double distance) {
        this.edges.setInt(edgePointer + (long)this.E_DIST, this.distToInt(distance));
    }

    private int distToInt(double distance) {
        if (distance < 0.0) {
            throw new IllegalArgumentException("Distance cannot be negative: " + distance);
        }
        if (distance > MAX_DIST) {
            distance = MAX_DIST;
        }
        int integ = (int)Math.round(distance * 1000.0);
        assert (integ >= 0) : "distance out of range";
        return integ;
    }

    final double getDist(long pointer) {
        int val = this.edges.getInt(pointer + (long)this.E_DIST);
        return (double)val / 1000.0;
    }

    final void readFlags(long edgePointer, IntsRef edgeFlags) {
        int size = edgeFlags.ints.length;
        for (int i = 0; i < size; ++i) {
            edgeFlags.ints[i] = this.edges.getInt(edgePointer + (long)this.E_FLAGS + (long)(i * 4));
        }
    }

    final void writeFlags(long edgePointer, IntsRef edgeFlags) {
        int size = edgeFlags.ints.length;
        for (int i = 0; i < size; ++i) {
            this.edges.setInt(edgePointer + (long)this.E_FLAGS + (long)(i * 4), edgeFlags.ints[i]);
        }
    }

    final int internalEdgeAdd(int newEdgeId, int nodeA, int nodeB) {
        this.writeEdge(newEdgeId, nodeA, nodeB, -1, -1);
        long edgePointer = this.toPointer(newEdgeId);
        int edge = this.getEdgeRef(nodeA);
        if (edge > -1) {
            this.edges.setInt((long)this.E_LINKA + edgePointer, edge);
        }
        this.setEdgeRef(nodeA, newEdgeId);
        if (nodeA != nodeB) {
            edge = this.getEdgeRef(nodeB);
            if (edge > -1) {
                this.edges.setInt((long)this.E_LINKB + edgePointer, edge);
            }
            this.setEdgeRef(nodeB, newEdgeId);
        }
        return newEdgeId;
    }

    final int getNodeA(long edgePointer) {
        return this.edges.getInt(edgePointer + (long)this.E_NODEA);
    }

    final int getNodeB(long edgePointer) {
        return this.edges.getInt(edgePointer + (long)this.E_NODEB);
    }

    final int getLinkA(long edgePointer) {
        return this.edges.getInt(edgePointer + (long)this.E_LINKA);
    }

    final int getLinkB(long edgePointer) {
        return this.edges.getInt(edgePointer + (long)this.E_LINKB);
    }

    final int getOtherNode(int nodeThis, long edgePointer) {
        int nodeA = this.getNodeA(edgePointer);
        return nodeThis == nodeA ? this.getNodeB(edgePointer) : nodeA;
    }

    final long writeEdge(int edgeId, int nodeA, int nodeB, int nextEdgeA, int nextEdgeB) {
        if (edgeId < 0 || edgeId == -1) {
            throw new IllegalStateException("Cannot write edge with illegal ID:" + edgeId + "; nodeA:" + nodeA + ", nodeB:" + nodeB);
        }
        long edgePointer = this.toPointer(edgeId);
        this.edges.setInt(edgePointer + (long)this.E_NODEA, nodeA);
        this.edges.setInt(edgePointer + (long)this.E_NODEB, nodeB);
        this.edges.setInt(edgePointer + (long)this.E_LINKA, nextEdgeA);
        this.edges.setInt(edgePointer + (long)this.E_LINKB, nextEdgeB);
        return edgePointer;
    }

    final long internalEdgeDisconnect(int edgeToRemove, long edgeToUpdatePointer, int baseNode) {
        int nextEdgeId;
        long edgeToRemovePointer = this.toPointer(edgeToRemove);
        int n = nextEdgeId = this.getNodeA(edgeToRemovePointer) == baseNode ? this.getLinkA(edgeToRemovePointer) : this.getLinkB(edgeToRemovePointer);
        if (edgeToUpdatePointer < 0L) {
            this.setEdgeRef(baseNode, nextEdgeId);
        } else {
            long link = this.getNodeA(edgeToUpdatePointer) == baseNode ? edgeToUpdatePointer + (long)this.E_LINKA : edgeToUpdatePointer + (long)this.E_LINKB;
            this.edges.setInt(link, nextEdgeId);
        }
        return edgeToRemovePointer;
    }

    final EdgeIteratorState getEdgeProps(int edgeId, int adjNode) {
        if (edgeId <= -1) {
            throw new IllegalStateException("edgeId invalid " + edgeId + ", " + this);
        }
        BaseGraph.EdgeIterable edge = this.createSingleEdge(EdgeFilter.ALL_EDGES);
        if (edge.init(edgeId, adjNode)) {
            return edge;
        }
        return null;
    }
}

