/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing;

import com.graphhopper.routing.AbstractBidirAlgo;
import com.graphhopper.routing.Path;
import com.graphhopper.routing.ch.CHEntry;
import com.graphhopper.routing.ch.EdgeBasedPathCH;
import com.graphhopper.routing.util.DefaultEdgeFilter;
import com.graphhopper.routing.util.EdgeFilter;
import com.graphhopper.routing.util.TraversalMode;
import com.graphhopper.routing.weighting.TurnWeighting;
import com.graphhopper.storage.Graph;
import com.graphhopper.storage.SPTEntry;
import com.graphhopper.storage.TurnCostExtension;
import com.graphhopper.util.EdgeExplorer;
import com.graphhopper.util.EdgeIterator;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.GHUtility;

public abstract class AbstractBidirectionEdgeCHNoSOD
extends AbstractBidirAlgo {
    private final EdgeExplorer innerInExplorer;
    private final EdgeExplorer innerOutExplorer;
    private final TurnWeighting turnWeighting;
    private final TurnCostExtension turnCostExtension;

    public AbstractBidirectionEdgeCHNoSOD(Graph graph, TurnWeighting weighting) {
        super(graph, weighting, TraversalMode.EDGE_BASED_2DIR);
        this.turnWeighting = weighting;
        this.innerInExplorer = graph.createEdgeExplorer(DefaultEdgeFilter.inEdges(this.flagEncoder));
        this.innerOutExplorer = graph.createEdgeExplorer(DefaultEdgeFilter.outEdges(this.flagEncoder));
        if (!(graph.getExtension() instanceof TurnCostExtension)) {
            throw new IllegalArgumentException("edge-based CH algorithms require a turn cost extension");
        }
        this.turnCostExtension = (TurnCostExtension)graph.getExtension();
    }

    @Override
    protected void postInitFrom() {
        EdgeFilter filter = this.additionalEdgeFilter;
        this.setEdgeFilter(EdgeFilter.ALL_EDGES);
        this.fillEdgesFrom();
        this.setEdgeFilter(filter);
    }

    @Override
    protected void postInitTo() {
        EdgeFilter filter = this.additionalEdgeFilter;
        this.setEdgeFilter(EdgeFilter.ALL_EDGES);
        this.fillEdgesTo();
        this.setEdgeFilter(filter);
    }

    @Override
    protected void initCollections(int size) {
        super.initCollections(Math.min(size, 2000));
    }

    @Override
    public boolean finished() {
        if (this.finishedFrom && this.finishedTo) {
            return true;
        }
        return this.currFrom.weight >= this.bestPath.getWeight() && this.currTo.weight >= this.bestPath.getWeight();
    }

    @Override
    protected void updateBestPath(EdgeIteratorState edgeState, SPTEntry entry, int traversalId, boolean reverse) {
        EdgeIterator iter;
        int oppositeNode;
        int n = oppositeNode = reverse ? this.from : this.to;
        if (edgeState.getAdjNode() == oppositeNode && entry.getWeightOfVisitedPath() < this.bestPath.getWeight()) {
            this.bestPath.setSwitchToFrom(reverse);
            this.bestPath.setSPTEntry(entry);
            this.bestPath.setSPTEntryTo(new CHEntry(oppositeNode, 0.0));
            this.bestPath.setWeight(entry.getWeightOfVisitedPath());
            return;
        }
        EdgeIterator edgeIterator = iter = reverse ? this.innerInExplorer.setBaseNode(edgeState.getAdjNode()) : this.innerOutExplorer.setBaseNode(edgeState.getAdjNode());
        while (iter.next()) {
            double turnCostsAtBridgeNode;
            int key;
            SPTEntry entryOther;
            int edgeId = this.getOrigEdgeId(iter, !reverse);
            int prevOrNextOrigEdgeId = this.getOrigEdgeId(edgeState, reverse);
            if (!this.traversalMode.hasUTurnSupport() && this.turnCostExtension.isUTurn(edgeId, prevOrNextOrigEdgeId) || (entryOther = (SPTEntry)this.bestWeightMapOther.get(key = GHUtility.getEdgeKey(this.graph, edgeId, iter.getBaseNode(), !reverse))) == null) continue;
            double d = turnCostsAtBridgeNode = reverse ? this.turnWeighting.calcTurnWeight(iter.getOrigEdgeLast(), iter.getBaseNode(), prevOrNextOrigEdgeId) : this.turnWeighting.calcTurnWeight(prevOrNextOrigEdgeId, iter.getBaseNode(), iter.getOrigEdgeFirst());
            double newWeight = entry.getWeightOfVisitedPath() + entryOther.getWeightOfVisitedPath() + turnCostsAtBridgeNode;
            if (!(newWeight < this.bestPath.getWeight())) continue;
            this.bestPath.setSwitchToFrom(reverse);
            this.bestPath.setSPTEntry(entry);
            this.bestPath.setSPTEntryTo(entryOther);
            this.bestPath.setWeight(newWeight);
        }
    }

    @Override
    protected Path createAndInitPath() {
        this.bestPath = new EdgeBasedPathCH(this.graph, this.graph.getBaseGraph(), this.weighting);
        return this.bestPath;
    }

    @Override
    protected int getOrigEdgeId(EdgeIteratorState edge, boolean reverse) {
        return reverse ? edge.getOrigEdgeFirst() : edge.getOrigEdgeLast();
    }

    @Override
    protected int getIncomingEdge(SPTEntry entry) {
        return ((CHEntry)entry).incEdge;
    }

    @Override
    protected int getTraversalId(EdgeIteratorState edge, int origEdgeId, boolean reverse) {
        int baseNode = this.graph.getOtherNode(origEdgeId, edge.getAdjNode());
        return GHUtility.createEdgeKey(baseNode, edge.getAdjNode(), origEdgeId, reverse);
    }

    @Override
    protected boolean accept(EdgeIteratorState edge, SPTEntry currEdge, boolean reverse) {
        int incEdge = this.getIncomingEdge(currEdge);
        if (incEdge == -1) {
            return true;
        }
        int prevOrNextEdgeId = this.getOrigEdgeId(edge, !reverse);
        if (!this.traversalMode.hasUTurnSupport() && this.turnCostExtension.isUTurn(incEdge, prevOrNextEdgeId)) {
            return false;
        }
        return this.additionalEdgeFilter == null || this.additionalEdgeFilter.accept(edge);
    }

    @Override
    public String toString() {
        return this.getName() + "|" + this.weighting;
    }
}

