/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util;

import com.graphhopper.routing.profiles.BooleanEncodedValue;
import com.graphhopper.routing.util.EdgeFilter;
import com.graphhopper.routing.util.FlagEncoder;
import com.graphhopper.util.EdgeIteratorState;

public class DefaultEdgeFilter
implements EdgeFilter {
    private final boolean bwd;
    private final boolean fwd;
    protected final BooleanEncodedValue accessEnc;

    protected DefaultEdgeFilter(BooleanEncodedValue accessEnc, boolean fwd, boolean bwd) {
        this.accessEnc = accessEnc;
        this.fwd = fwd;
        this.bwd = bwd;
    }

    public static DefaultEdgeFilter outEdges(BooleanEncodedValue accessEnc) {
        return new DefaultEdgeFilter(accessEnc, true, false);
    }

    public static DefaultEdgeFilter outEdges(FlagEncoder flagEncoder) {
        return new DefaultEdgeFilter(flagEncoder.getAccessEnc(), true, false);
    }

    public static DefaultEdgeFilter inEdges(FlagEncoder flagEncoder) {
        return new DefaultEdgeFilter(flagEncoder.getAccessEnc(), false, true);
    }

    public static DefaultEdgeFilter allEdges(FlagEncoder flagEncoder) {
        return new DefaultEdgeFilter(flagEncoder.getAccessEnc(), true, true);
    }

    @Override
    public final boolean accept(EdgeIteratorState iter) {
        if (iter.getBaseNode() == iter.getAdjNode()) {
            return iter.get(this.accessEnc) || iter.getReverse(this.accessEnc);
        }
        return this.fwd && iter.get(this.accessEnc) || this.bwd && iter.getReverse(this.accessEnc);
    }

    public boolean acceptsBackward() {
        return this.bwd;
    }

    public boolean acceptsForward() {
        return this.fwd;
    }

    public String toString() {
        return this.accessEnc.toString() + ", bwd:" + this.bwd + ", fwd:" + this.fwd;
    }
}

