/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.ch;

import com.carrotsearch.hppc.IntHashSet;
import com.graphhopper.routing.ch.AbstractNodeContractor;
import com.graphhopper.routing.ch.CHEntry;
import com.graphhopper.routing.ch.PrepareEncoder;
import com.graphhopper.routing.ch.WitnessPathSearcher;
import com.graphhopper.routing.profiles.BooleanEncodedValue;
import com.graphhopper.routing.util.DefaultEdgeFilter;
import com.graphhopper.routing.util.FlagEncoder;
import com.graphhopper.routing.weighting.TurnWeighting;
import com.graphhopper.storage.CHGraph;
import com.graphhopper.util.CHEdgeExplorer;
import com.graphhopper.util.CHEdgeIterator;
import com.graphhopper.util.CHEdgeIteratorState;
import com.graphhopper.util.EdgeExplorer;
import com.graphhopper.util.EdgeIterator;
import com.graphhopper.util.Helper;
import com.graphhopper.util.PMap;
import com.graphhopper.util.StopWatch;
import java.util.HashSet;
import java.util.Locale;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class EdgeBasedNodeContractor
extends AbstractNodeContractor {
    private static final Logger LOGGER = LoggerFactory.getLogger(EdgeBasedNodeContractor.class);
    private final TurnWeighting turnWeighting;
    private final FlagEncoder encoder;
    private final ShortcutHandler addingShortcutHandler = new AddingShortcutHandler();
    private final ShortcutHandler countingShortcutHandler = new CountingShortcutHandler();
    private final Params params = new Params();
    private final PMap pMap;
    private ShortcutHandler activeShortcutHandler;
    private final StopWatch dijkstraSW = new StopWatch();
    private final SearchStrategy activeStrategy = new AggressiveStrategy();
    private int[] hierarchyDepths;
    private WitnessPathSearcher witnessPathSearcher;
    private CHEdgeExplorer existingShortcutExplorer;
    private CHEdgeExplorer allEdgeExplorer;
    private EdgeExplorer sourceNodeOrigInEdgeExplorer;
    private EdgeExplorer targetNodeOrigOutEdgeExplorer;
    private EdgeExplorer loopAvoidanceInEdgeExplorer;
    private EdgeExplorer loopAvoidanceOutEdgeExplorer;
    private int addedShortcutsCount;
    private int numShortcuts;
    private int numPrevEdges;
    private int numOrigEdges;
    private int numPrevOrigEdges;
    private int numPolledEdges;

    public EdgeBasedNodeContractor(CHGraph prepareGraph, TurnWeighting turnWeighting, PMap pMap) {
        super(prepareGraph, turnWeighting);
        this.turnWeighting = turnWeighting;
        this.encoder = turnWeighting.getFlagEncoder();
        this.pMap = pMap;
        this.extractParams(pMap);
        if (!Double.isInfinite(turnWeighting.getUTurnCost())) {
            throw new IllegalArgumentException("edge-based CH currently does not support finite u-turn costs");
        }
    }

    private void extractParams(PMap pMap) {
        this.params.edgeQuotientWeight = pMap.getFloat("prepare.ch.edge.edge_quotient_weight", this.params.edgeQuotientWeight);
        this.params.originalEdgeQuotientWeight = pMap.getFloat("prepare.ch.edge.original_edge_quotient_weight", this.params.originalEdgeQuotientWeight);
        this.params.hierarchyDepthWeight = pMap.getFloat("prepare.ch.edge.hierarchy_depth_weight", this.params.hierarchyDepthWeight);
    }

    @Override
    public void initFromGraph() {
        super.initFromGraph();
        this.witnessPathSearcher = new WitnessPathSearcher(this.prepareGraph, this.turnWeighting, this.pMap);
        DefaultEdgeFilter inEdgeFilter = DefaultEdgeFilter.inEdges(this.encoder);
        DefaultEdgeFilter outEdgeFilter = DefaultEdgeFilter.outEdges(this.encoder);
        DefaultEdgeFilter allEdgeFilter = DefaultEdgeFilter.allEdges(this.encoder);
        this.inEdgeExplorer = this.prepareGraph.createEdgeExplorer(inEdgeFilter);
        this.outEdgeExplorer = this.prepareGraph.createEdgeExplorer(outEdgeFilter);
        this.allEdgeExplorer = this.prepareGraph.createEdgeExplorer(allEdgeFilter);
        this.existingShortcutExplorer = this.prepareGraph.createEdgeExplorer(outEdgeFilter);
        this.sourceNodeOrigInEdgeExplorer = this.prepareGraph.createOriginalEdgeExplorer(inEdgeFilter);
        this.targetNodeOrigOutEdgeExplorer = this.prepareGraph.createOriginalEdgeExplorer(outEdgeFilter);
        this.loopAvoidanceInEdgeExplorer = this.prepareGraph.createOriginalEdgeExplorer(inEdgeFilter);
        this.loopAvoidanceOutEdgeExplorer = this.prepareGraph.createOriginalEdgeExplorer(outEdgeFilter);
        this.hierarchyDepths = new int[this.prepareGraph.getNodes()];
    }

    @Override
    public void prepareContraction() {
    }

    @Override
    public float calculatePriority(int node) {
        this.activeShortcutHandler = this.countingShortcutHandler;
        this.stats().stopWatch.start();
        this.findAndHandleShortcuts(node);
        this.stats().stopWatch.stop();
        this.countPreviousEdges(node);
        float edgeQuotient = (float)this.numShortcuts / (float)this.numPrevEdges;
        float origEdgeQuotient = (float)this.numOrigEdges / (float)this.numPrevOrigEdges;
        int hierarchyDepth = this.hierarchyDepths[node];
        float priority = this.params.edgeQuotientWeight * edgeQuotient + this.params.originalEdgeQuotientWeight * origEdgeQuotient + this.params.hierarchyDepthWeight * (float)hierarchyDepth;
        LOGGER.trace(String.format(Locale.ROOT, "node: %d, eq: %d / %d = %f, oeq: %d / %d = %f, depth: %d --> %f\n", node, this.numShortcuts, this.numPrevEdges, Float.valueOf(edgeQuotient), this.numOrigEdges, this.numPrevOrigEdges, Float.valueOf(origEdgeQuotient), hierarchyDepth, Float.valueOf(priority)));
        return priority;
    }

    @Override
    public void contractNode(int node) {
        this.activeShortcutHandler = this.addingShortcutHandler;
        this.stats().stopWatch.start();
        this.findAndHandleShortcuts(node);
        this.updateHierarchyDepthsOfNeighbors(node);
        this.stats().stopWatch.stop();
    }

    @Override
    public long getAddedShortcutsCount() {
        return this.addedShortcutsCount;
    }

    @Override
    public long getDijkstraCount() {
        return this.witnessPathSearcher.getTotalNumSearches();
    }

    @Override
    public float getDijkstraSeconds() {
        return this.dijkstraSW.getCurrentSeconds();
    }

    @Override
    public String getStatisticsString() {
        String result = "sc-handler-count: " + this.countingShortcutHandler.getStats() + ", sc-handler-contract: " + this.addingShortcutHandler.getStats() + ", " + this.activeStrategy.getStatisticsString();
        this.activeStrategy.resetStats();
        return result;
    }

    public int getNumPolledEdges() {
        return this.numPolledEdges;
    }

    @Override
    boolean isEdgeBased() {
        return true;
    }

    private void findAndHandleShortcuts(int node) {
        this.numPolledEdges = 0;
        this.activeStrategy.findAndHandleShortcuts(node);
    }

    private void countPreviousEdges(int node) {
        BooleanEncodedValue accessEnc = this.encoder.getAccessEnc();
        CHEdgeIterator iter = this.allEdgeExplorer.setBaseNode(node);
        while (iter.next()) {
            if (this.isContracted(iter.getAdjNode())) continue;
            if (iter.get(accessEnc)) {
                ++this.numPrevEdges;
            }
            if (iter.getReverse(accessEnc)) {
                ++this.numPrevEdges;
            }
            if (!iter.isShortcut()) {
                if (iter.get(accessEnc)) {
                    ++this.numPrevOrigEdges;
                }
                if (!iter.getReverse(accessEnc)) continue;
                ++this.numPrevOrigEdges;
                continue;
            }
            this.numPrevOrigEdges += this.getOrigEdgeCount(iter.getEdge());
        }
    }

    private void updateHierarchyDepthsOfNeighbors(int node) {
        CHEdgeIterator iter = this.allEdgeExplorer.setBaseNode(node);
        while (iter.next()) {
            if (this.isContracted(iter.getAdjNode()) || iter.getAdjNode() == node) continue;
            this.hierarchyDepths[iter.getAdjNode()] = Math.max(this.hierarchyDepths[iter.getAdjNode()], this.hierarchyDepths[node] + 1);
        }
    }

    private void handleShortcuts(CHEntry chEntry, CHEntry root) {
        LOGGER.trace("Adding shortcuts for target entry {}", (Object)chEntry);
        if (root.parent.adjNode == chEntry.adjNode && !this.loopShortcutNecessary(chEntry.adjNode, root.getParent().incEdge, chEntry.incEdge, chEntry.weight)) {
            ++this.stats().loopsAvoided;
            return;
        }
        this.activeShortcutHandler.handleShortcut(root, chEntry);
    }

    private boolean loopShortcutNecessary(int node, int firstOrigEdge, int lastOrigEdge, double loopWeight) {
        EdgeIterator inIter = this.loopAvoidanceInEdgeExplorer.setBaseNode(node);
        while (inIter.next()) {
            EdgeIterator outIter = this.loopAvoidanceOutEdgeExplorer.setBaseNode(node);
            double inTurnCost = this.getTurnCost(inIter.getEdge(), node, firstOrigEdge);
            while (outIter.next()) {
                double directTurnCost;
                double totalLoopCost = inTurnCost + loopWeight + this.getTurnCost(lastOrigEdge, node, outIter.getEdge());
                if (!(totalLoopCost < (directTurnCost = this.getTurnCost(inIter.getEdge(), node, outIter.getEdge())))) continue;
                return true;
            }
        }
        LOGGER.trace("Loop avoidance -> no shortcut");
        return false;
    }

    private CHEntry addShortcut(CHEntry edgeFrom, CHEntry edgeTo) {
        if (edgeTo.parent.edge != edgeFrom.edge) {
            CHEntry prev = this.addShortcut(edgeFrom, edgeTo.getParent());
            return this.doAddShortcut(prev, edgeTo);
        }
        return this.doAddShortcut(edgeFrom, edgeTo);
    }

    private CHEntry doAddShortcut(CHEntry edgeFrom, CHEntry edgeTo) {
        int from = edgeFrom.parent.adjNode;
        int adjNode = edgeTo.adjNode;
        CHEdgeIterator iter = this.existingShortcutExplorer.setBaseNode(from);
        while (iter.next()) {
            if (!this.isSameShortcut(iter, adjNode, edgeFrom.getParent().incEdge, edgeTo.incEdge)) continue;
            double existingWeight = this.turnWeighting.calcWeight(iter, false, -1);
            if (existingWeight <= edgeTo.weight) {
                CHEntry entry = new CHEntry(iter.getEdge(), iter.getOrigEdgeLast(), adjNode, existingWeight);
                entry.parent = edgeFrom.parent;
                return entry;
            }
            iter.setSkippedEdges(edgeFrom.edge, edgeTo.edge);
            iter.setWeight(edgeTo.weight);
            CHEntry entry = new CHEntry(iter.getEdge(), iter.getOrigEdgeLast(), adjNode, edgeTo.weight);
            entry.parent = edgeFrom.parent;
            return entry;
        }
        int origFirst = edgeFrom.getParent().incEdge;
        LOGGER.trace("Adding shortcut from {} to {}, weight: {}, firstOrigEdge: {}, lastOrigEdge: {}", new Object[]{from, adjNode, edgeTo.weight, edgeFrom.getParent().incEdge, edgeTo.incEdge});
        double distance = 0.0;
        int accessFlags = PrepareEncoder.getScFwdDir();
        int shortcutId = this.prepareGraph.shortcutEdgeBased(from, adjNode, accessFlags, edgeTo.weight, distance, edgeFrom.edge, edgeTo.edge, origFirst, edgeTo.incEdge);
        int origEdgeCount = this.getOrigEdgeCount(edgeFrom.edge) + this.getOrigEdgeCount(edgeTo.edge);
        this.setOrigEdgeCount(shortcutId, origEdgeCount);
        ++this.addedShortcutsCount;
        CHEntry entry = new CHEntry(shortcutId, shortcutId, edgeTo.adjNode, edgeTo.weight);
        entry.parent = edgeFrom.parent;
        return entry;
    }

    private boolean isSameShortcut(CHEdgeIteratorState iter, int adjNode, int firstOrigEdge, int lastOrigEdge) {
        return iter.isShortcut() && iter.getAdjNode() == adjNode && iter.getOrigEdgeFirst() == firstOrigEdge && iter.getOrigEdgeLast() == lastOrigEdge;
    }

    private double getTurnCost(int inEdge, int node, int outEdge) {
        return this.turnWeighting.calcTurnWeight(inEdge, node, outEdge);
    }

    private void resetEdgeCounters() {
        this.numShortcuts = 0;
        this.numPrevEdges = 0;
        this.numOrigEdges = 0;
        this.numPrevOrigEdges = 0;
    }

    private Stats stats() {
        return this.activeShortcutHandler.getStats();
    }

    private static class AddedShortcut {
        int startNode;
        int startEdge;
        int endNode;
        int targetEdge;

        public AddedShortcut(int startNode, int startEdge, int endNode, int targetEdge) {
            this.startNode = startNode;
            this.startEdge = startEdge;
            this.endNode = endNode;
            this.targetEdge = targetEdge;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AddedShortcut that = (AddedShortcut)o;
            return this.startNode == that.startNode && this.startEdge == that.startEdge && this.endNode == that.endNode && this.targetEdge == that.targetEdge;
        }

        public int hashCode() {
            return Objects.hash(this.startNode, this.startEdge, this.endNode, this.targetEdge);
        }
    }

    private class AggressiveStrategy
    implements SearchStrategy {
        private AggressiveStrategy() {
        }

        @Override
        public String getStatisticsString() {
            return EdgeBasedNodeContractor.this.witnessPathSearcher.getStatisticsString();
        }

        @Override
        public void resetStats() {
            EdgeBasedNodeContractor.this.witnessPathSearcher.resetStats();
        }

        @Override
        public void findAndHandleShortcuts(int node) {
            LOGGER.trace("Finding shortcuts (aggressive) for node {}, required shortcuts will be {}ed", (Object)node, (Object)EdgeBasedNodeContractor.this.activeShortcutHandler.getAction());
            ++((EdgeBasedNodeContractor)EdgeBasedNodeContractor.this).stats().nodes;
            EdgeBasedNodeContractor.this.resetEdgeCounters();
            HashSet<AddedShortcut> addedShortcuts = new HashSet<AddedShortcut>();
            IntHashSet sourceNodes = new IntHashSet(100);
            CHEdgeIterator incomingEdges = EdgeBasedNodeContractor.this.inEdgeExplorer.setBaseNode(node);
            while (incomingEdges.next()) {
                boolean isNewSourceNode;
                int sourceNode = incomingEdges.getAdjNode();
                if (EdgeBasedNodeContractor.this.isContracted(sourceNode) || sourceNode == node || !(isNewSourceNode = sourceNodes.add(sourceNode))) continue;
                EdgeIterator origInIter = EdgeBasedNodeContractor.this.sourceNodeOrigInEdgeExplorer.setBaseNode(sourceNode);
                while (origInIter.next()) {
                    int numInitialEntries = EdgeBasedNodeContractor.this.witnessPathSearcher.initSearch(node, sourceNode, origInIter.getOrigEdgeLast());
                    if (numInitialEntries < 1) continue;
                    IntHashSet toNodes = new IntHashSet(100);
                    CHEdgeIterator outgoingEdges = EdgeBasedNodeContractor.this.outEdgeExplorer.setBaseNode(node);
                    while (outgoingEdges.next()) {
                        boolean isNewTargetNode;
                        int targetNode = outgoingEdges.getAdjNode();
                        if (EdgeBasedNodeContractor.this.isContracted(targetNode) || targetNode == node || !(isNewTargetNode = toNodes.add(targetNode))) continue;
                        EdgeIterator targetEdgeIter = EdgeBasedNodeContractor.this.targetNodeOrigOutEdgeExplorer.setBaseNode(targetNode);
                        while (targetEdgeIter.next()) {
                            int targetEdge = targetEdgeIter.getOrigEdgeFirst();
                            EdgeBasedNodeContractor.this.dijkstraSW.start();
                            CHEntry entry = EdgeBasedNodeContractor.this.witnessPathSearcher.runSearch(targetNode, targetEdge);
                            EdgeBasedNodeContractor.this.dijkstraSW.stop();
                            if (entry == null || Double.isInfinite(entry.weight)) continue;
                            CHEntry root = entry.getParent();
                            while (root.parent.edge != -1) {
                                root = root.getParent();
                            }
                            AddedShortcut addedShortcut = new AddedShortcut(sourceNode, root.getParent().incEdge, targetNode, entry.incEdge);
                            if (addedShortcuts.contains(addedShortcut)) continue;
                            double initialTurnCost = root.getParent().weight;
                            entry.weight -= initialTurnCost;
                            EdgeBasedNodeContractor.this.handleShortcuts(entry, root);
                            addedShortcuts.add(addedShortcut);
                        }
                    }
                    EdgeBasedNodeContractor.this.numPolledEdges = (int)((long)EdgeBasedNodeContractor.this.numPolledEdges + EdgeBasedNodeContractor.this.witnessPathSearcher.getNumPolledEdges());
                }
            }
        }
    }

    private static interface SearchStrategy {
        public void findAndHandleShortcuts(int var1);

        public String getStatisticsString();

        public void resetStats();
    }

    private static class Stats {
        int nodes;
        long loopsAvoided;
        StopWatch stopWatch = new StopWatch();

        private Stats() {
        }

        public String toString() {
            return String.format(Locale.ROOT, "time: %7.2fs, nodes-handled: %10s, loopsAvoided: %10s", Float.valueOf(this.stopWatch.getCurrentSeconds()), Helper.nf((long)this.nodes), Helper.nf((long)this.loopsAvoided));
        }
    }

    public static class Params {
        private float edgeQuotientWeight = 1.0f;
        private float originalEdgeQuotientWeight = 3.0f;
        private float hierarchyDepthWeight = 2.0f;
    }

    private class CountingShortcutHandler
    implements ShortcutHandler {
        private Stats stats = new Stats();

        private CountingShortcutHandler() {
        }

        @Override
        public void handleShortcut(CHEntry edgeFrom, CHEntry edgeTo) {
            int fromNode = edgeFrom.parent.adjNode;
            int toNode = edgeTo.adjNode;
            int firstOrigEdge = edgeFrom.getParent().incEdge;
            int lastOrigEdge = edgeTo.incEdge;
            CHEdgeIterator iter = EdgeBasedNodeContractor.this.existingShortcutExplorer.setBaseNode(fromNode);
            while (iter.next()) {
                if (!EdgeBasedNodeContractor.this.isSameShortcut(iter, toNode, firstOrigEdge, lastOrigEdge)) continue;
                return;
            }
            EdgeBasedNodeContractor.this.numShortcuts++;
            EdgeBasedNodeContractor.this.numOrigEdges = EdgeBasedNodeContractor.this.numOrigEdges + (EdgeBasedNodeContractor.this.getOrigEdgeCount(edgeFrom.edge) + EdgeBasedNodeContractor.this.getOrigEdgeCount(edgeTo.edge));
        }

        @Override
        public Stats getStats() {
            return this.stats;
        }

        @Override
        public String getAction() {
            return "count";
        }
    }

    private class AddingShortcutHandler
    implements ShortcutHandler {
        private Stats stats = new Stats();

        private AddingShortcutHandler() {
        }

        @Override
        public void handleShortcut(CHEntry edgeFrom, CHEntry edgeTo) {
            EdgeBasedNodeContractor.this.addShortcut(edgeFrom, edgeTo);
        }

        @Override
        public Stats getStats() {
            return this.stats;
        }

        @Override
        public String getAction() {
            return "add";
        }
    }

    private static interface ShortcutHandler {
        public void handleShortcut(CHEntry var1, CHEntry var2);

        public Stats getStats();

        public String getAction();
    }
}

