/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.profiles;

import com.graphhopper.routing.profiles.UnsignedIntEncodedValue;
import com.graphhopper.storage.IntsRef;
import java.util.Arrays;

public final class EnumEncodedValue<E extends Enum>
extends UnsignedIntEncodedValue {
    private final E[] arr;

    public EnumEncodedValue(String name, Class<E> enumType) {
        this(name, enumType, false);
    }

    public EnumEncodedValue(String name, Class<E> enumType, boolean storeTwoDirections) {
        super(name, 32 - Integer.numberOfLeadingZeros(((Enum[])enumType.getEnumConstants()).length), storeTwoDirections);
        this.arr = (Enum[])enumType.getEnumConstants();
    }

    public final void setEnum(boolean reverse, IntsRef ref, E value) {
        int intValue = ((Enum)value).ordinal();
        super.setInt(reverse, ref, intValue);
    }

    public final E getEnum(boolean reverse, IntsRef ref) {
        int value = super.getInt(reverse, ref);
        return this.arr[value];
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        EnumEncodedValue that = (EnumEncodedValue)o;
        return Arrays.equals(this.arr, that.arr);
    }

    @Override
    public int hashCode() {
        return 31 * super.hashCode() + Arrays.hashCode(this.arr);
    }

    @Override
    public int getVersion() {
        return this.hashCode();
    }
}

