/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.isochrone.algorithm;

import com.carrotsearch.hppc.IntObjectHashMap;
import com.carrotsearch.hppc.procedures.IntObjectProcedure;
import com.graphhopper.coll.GHIntObjectHashMap;
import com.graphhopper.routing.AbstractRoutingAlgorithm;
import com.graphhopper.routing.Path;
import com.graphhopper.routing.util.TraversalMode;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.storage.Graph;
import com.graphhopper.storage.NodeAccess;
import com.graphhopper.storage.SPTEntry;
import com.graphhopper.util.EdgeExplorer;
import com.graphhopper.util.EdgeIterator;
import com.graphhopper.util.EdgeIteratorState;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.PriorityQueue;
import java.util.Set;
import org.locationtech.jts.geom.Coordinate;

public class Isochrone
extends AbstractRoutingAlgorithm {
    private IntObjectHashMap<IsoLabel> fromMap;
    private PriorityQueue<IsoLabel> fromHeap;
    private IsoLabel currEdge;
    private int visitedNodes;
    private double limit = -1.0;
    private double finishLimit = -1.0;
    private ExploreType exploreType = ExploreType.TIME;
    private final boolean reverseFlow;

    public Isochrone(Graph g, Weighting weighting, boolean reverseFlow) {
        super(g, weighting, TraversalMode.NODE_BASED);
        this.fromHeap = new PriorityQueue(1000);
        this.fromMap = new GHIntObjectHashMap(1000);
        this.reverseFlow = reverseFlow;
    }

    public Path calcPath(int from, int to) {
        throw new IllegalStateException("call search instead");
    }

    public void setTimeLimit(double limit) {
        this.exploreType = ExploreType.TIME;
        this.limit = limit * 1000.0;
        this.finishLimit = this.limit + Math.max(this.limit * 0.14, 200000.0);
    }

    public void setDistanceLimit(double limit) {
        this.exploreType = ExploreType.DISTANCE;
        this.limit = limit;
        this.finishLimit = limit + Math.max(limit * 0.14, 2000.0);
    }

    public List<List<Coordinate>> searchGPS(int from, final int bucketCount) {
        this.searchInternal(from);
        final double bucketSize = this.limit / (double)bucketCount;
        final ArrayList<List<Coordinate>> buckets = new ArrayList<List<Coordinate>>(bucketCount);
        for (int i = 0; i < bucketCount + 1; ++i) {
            buckets.add(new ArrayList());
        }
        final NodeAccess na = this.graph.getNodeAccess();
        this.fromMap.forEach((IntObjectProcedure)new IntObjectProcedure<IsoLabel>(){

            public void apply(int nodeId, IsoLabel label) {
                int bucketIndex = (int)(Isochrone.this.getExploreValue(label) / bucketSize);
                if (bucketIndex < 0) {
                    throw new IllegalArgumentException("edge cannot have negative explore value " + nodeId + ", " + (Object)((Object)label));
                }
                if (bucketIndex > bucketCount) {
                    return;
                }
                double lat = na.getLatitude(nodeId);
                double lon = na.getLongitude(nodeId);
                ((List)buckets.get(bucketIndex)).add(new Coordinate(lon, lat));
                if (label.parent != null) {
                    nodeId = label.parent.adjNode;
                    double lat2 = na.getLatitude(nodeId);
                    double lon2 = na.getLongitude(nodeId);
                    ((List)buckets.get(bucketIndex)).add(new Coordinate((lon + lon2) / 2.0, (lat + lat2) / 2.0));
                }
            }
        });
        return buckets;
    }

    public List<Set<Integer>> search(int from, final int bucketCount) {
        this.searchInternal(from);
        final double bucketSize = this.limit / (double)bucketCount;
        final ArrayList<Set<Integer>> list = new ArrayList<Set<Integer>>(bucketCount);
        for (int i = 0; i < bucketCount; ++i) {
            list.add(new HashSet());
        }
        this.fromMap.forEach((IntObjectProcedure)new IntObjectProcedure<IsoLabel>(){

            public void apply(int nodeId, IsoLabel label) {
                if (Isochrone.this.finished()) {
                    return;
                }
                int bucketIndex = (int)(Isochrone.this.getExploreValue(label) / bucketSize);
                if (bucketIndex < 0) {
                    throw new IllegalArgumentException("edge cannot have negative explore value " + nodeId + ", " + (Object)((Object)label));
                }
                if (bucketIndex == bucketCount) {
                    bucketIndex = bucketCount - 1;
                } else if (bucketIndex > bucketCount) {
                    return;
                }
                ((Set)list.get(bucketIndex)).add(nodeId);
            }
        });
        return list;
    }

    private void searchInternal(int from) {
        block3: {
            this.checkAlreadyRun();
            this.currEdge = new IsoLabel(-1, from, 0.0, 0L, 0.0);
            this.fromMap.put(from, (Object)this.currEdge);
            EdgeExplorer explorer = this.reverseFlow ? this.inEdgeExplorer : this.outEdgeExplorer;
            do {
                ++this.visitedNodes;
                if (this.finished()) break block3;
                int neighborNode = this.currEdge.adjNode;
                EdgeIterator iter = explorer.setBaseNode(neighborNode);
                while (iter.next()) {
                    double tmpWeight;
                    if (!this.accept((EdgeIteratorState)iter, this.currEdge.edge) || this.currEdge.edge == iter.getEdge() || Double.isInfinite(tmpWeight = this.weighting.calcWeight((EdgeIteratorState)iter, this.reverseFlow, this.currEdge.edge) + this.currEdge.weight)) continue;
                    double tmpDistance = iter.getDistance() + this.currEdge.distance;
                    long tmpTime = this.weighting.calcMillis((EdgeIteratorState)iter, this.reverseFlow, this.currEdge.edge) + this.currEdge.time;
                    int tmpNode = iter.getAdjNode();
                    IsoLabel nEdge = (IsoLabel)((Object)this.fromMap.get(tmpNode));
                    if (nEdge == null) {
                        nEdge = new IsoLabel(iter.getEdge(), tmpNode, tmpWeight, tmpTime, tmpDistance);
                        nEdge.parent = this.currEdge;
                        this.fromMap.put(tmpNode, (Object)nEdge);
                        this.fromHeap.add(nEdge);
                        continue;
                    }
                    if (!(nEdge.weight > tmpWeight)) continue;
                    this.fromHeap.remove((Object)nEdge);
                    nEdge.edge = iter.getEdge();
                    nEdge.weight = tmpWeight;
                    nEdge.distance = tmpDistance;
                    nEdge.time = tmpTime;
                    nEdge.parent = this.currEdge;
                    this.fromHeap.add(nEdge);
                }
                if (this.fromHeap.isEmpty()) break block3;
                this.currEdge = this.fromHeap.poll();
            } while (this.currEdge != null);
            throw new AssertionError((Object)"Empty edge cannot happen");
        }
    }

    private double getExploreValue(IsoLabel label) {
        if (this.exploreType == ExploreType.TIME) {
            return label.time;
        }
        return label.distance;
    }

    protected boolean finished() {
        return this.getExploreValue(this.currEdge) >= this.finishLimit;
    }

    protected Path extractPath() {
        if (this.currEdge == null || !this.finished()) {
            return this.createEmptyPath();
        }
        return new Path(this.graph, this.weighting).setSPTEntry((SPTEntry)this.currEdge).extract();
    }

    public String getName() {
        return "reachability";
    }

    public int getVisitedNodes() {
        return this.visitedNodes;
    }

    class IsoLabel
    extends SPTEntry {
        public long time;
        public double distance;

        IsoLabel(int edgeId, int adjNode, double weight, long time, double distance) {
            super(edgeId, adjNode, weight);
            this.time = time;
            this.distance = distance;
        }

        public String toString() {
            return super.toString() + ", time:" + this.time + ", distance:" + this.distance;
        }
    }

    static enum ExploreType {
        TIME,
        DISTANCE;

    }
}

