/*
 * Decompiled with CFR 0.152.
 */
package proguard.configuration;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import proguard.classfile.ClassPool;
import proguard.classfile.Clazz;
import proguard.classfile.Field;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramField;
import proguard.classfile.ProgramMethod;
import proguard.classfile.util.ClassUtil;
import proguard.util.HashUtil;

public class InitialStateInfo {
    private final List<String> classNames = new ArrayList<String>();
    private final Map<String, String> superClassNames = new HashMap<String, String>();
    private final Map<String, Map<ProgramMethod, Integer>> methodHashes = new HashMap<String, Map<ProgramMethod, Integer>>();
    private final Map<String, Map<ProgramField, Integer>> fieldHashes = new HashMap<String, Map<ProgramField, Integer>>();

    public InitialStateInfo(ClassPool classPool) {
        this.initialize(classPool);
    }

    public int size() {
        return this.classNames.size();
    }

    public List<String> classNames() {
        return this.classNames;
    }

    public String getSuperClassName(String className) {
        return this.superClassNames.get(className);
    }

    public Map<ProgramMethod, Integer> getMethodHashMap(String className) {
        return this.methodHashes.containsKey(className) ? this.methodHashes.get(className) : new HashMap<ProgramMethod, Integer>();
    }

    public Map<ProgramField, Integer> getFieldHashMap(String className) {
        return this.fieldHashes.containsKey(className) ? this.fieldHashes.get(className) : new HashMap<ProgramField, Integer>();
    }

    private void initialize(ClassPool classPool) {
        Iterator iterator = classPool.classNames();
        while (iterator.hasNext()) {
            String className = (String)iterator.next();
            this.classNames.add(className);
            ProgramClass programClass = (ProgramClass)classPool.getClass(className);
            this.superClassNames.put(className, programClass.getSuperName());
            for (ProgramMethod programMethod : programClass.methods) {
                if (!this.methodHashes.containsKey(className)) {
                    this.methodHashes.put(className, new HashMap());
                }
                this.methodHashes.get(className).put(programMethod, InitialStateInfo.hash((Clazz)programClass, (Method)programMethod));
            }
            for (ProgramMethod programMethod : programClass.fields) {
                if (!this.fieldHashes.containsKey(className)) {
                    this.fieldHashes.put(className, new HashMap());
                }
                this.fieldHashes.get(className).put((ProgramField)programMethod, InitialStateInfo.hash((Clazz)programClass, (Field)programMethod));
            }
        }
    }

    private static int hash(Clazz clazz, Method method) {
        return HashUtil.hashFnv1a32_UTF8(method.getName(clazz) + "(" + ClassUtil.externalMethodArguments((String)method.getDescriptor(clazz)) + ")");
    }

    private static int hash(Clazz clazz, Field field) {
        return HashUtil.hashFnv1a32_UTF8(field.getName(clazz));
    }
}

