/*
 * Decompiled with CFR 0.152.
 */
package proguard.io;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.Set;
import proguard.io.DataEntry;
import proguard.io.DataEntryWriter;

public class UniqueDataEntryWriter
implements DataEntryWriter {
    private final DataEntryWriter dataEntryWriter;
    private final Set<String> written = new HashSet<String>();

    public UniqueDataEntryWriter(DataEntryWriter dataEntryWriter) {
        this.dataEntryWriter = dataEntryWriter;
    }

    public boolean createDirectory(DataEntry dataEntry) throws IOException {
        if (!this.written.contains(dataEntry.getName())) {
            try {
                boolean bl = this.dataEntryWriter.createDirectory(dataEntry);
                return bl;
            }
            finally {
                this.written.add(dataEntry.getName());
            }
        }
        return false;
    }

    public boolean sameOutputStream(DataEntry dataEntry1, DataEntry dataEntry2) throws IOException {
        return this.dataEntryWriter.sameOutputStream(dataEntry1, dataEntry2);
    }

    public OutputStream createOutputStream(DataEntry dataEntry) throws IOException {
        if (!this.written.contains(dataEntry.getName())) {
            try {
                OutputStream outputStream = this.dataEntryWriter.createOutputStream(dataEntry);
                return outputStream;
            }
            finally {
                this.written.add(dataEntry.getName());
            }
        }
        return null;
    }

    public void close() throws IOException {
        this.dataEntryWriter.close();
    }

    public void println(PrintWriter pw, String prefix) {
        pw.println(prefix + "UniqueDataEntryWriter");
        this.dataEntryWriter.println(pw, prefix + "  ");
    }
}

