/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.config;

import com.hazelcast.util.Preconditions;

public class LockConfig {
    private String name;
    private String quorumName;

    public LockConfig() {
    }

    public LockConfig(String name) {
        this.name = Preconditions.checkNotNull(name, "name can't be null");
    }

    public LockConfig(LockConfig config) {
        Preconditions.checkNotNull(config, "config can't be null");
        this.name = config.name;
        this.quorumName = config.quorumName;
    }

    public LockConfig(String name, LockConfig config) {
        this(config);
        this.name = Preconditions.checkNotNull(name, "name can't be null");
    }

    public LockConfig setName(String name) {
        this.name = Preconditions.checkHasText(name, "name must contain text");
        return this;
    }

    public String getName() {
        return this.name;
    }

    public String getQuorumName() {
        return this.quorumName;
    }

    public LockConfig setQuorumName(String quorumName) {
        this.quorumName = quorumName;
        return this;
    }

    public LockConfig getAsReadOnly() {
        return new LockConfigReadonly(this);
    }

    public String toString() {
        return "LockConfig{name='" + this.name + '\'' + ", quorumName='" + this.quorumName + '\'' + '}';
    }

    private static class LockConfigReadonly
    extends LockConfig {
        LockConfigReadonly(LockConfig config) {
            super(config);
        }

        @Override
        public LockConfig setName(String name) {
            throw new UnsupportedOperationException("This config is read-only");
        }

        @Override
        public LockConfig setQuorumName(String quorumName) {
            throw new UnsupportedOperationException("This config is read-only");
        }
    }
}

