/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.networking.nonblocking;

import com.hazelcast.internal.metrics.Probe;
import com.hazelcast.internal.metrics.ProbeLevel;
import com.hazelcast.internal.networking.SocketChannelWrapper;
import com.hazelcast.internal.networking.SocketConnection;
import com.hazelcast.internal.networking.nonblocking.MigratableHandler;
import com.hazelcast.internal.networking.nonblocking.NonBlockingIOThread;
import com.hazelcast.internal.networking.nonblocking.SelectionHandler;
import com.hazelcast.internal.networking.nonblocking.iobalancer.IOBalancer;
import com.hazelcast.internal.util.counters.SwCounter;
import com.hazelcast.logging.ILogger;
import java.io.EOFException;
import java.io.IOException;
import java.nio.channels.SelectionKey;

public abstract class AbstractHandler
implements SelectionHandler,
MigratableHandler {
    @Probe(name="eventCount")
    protected final SwCounter eventCount = SwCounter.newSwCounter();
    protected final ILogger logger;
    protected final SocketChannelWrapper socketChannel;
    protected final SocketConnection connection;
    protected NonBlockingIOThread ioThread;
    protected SelectionKey selectionKey;
    private final int initialOps;
    private final IOBalancer ioBalancer;
    @Probe
    private volatile int ioThreadId;
    @Probe
    private SwCounter migrationCount = SwCounter.newSwCounter();

    public AbstractHandler(SocketConnection connection, NonBlockingIOThread ioThread, int initialOps, ILogger logger, IOBalancer ioBalancer) {
        this.connection = connection;
        this.socketChannel = connection.getSocketChannel();
        this.ioThread = ioThread;
        this.ioThreadId = ioThread.id;
        this.logger = logger;
        this.initialOps = initialOps;
        this.ioBalancer = ioBalancer;
    }

    public SocketChannelWrapper getSocketChannel() {
        return this.socketChannel;
    }

    @Override
    public long getEventCount() {
        return this.eventCount.get();
    }

    @Probe(level=ProbeLevel.DEBUG)
    private long opsInterested() {
        SelectionKey selectionKey = this.selectionKey;
        return selectionKey == null ? -1L : (long)selectionKey.interestOps();
    }

    @Probe(level=ProbeLevel.DEBUG)
    private long opsReady() {
        SelectionKey selectionKey = this.selectionKey;
        return selectionKey == null ? -1L : (long)selectionKey.readyOps();
    }

    @Override
    public NonBlockingIOThread getOwner() {
        return this.ioThread;
    }

    protected SelectionKey getSelectionKey() throws IOException {
        if (this.selectionKey == null) {
            this.selectionKey = this.socketChannel.register(this.ioThread.getSelector(), this.initialOps, this);
        }
        return this.selectionKey;
    }

    final void setSelectionKey(SelectionKey selectionKey) {
        this.selectionKey = selectionKey;
    }

    final void registerOp(int operation) throws IOException {
        SelectionKey selectionKey = this.getSelectionKey();
        selectionKey.interestOps(selectionKey.interestOps() | operation);
    }

    final void unregisterOp(int operation) throws IOException {
        SelectionKey selectionKey = this.getSelectionKey();
        selectionKey.interestOps(selectionKey.interestOps() & ~operation);
    }

    @Override
    public void onFailure(Throwable e) {
        if (e instanceof OutOfMemoryError) {
            this.ioThread.getOomeHandler().handle((OutOfMemoryError)e);
        }
        if (this.selectionKey != null) {
            this.selectionKey.cancel();
        }
        if (e instanceof EOFException) {
            this.connection.close("Connection closed by the other side", e);
        } else {
            this.connection.close("Exception in " + this.getClass().getSimpleName(), e);
        }
    }

    void startMigration(final NonBlockingIOThread newOwner) throws IOException {
        assert (this.ioThread == Thread.currentThread()) : "startMigration can only run on the owning NonBlockingIOThread";
        assert (this.ioThread != newOwner) : "newOwner can't be the same as the existing owner";
        if (!this.socketChannel.isOpen()) {
            return;
        }
        this.migrationCount.inc();
        this.unregisterOp(this.initialOps);
        this.ioThread = newOwner;
        this.ioThreadId = this.ioThread.id;
        this.selectionKey.cancel();
        this.selectionKey = null;
        newOwner.addTaskAndWakeup(new Runnable(){

            @Override
            public void run() {
                try {
                    AbstractHandler.this.completeMigration(newOwner);
                }
                catch (Throwable t) {
                    AbstractHandler.this.onFailure(t);
                }
            }
        });
    }

    private void completeMigration(NonBlockingIOThread newOwner) throws IOException {
        assert (this.ioThread == newOwner);
        this.ioBalancer.signalMigrationComplete();
        if (!this.socketChannel.isOpen()) {
            return;
        }
        this.selectionKey = this.getSelectionKey();
        this.registerOp(this.initialOps);
    }
}

