/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.operation;

import com.hazelcast.concurrent.lock.LockWaitNotifyKey;
import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.config.MapConfig;
import com.hazelcast.core.EntryEventType;
import com.hazelcast.core.EntryView;
import com.hazelcast.map.EntryBackupProcessor;
import com.hazelcast.map.impl.EntryViews;
import com.hazelcast.map.impl.MapContainer;
import com.hazelcast.map.impl.MapServiceContext;
import com.hazelcast.map.impl.operation.EntryBackupOperation;
import com.hazelcast.map.impl.operation.EntryOffloadableLockMismatchException;
import com.hazelcast.map.impl.operation.MutatingKeyBasedMapOperation;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.BackupAwareOperation;
import com.hazelcast.spi.DefaultObjectNamespace;
import com.hazelcast.spi.EventService;
import com.hazelcast.spi.Notifier;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.WaitNotifyKey;
import com.hazelcast.util.Clock;
import java.io.IOException;

public class EntryOffloadableSetUnlockOperation
extends MutatingKeyBasedMapOperation
implements BackupAwareOperation,
Notifier {
    protected Data value;
    protected Data oldValue;
    protected String caller;
    protected long begin;
    protected EntryEventType modificationType;
    protected EntryBackupProcessor entryBackupProcessor;

    public EntryOffloadableSetUnlockOperation() {
    }

    public EntryOffloadableSetUnlockOperation(String name, EntryEventType modificationType, Data key, Data oldValue, Data value, String caller, long threadId, long begin, EntryBackupProcessor entryBackupProcessor) {
        super(name, key, value);
        this.value = value;
        this.oldValue = oldValue;
        this.caller = caller;
        this.begin = begin;
        this.modificationType = modificationType;
        this.entryBackupProcessor = entryBackupProcessor;
        this.setThreadId(threadId);
    }

    @Override
    public void run() throws Exception {
        this.verifyLock();
        try {
            this.updateRecordStore();
        }
        finally {
            this.unlockKey();
        }
    }

    private void verifyLock() {
        if (!this.recordStore.isLockedBy(this.dataKey, this.caller, this.threadId)) {
            throw new EntryOffloadableLockMismatchException(String.format("The key is not locked by the caller=%s and threadId=%d", this.caller, this.threadId));
        }
    }

    private void updateRecordStore() {
        if (this.modificationType == null) {
            return;
        }
        if (this.modificationType == EntryEventType.REMOVED) {
            this.recordStore.remove(this.dataKey);
            this.getLocalMapStats().incrementRemoves(this.getLatencyFrom(this.begin));
        } else if (this.modificationType == EntryEventType.ADDED || this.modificationType == EntryEventType.UPDATED) {
            this.recordStore.set(this.dataKey, this.value, -1L);
            this.getLocalMapStats().incrementPuts(this.getLatencyFrom(this.begin));
        } else {
            throw new IllegalArgumentException("Unsupported event type " + (Object)((Object)this.modificationType));
        }
    }

    private void unlockKey() {
        boolean unlocked = this.recordStore.unlock(this.dataKey, this.caller, this.threadId, this.getCallId());
        if (!unlocked) {
            throw new IllegalStateException(String.format("Unexpected error! EntryOffloadableSetUnlockOperation finished but the unlock method returned false for caller=%s and threadId=%d", this.caller, this.threadId));
        }
    }

    @Override
    public void afterRun() throws Exception {
        super.afterRun();
        if (this.modificationType == null) {
            return;
        }
        this.mapServiceContext.interceptAfterPut(this.name, this.value);
        if (this.isPostProcessing(this.recordStore)) {
            Object record = this.recordStore.getRecord(this.dataKey);
            this.value = record == null ? null : this.toData(record.getValue());
        }
        this.invalidateNearCache(this.dataKey);
        this.publishEntryEvent();
        this.publishWanReplicationEvent();
        this.evict(this.dataKey);
    }

    private void publishWanReplicationEvent() {
        MapContainer mapContainer = this.mapContainer;
        if (mapContainer.getWanReplicationPublisher() == null && mapContainer.getWanMergePolicy() == null) {
            return;
        }
        Data key = this.getKey();
        if (EntryEventType.REMOVED.equals((Object)this.modificationType)) {
            this.mapEventPublisher.publishWanReplicationRemove(this.name, key, this.begin);
        } else {
            Object record = this.recordStore.getRecord(key);
            if (record != null) {
                EntryView<Data, Data> entryView = EntryViews.createSimpleEntryView(key, this.value, record);
                this.mapEventPublisher.publishWanReplicationUpdate(this.name, entryView);
            }
        }
    }

    private void publishEntryEvent() {
        if (this.hasRegisteredListenerForThisMap()) {
            this.nullifyOldValueIfNecessary();
            this.mapEventPublisher.publishEvent(this.getCallerAddress(), this.name, this.modificationType, this.dataKey, this.oldValue, this.value);
        }
    }

    private boolean hasRegisteredListenerForThisMap() {
        EventService eventService = this.getNodeEngine().getEventService();
        return eventService.hasEventRegistration("hz:impl:mapService", this.name);
    }

    private void nullifyOldValueIfNecessary() {
        MapConfig mapConfig = this.mapContainer.getMapConfig();
        InMemoryFormat format = mapConfig.getInMemoryFormat();
        if (format == InMemoryFormat.OBJECT && this.modificationType != EntryEventType.REMOVED) {
            this.oldValue = null;
        }
    }

    private Data toData(Object obj) {
        MapServiceContext mapServiceContext = this.mapService.getMapServiceContext();
        return mapServiceContext.toData(obj);
    }

    private long getLatencyFrom(long begin) {
        return Clock.currentTimeMillis() - begin;
    }

    @Override
    public boolean returnsResponse() {
        return true;
    }

    @Override
    public Operation getBackupOperation() {
        return this.entryBackupProcessor != null ? new EntryBackupOperation(this.name, this.dataKey, this.entryBackupProcessor) : null;
    }

    @Override
    public boolean shouldBackup() {
        return this.mapContainer.getTotalBackupCount() > 0 && this.entryBackupProcessor != null;
    }

    @Override
    public int getAsyncBackupCount() {
        return this.mapContainer.getAsyncBackupCount();
    }

    @Override
    public int getSyncBackupCount() {
        return this.mapContainer.getBackupCount();
    }

    @Override
    public boolean shouldNotify() {
        return true;
    }

    @Override
    public WaitNotifyKey getNotifiedKey() {
        return new LockWaitNotifyKey(new DefaultObjectNamespace("hz:impl:mapService", this.name), this.dataKey);
    }

    @Override
    public String getServiceName() {
        return "hz:impl:mapService";
    }

    @Override
    public int getId() {
        return 136;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeUTF(this.modificationType != null ? this.modificationType.name() : "");
        out.writeData(this.oldValue);
        out.writeData(this.value);
        out.writeUTF(this.caller);
        out.writeLong(this.begin);
        out.writeObject(this.entryBackupProcessor);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        String modificationTypeName = in.readUTF();
        this.modificationType = modificationTypeName.equals("") ? null : EntryEventType.valueOf(modificationTypeName);
        this.oldValue = in.readData();
        this.value = in.readData();
        this.caller = in.readUTF();
        this.begin = in.readLong();
        this.entryBackupProcessor = (EntryBackupProcessor)in.readObject();
    }
}

