/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.hibernate.distributed;

import com.hazelcast.core.EntryView;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.hibernate.CacheEnvironment;
import com.hazelcast.hibernate.HazelcastTimestamper;
import com.hazelcast.hibernate.RegionCache;
import com.hazelcast.hibernate.distributed.LockEntryProcessor;
import com.hazelcast.hibernate.distributed.UnlockEntryProcessor;
import com.hazelcast.hibernate.distributed.UpdateEntryProcessor;
import com.hazelcast.hibernate.serialization.Expirable;
import com.hazelcast.hibernate.serialization.ExpiryMarker;
import com.hazelcast.hibernate.serialization.MarkerWrapper;
import com.hazelcast.hibernate.serialization.Value;
import com.hazelcast.map.IMap;
import java.util.Comparator;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicLong;
import org.hibernate.cache.spi.CacheDataDescription;
import org.hibernate.cache.spi.access.SoftLock;

public class IMapRegionCache
implements RegionCache {
    private static final long COMPARISON_VALUE = 500L;
    private final String name;
    private final HazelcastInstance hazelcastInstance;
    private final IMap<Object, Expirable> map;
    private final Comparator versionComparator;
    private final int lockTimeout;
    private final long tryLockAndGetTimeout;
    private final AtomicLong markerIdCounter;

    public IMapRegionCache(String name, HazelcastInstance hazelcastInstance, Properties props, CacheDataDescription metadata) {
        this.name = name;
        this.hazelcastInstance = hazelcastInstance;
        this.versionComparator = metadata != null && metadata.isVersioned() ? metadata.getVersionComparator() : null;
        this.map = hazelcastInstance.getMap(this.name);
        this.lockTimeout = CacheEnvironment.getLockTimeoutInMillis(props);
        long maxOperationTimeout = HazelcastTimestamper.getMaxOperationTimeout(hazelcastInstance);
        this.tryLockAndGetTimeout = Math.min(maxOperationTimeout, 500L);
        this.markerIdCounter = new AtomicLong();
    }

    @Override
    public Object get(Object key, long txTimestamp) {
        Expirable entry = this.map.get(key);
        return entry == null ? null : entry.getValue(txTimestamp);
    }

    @Override
    public boolean insert(Object key, Object value, Object currentVersion) {
        return this.map.putIfAbsent(key, new Value(currentVersion, HazelcastTimestamper.nextTimestamp(this.hazelcastInstance), value)) == null;
    }

    @Override
    public boolean put(Object key, Object value, long txTimestamp, Object version) {
        long timeout = System.currentTimeMillis() + this.tryLockAndGetTimeout;
        do {
            Expirable previousEntry = this.map.get(key);
            Value newValue = new Value(version, txTimestamp, value);
            if (previousEntry == null) {
                if (this.map.putIfAbsent(key, newValue) != null) continue;
                return true;
            }
            if (previousEntry.isReplaceableBy(txTimestamp, version, this.versionComparator)) {
                if (!this.map.replace(key, previousEntry, newValue)) continue;
                return true;
            }
            return false;
        } while (System.currentTimeMillis() < timeout);
        return false;
    }

    @Override
    public boolean update(Object key, Object newValue, Object newVersion, SoftLock lock) {
        if (lock instanceof MarkerWrapper) {
            ExpiryMarker unwrappedMarker = ((MarkerWrapper)lock).getMarker();
            return this.map.executeOnKey(key, new UpdateEntryProcessor(unwrappedMarker, newValue, newVersion, this.nextMarkerId(), HazelcastTimestamper.nextTimestamp(this.hazelcastInstance)));
        }
        return false;
    }

    @Override
    public boolean remove(Object key) {
        return this.map.remove(key) != null;
    }

    @Override
    public SoftLock tryLock(Object key, Object version) {
        long timeout = HazelcastTimestamper.nextTimestamp(this.hazelcastInstance) + (long)this.lockTimeout;
        ExpiryMarker marker = (ExpiryMarker)this.map.executeOnKey(key, new LockEntryProcessor(this.nextMarkerId(), timeout, version));
        return new MarkerWrapper(marker);
    }

    @Override
    public void unlock(Object key, SoftLock lock) {
        if (lock instanceof MarkerWrapper) {
            ExpiryMarker unwrappedMarker = ((MarkerWrapper)lock).getMarker();
            this.map.executeOnKey(key, new UnlockEntryProcessor(unwrappedMarker, this.nextMarkerId(), HazelcastTimestamper.nextTimestamp(this.hazelcastInstance)));
        }
    }

    @Override
    public boolean contains(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public void clear() {
        this.map.evictAll();
    }

    @Override
    public long size() {
        return this.map.size();
    }

    @Override
    public long getSizeInMemory() {
        long size = 0L;
        for (Object key : this.map.keySet()) {
            EntryView<Object, Expirable> entry = this.map.getEntryView(key);
            if (entry == null) continue;
            size += entry.getCost();
        }
        return size;
    }

    @Override
    public Map asMap() {
        return this.map;
    }

    private String nextMarkerId() {
        return this.hazelcastInstance.getLocalEndpoint().getUuid().toString() + this.markerIdCounter.getAndIncrement();
    }
}

