/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.util;

import com.hazelcast.core.HazelcastException;
import com.hazelcast.instance.impl.OutOfMemoryErrorDispatcher;
import com.hazelcast.logging.ILogger;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.ExecutionException;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import javax.annotation.Nonnull;

public final class ExceptionUtil {
    private static final BiFunction<Throwable, String, HazelcastException> HAZELCAST_EXCEPTION_WRAPPER = (throwable, message) -> {
        if (message != null) {
            return new HazelcastException((String)message, (Throwable)throwable);
        }
        return new HazelcastException((Throwable)throwable);
    };

    private ExceptionUtil() {
    }

    public static String toString(Throwable cause) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        cause.printStackTrace(pw);
        return sw.toString();
    }

    public static RuntimeException peel(Throwable t) {
        return (RuntimeException)ExceptionUtil.peel(t, null, null, HAZELCAST_EXCEPTION_WRAPPER);
    }

    public static <T extends Throwable> Throwable peel(Throwable t, Class<T> allowedType, String message) {
        return ExceptionUtil.peel(t, allowedType, message, HAZELCAST_EXCEPTION_WRAPPER);
    }

    public static <T, W extends Throwable> Throwable peel(Throwable t, Class<T> allowedType, String message, BiFunction<Throwable, String, W> exceptionWrapper) {
        if (t instanceof RuntimeException) {
            return t;
        }
        if (t instanceof ExecutionException || t instanceof InvocationTargetException) {
            Throwable cause = t.getCause();
            if (cause != null) {
                return ExceptionUtil.peel(cause, allowedType, message, exceptionWrapper);
            }
            return (Throwable)exceptionWrapper.apply(t, message);
        }
        if (allowedType != null && allowedType.isAssignableFrom(t.getClass())) {
            return t;
        }
        return (Throwable)exceptionWrapper.apply(t, message);
    }

    public static RuntimeException rethrow(Throwable t) {
        ExceptionUtil.rethrowIfError(t);
        throw ExceptionUtil.peel(t);
    }

    public static RuntimeException rethrow(Throwable t, BiFunction<Throwable, String, RuntimeException> exceptionWrapper) {
        ExceptionUtil.rethrowIfError(t);
        throw (RuntimeException)ExceptionUtil.peel(t, null, null, exceptionWrapper);
    }

    public static <T extends Throwable> RuntimeException rethrow(Throwable t, Class<T> allowedType) throws T {
        ExceptionUtil.rethrowIfError(t);
        throw ExceptionUtil.peel(t, allowedType, null);
    }

    public static <T extends Throwable> RuntimeException rethrowAllowedTypeFirst(Throwable t, Class<T> allowedType) throws T {
        ExceptionUtil.rethrowIfError(t);
        if (allowedType.isAssignableFrom(t.getClass())) {
            throw t;
        }
        throw ExceptionUtil.peel(t);
    }

    public static void rethrowIfError(Throwable t) {
        if (t instanceof Error) {
            if (t instanceof OutOfMemoryError) {
                OutOfMemoryErrorDispatcher.onOutOfMemory((OutOfMemoryError)t);
            }
            throw (Error)t;
        }
    }

    public static RuntimeException rethrowAllowInterrupted(Throwable t) throws InterruptedException {
        return ExceptionUtil.rethrow(t, InterruptedException.class);
    }

    @Nonnull
    public static <T extends Throwable> RuntimeException sneakyThrow(@Nonnull Throwable t) throws T {
        throw t;
    }

    @Nonnull
    public static <T> BiConsumer<T, ? super Throwable> withTryCatch(@Nonnull ILogger logger, @Nonnull BiConsumer<T, ? super Throwable> consumer) {
        return ExceptionUtil.withTryCatch(logger, "Exception during callback", consumer);
    }

    @Nonnull
    public static <T> BiConsumer<T, ? super Throwable> withTryCatch(@Nonnull ILogger logger, @Nonnull String message, @Nonnull BiConsumer<T, ? super Throwable> consumer) {
        return (r, t) -> {
            try {
                consumer.accept((Object)r, (Throwable)t);
            }
            catch (Throwable e) {
                logger.severe(message, e);
            }
        };
    }
}

