/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.task.map;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.MapSizeCodec;
import com.hazelcast.client.impl.protocol.task.map.AbstractMapAllPartitionsMessageTask;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.nio.Connection;
import com.hazelcast.internal.util.MapUtil;
import com.hazelcast.map.impl.LocalMapStatsUtil;
import com.hazelcast.map.impl.MapService;
import com.hazelcast.security.permission.MapPermission;
import com.hazelcast.spi.impl.operationservice.OperationFactory;
import java.security.Permission;
import java.util.Map;

public class MapSizeMessageTask
extends AbstractMapAllPartitionsMessageTask<String> {
    public MapSizeMessageTask(ClientMessage clientMessage, Node node, Connection connection) {
        super(clientMessage, node, connection);
    }

    @Override
    protected OperationFactory createOperationFactory() {
        String mapName = (String)this.parameters;
        return this.getOperationProvider(mapName).createMapSizeOperationFactory(mapName);
    }

    @Override
    protected Object reduce(Map<Integer, Object> map) {
        long total = 0L;
        MapService mapService = (MapService)this.getService("hz:impl:mapService");
        for (Object result : map.values()) {
            Integer size = (Integer)mapService.getMapServiceContext().toObject(result);
            total += (long)size.intValue();
        }
        LocalMapStatsUtil.incrementOtherOperationsCount(mapService, (String)this.parameters);
        return MapUtil.toIntSize(total);
    }

    @Override
    protected String decodeClientMessage(ClientMessage clientMessage) {
        return MapSizeCodec.decodeRequest(clientMessage);
    }

    @Override
    protected ClientMessage encodeResponse(Object response) {
        return MapSizeCodec.encodeResponse((Integer)response);
    }

    @Override
    public String getServiceName() {
        return "hz:impl:mapService";
    }

    @Override
    public Permission getRequiredPermission() {
        return new MapPermission((String)this.parameters, "read");
    }

    @Override
    public String getDistributedObjectName() {
        return (String)this.parameters;
    }

    @Override
    public String getMethodName() {
        return "size";
    }

    @Override
    public Object[] getParameters() {
        return null;
    }
}

