/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.apache.calcite.linq4j.tree;

import com.hazelcast.org.apache.calcite.linq4j.tree.Evaluator;
import com.hazelcast.org.apache.calcite.linq4j.tree.Expression;
import com.hazelcast.org.apache.calcite.linq4j.tree.ExpressionType;
import com.hazelcast.org.apache.calcite.linq4j.tree.ExpressionWriter;
import com.hazelcast.org.apache.calcite.linq4j.tree.GotoExpressionKind;
import com.hazelcast.org.apache.calcite.linq4j.tree.LabelTarget;
import com.hazelcast.org.apache.calcite.linq4j.tree.Shuttle;
import com.hazelcast.org.apache.calcite.linq4j.tree.Statement;
import com.hazelcast.org.apache.calcite.linq4j.tree.Visitor;
import java.util.Objects;

public class GotoStatement
extends Statement {
    public final GotoExpressionKind kind;
    public final LabelTarget labelTarget;
    public final Expression expression;

    GotoStatement(GotoExpressionKind kind, LabelTarget labelTarget, Expression expression) {
        super(ExpressionType.Goto, expression == null ? Void.TYPE : expression.getType());
        assert (kind != null) : "kind should not be null";
        this.kind = kind;
        this.labelTarget = labelTarget;
        this.expression = expression;
        switch (kind) {
            case Break: 
            case Continue: {
                assert (expression == null);
                break;
            }
            case Goto: {
                assert (expression == null);
                assert (labelTarget != null);
                break;
            }
            case Return: 
            case Sequence: {
                assert (labelTarget == null);
                break;
            }
            default: {
                throw new RuntimeException("unexpected: " + (Object)((Object)kind));
            }
        }
    }

    @Override
    public Statement accept(Shuttle shuttle) {
        shuttle = shuttle.preVisit(this);
        Expression expression1 = this.expression == null ? null : this.expression.accept(shuttle);
        return shuttle.visit(this, expression1);
    }

    @Override
    public <R> R accept(Visitor<R> visitor) {
        return visitor.visit(this);
    }

    @Override
    void accept0(ExpressionWriter writer) {
        writer.append(this.kind.prefix);
        if (this.labelTarget != null) {
            writer.append(' ').append(this.labelTarget.name);
        }
        if (this.expression != null) {
            if (!this.kind.prefix.isEmpty()) {
                writer.append(' ');
            }
            switch (this.kind) {
                case Sequence: {
                    this.expression.accept(writer, 0, 0);
                    break;
                }
                default: {
                    writer.begin();
                    this.expression.accept(writer, 0, 0);
                    writer.end();
                }
            }
        }
        writer.append(';').newlineAndIndent();
    }

    @Override
    public Object evaluate(Evaluator evaluator) {
        switch (this.kind) {
            case Return: 
            case Sequence: {
                return this.expression.evaluate(evaluator);
            }
        }
        throw new AssertionError((Object)"evaluate not implemented");
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        GotoStatement that = (GotoStatement)o;
        if (this.expression != null ? !this.expression.equals(that.expression) : that.expression != null) {
            return false;
        }
        if (this.kind != that.kind) {
            return false;
        }
        return !(this.labelTarget != null ? !this.labelTarget.equals(that.labelTarget) : that.labelTarget != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.nodeType, this.type, this.kind, this.labelTarget, this.expression});
    }
}

