/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.apache.calcite.sql.fun;

import com.hazelcast.org.apache.calcite.rel.type.RelDataType;
import com.hazelcast.org.apache.calcite.sql.SqlAggFunction;
import com.hazelcast.org.apache.calcite.sql.SqlCall;
import com.hazelcast.org.apache.calcite.sql.SqlFunctionCategory;
import com.hazelcast.org.apache.calcite.sql.SqlJsonConstructorNullClause;
import com.hazelcast.org.apache.calcite.sql.SqlKind;
import com.hazelcast.org.apache.calcite.sql.SqlLiteral;
import com.hazelcast.org.apache.calcite.sql.SqlNode;
import com.hazelcast.org.apache.calcite.sql.SqlWriter;
import com.hazelcast.org.apache.calcite.sql.fun.SqlStdOperatorTable;
import com.hazelcast.org.apache.calcite.sql.parser.SqlParserPos;
import com.hazelcast.org.apache.calcite.sql.type.InferTypes;
import com.hazelcast.org.apache.calcite.sql.type.OperandTypes;
import com.hazelcast.org.apache.calcite.sql.type.ReturnTypes;
import com.hazelcast.org.apache.calcite.sql.type.SqlTypeFamily;
import com.hazelcast.org.apache.calcite.sql.validate.SqlValidator;
import com.hazelcast.org.apache.calcite.sql.validate.SqlValidatorImpl;
import com.hazelcast.org.apache.calcite.sql.validate.SqlValidatorScope;
import com.hazelcast.org.apache.calcite.util.Optionality;
import java.util.Objects;

public class SqlJsonArrayAggAggFunction
extends SqlAggFunction {
    private final SqlJsonConstructorNullClause nullClause;

    public SqlJsonArrayAggAggFunction(SqlKind kind, SqlJsonConstructorNullClause nullClause) {
        super((Object)((Object)kind) + "_" + nullClause.name(), null, kind, ReturnTypes.VARCHAR_2000, InferTypes.ANY_NULLABLE, OperandTypes.family(SqlTypeFamily.ANY), SqlFunctionCategory.SYSTEM, false, false, Optionality.OPTIONAL);
        this.nullClause = Objects.requireNonNull(nullClause);
    }

    @Override
    public void unparse(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
        assert (call.operandCount() == 1);
        SqlWriter.Frame frame = writer.startFunCall("JSON_ARRAYAGG");
        ((SqlNode)call.operand(0)).unparse(writer, leftPrec, rightPrec);
        writer.keyword(this.nullClause.sql);
        writer.endFunCall(frame);
    }

    @Override
    public RelDataType deriveType(SqlValidator validator, SqlValidatorScope scope, SqlCall call) {
        for (SqlNode operand : call.getOperandList()) {
            RelDataType nodeType = validator.deriveType(scope, operand);
            ((SqlValidatorImpl)validator).setValidatedNodeType(operand, nodeType);
        }
        return this.validateOperands(validator, scope, call);
    }

    @Override
    public SqlCall createCall(SqlLiteral functionQualifier, SqlParserPos pos, SqlNode ... operands) {
        SqlNode orderList;
        assert (operands.length == 1 || operands.length == 2);
        SqlNode valueExpr = operands[0];
        if (operands.length == 2 && (orderList = operands[1]) != null) {
            return SqlStdOperatorTable.WITHIN_GROUP.createCall(SqlParserPos.ZERO, this.createCall_(functionQualifier, pos, valueExpr), orderList);
        }
        return this.createCall_(functionQualifier, pos, valueExpr);
    }

    private SqlCall createCall_(SqlLiteral functionQualifier, SqlParserPos pos, SqlNode valueExpr) {
        return super.createCall(functionQualifier, pos, valueExpr);
    }

    public SqlJsonArrayAggAggFunction with(SqlJsonConstructorNullClause nullClause) {
        return this.nullClause == nullClause ? this : new SqlJsonArrayAggAggFunction(this.getKind(), nullClause);
    }

    public SqlJsonConstructorNullClause getNullClause() {
        return this.nullClause;
    }
}

