/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.calcite;

import com.hazelcast.org.apache.calcite.plan.RelOptCluster;
import com.hazelcast.org.apache.calcite.plan.RelOptTable;
import com.hazelcast.org.apache.calcite.prepare.Prepare;
import com.hazelcast.org.apache.calcite.rel.type.RelDataType;
import com.hazelcast.org.apache.calcite.rex.RexLiteral;
import com.hazelcast.org.apache.calcite.rex.RexNode;
import com.hazelcast.org.apache.calcite.sql.SqlCall;
import com.hazelcast.org.apache.calcite.sql.SqlKind;
import com.hazelcast.org.apache.calcite.sql.SqlLiteral;
import com.hazelcast.org.apache.calcite.sql.SqlNode;
import com.hazelcast.org.apache.calcite.sql.SqlUtil;
import com.hazelcast.org.apache.calcite.sql.type.SqlTypeName;
import com.hazelcast.org.apache.calcite.sql.validate.SqlValidator;
import com.hazelcast.org.apache.calcite.sql2rel.SqlRexConvertletTable;
import com.hazelcast.org.apache.calcite.sql2rel.SqlToRelConverter;
import com.hazelcast.sql.impl.calcite.SqlToQueryType;
import com.hazelcast.sql.impl.calcite.validate.types.HazelcastTypeSystem;
import com.hazelcast.sql.impl.expression.math.ExpressionMath;
import com.hazelcast.sql.impl.type.converter.BigDecimalConverter;
import com.hazelcast.sql.impl.type.converter.BooleanConverter;
import com.hazelcast.sql.impl.type.converter.Converter;
import com.hazelcast.sql.impl.type.converter.StringConverter;
import java.math.BigDecimal;

public class HazelcastSqlToRelConverter
extends SqlToRelConverter {
    public HazelcastSqlToRelConverter(RelOptTable.ViewExpander viewExpander, SqlValidator validator, Prepare.CatalogReader catalogReader, RelOptCluster cluster, SqlRexConvertletTable convertletTable, SqlToRelConverter.Config config) {
        super(viewExpander, validator, catalogReader, cluster, convertletTable, config);
    }

    @Override
    protected RexNode convertExtendedExpression(SqlNode node, SqlToRelConverter.Blackboard blackboard) {
        if (node.getKind() == SqlKind.LITERAL) {
            return this.convertLiteral((SqlLiteral)node);
        }
        if (node.getKind() == SqlKind.CAST) {
            return this.convertCast((SqlCall)node, blackboard);
        }
        return null;
    }

    private RexNode convertCast(SqlCall call, SqlToRelConverter.Blackboard blackboard) {
        RexLiteral literal;
        RelDataType to = this.validator.getValidatedNodeType(call);
        RexNode operand = blackboard.convertExpression((SqlNode)call.operand(0));
        if (SqlUtil.isNullLiteral(call.operand(0), false)) {
            return this.getRexBuilder().makeCast(to, operand);
        }
        RelDataType from = operand.getType();
        if (operand.isA(SqlKind.LITERAL) && HazelcastTypeSystem.isChar(to)) {
            literal = (RexLiteral)operand;
            switch (from.getSqlTypeName()) {
                case REAL: 
                case DOUBLE: 
                case DECIMAL: {
                    BigDecimal decimalValue = literal.getValueAs(BigDecimal.class);
                    Converter fromConverter = SqlToQueryType.map(from.getSqlTypeName()).getConverter();
                    Object value = fromConverter.convertToSelf(BigDecimalConverter.INSTANCE, decimalValue);
                    Object valueAsString = StringConverter.INSTANCE.convertToSelf(fromConverter, value);
                    return this.getRexBuilder().makeLiteral(valueAsString, to, true);
                }
                case BOOLEAN: {
                    boolean booleanValue = literal.getValueAs(Boolean.class);
                    String booleanAsString = BooleanConverter.INSTANCE.asVarchar(booleanValue);
                    return this.getRexBuilder().makeLiteral(booleanAsString, to, true);
                }
            }
        }
        if (operand.isA(SqlKind.LITERAL) && HazelcastTypeSystem.isNumeric(from) && SqlTypeName.APPROX_TYPES.contains((Object)to.getSqlTypeName())) {
            literal = (RexLiteral)operand;
            BigDecimal value = literal.getValueAs(BigDecimal.class);
            if (to.getSqlTypeName() == SqlTypeName.DOUBLE) {
                value = new BigDecimal(BigDecimalConverter.INSTANCE.asDouble(value), ExpressionMath.DECIMAL_MATH_CONTEXT);
            } else {
                assert (to.getSqlTypeName() == SqlTypeName.REAL);
                value = new BigDecimal(BigDecimalConverter.INSTANCE.asReal(value), ExpressionMath.DECIMAL_MATH_CONTEXT);
            }
            return this.getRexBuilder().makeLiteral((Object)value, to, false);
        }
        return this.getRexBuilder().makeCast(to, operand);
    }

    private RexNode convertLiteral(SqlLiteral literal) {
        if (literal.getValue() == null) {
            return null;
        }
        RelDataType type = this.validator.getValidatedNodeType(literal);
        SqlTypeName literalTypeName = literal.getTypeName();
        Object value = SqlTypeName.CHAR_TYPES.contains((Object)literalTypeName) ? (HazelcastTypeSystem.isNumeric(type) ? StringConverter.INSTANCE.asDecimal(literal.getValueAs(String.class)) : (SqlTypeName.BOOLEAN_TYPES.contains((Object)type.getSqlTypeName()) ? Boolean.valueOf(StringConverter.INSTANCE.asBoolean(literal.getValueAs(String.class))) : literal.getValue())) : (SqlTypeName.INTERVAL_TYPES.contains((Object)literalTypeName) ? literal.getValueAs(BigDecimal.class) : literal.getValue());
        if (type.getSqlTypeName() == SqlTypeName.DOUBLE) {
            value = new BigDecimal(BigDecimalConverter.INSTANCE.asDouble(value), ExpressionMath.DECIMAL_MATH_CONTEXT);
        } else if (type.getSqlTypeName() == SqlTypeName.REAL) {
            value = new BigDecimal(BigDecimalConverter.INSTANCE.asReal(value), ExpressionMath.DECIMAL_MATH_CONTEXT);
        }
        boolean allowCast = type.getSqlTypeName() == SqlTypeName.VARCHAR;
        return this.getRexBuilder().makeLiteral(value, type, allowCast);
    }
}

