/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.calcite.validate.types;

import com.hazelcast.org.apache.calcite.rel.type.RelDataTypeComparability;
import com.hazelcast.org.apache.calcite.sql.SqlCallBinding;
import com.hazelcast.org.apache.calcite.sql.SqlNode;
import com.hazelcast.org.apache.calcite.sql.SqlOperandCountRange;
import com.hazelcast.org.apache.calcite.sql.SqlOperator;
import com.hazelcast.org.apache.calcite.sql.type.ComparableOperandTypeChecker;
import com.hazelcast.org.apache.calcite.sql.type.SqlOperandTypeChecker;
import com.hazelcast.org.apache.calcite.sql.type.SqlSingleOperandTypeChecker;
import com.hazelcast.org.apache.calcite.sql.type.SqlTypeName;
import com.hazelcast.sql.impl.calcite.validate.types.HazelcastTypeSystem;

public final class HazelcastOperandTypes {
    public static final SqlOperandTypeChecker COMPARABLE_ORDERED_COMPARABLE_ORDERED = new ComparableOperandTypeChecker(2, RelDataTypeComparability.ALL, SqlOperandTypeChecker.Consistency.LEAST_RESTRICTIVE);

    private HazelcastOperandTypes() {
    }

    public static SqlSingleOperandTypeChecker notAny(SqlOperandTypeChecker base) {
        return new NotAny(base);
    }

    public static SqlOperandTypeChecker notAllNull(SqlOperandTypeChecker base) {
        return new NotAllNull(base);
    }

    private static final class NotAllNull
    implements SqlOperandTypeChecker {
        private final SqlOperandTypeChecker base;

        NotAllNull(SqlOperandTypeChecker base) {
            this.base = base;
        }

        @Override
        public boolean checkOperandTypes(SqlCallBinding binding, boolean throwOnFailure) {
            boolean seenNonNull = false;
            for (int i = 0; i < binding.getOperandCount(); ++i) {
                if (HazelcastTypeSystem.typeName(binding.getOperandType(i)) == SqlTypeName.NULL) continue;
                seenNonNull = true;
                break;
            }
            if (!seenNonNull) {
                if (throwOnFailure) {
                    throw binding.newValidationSignatureError();
                }
                return false;
            }
            return this.base.checkOperandTypes(binding, throwOnFailure);
        }

        @Override
        public SqlOperandCountRange getOperandCountRange() {
            return this.base.getOperandCountRange();
        }

        @Override
        public String getAllowedSignatures(SqlOperator op, String opName) {
            return this.base.getAllowedSignatures(op, opName);
        }

        @Override
        public SqlOperandTypeChecker.Consistency getConsistency() {
            return this.base.getConsistency();
        }

        @Override
        public boolean isOptional(int i) {
            return this.base.isOptional(i);
        }
    }

    private static final class NotAny
    implements SqlSingleOperandTypeChecker {
        private final SqlOperandTypeChecker base;

        NotAny(SqlOperandTypeChecker base) {
            this.base = base;
        }

        @Override
        public boolean checkOperandTypes(SqlCallBinding binding, boolean throwOnFailure) {
            if (!this.base.checkOperandTypes(binding, throwOnFailure)) {
                return false;
            }
            for (int i = 0; i < binding.getOperandCount(); ++i) {
                if (this.checkSingleOperandType(binding, binding.operand(i), i, throwOnFailure)) continue;
                return false;
            }
            return true;
        }

        @Override
        public SqlOperandCountRange getOperandCountRange() {
            return this.base.getOperandCountRange();
        }

        @Override
        public String getAllowedSignatures(SqlOperator op, String opName) {
            return this.base.getAllowedSignatures(op, opName);
        }

        @Override
        public SqlOperandTypeChecker.Consistency getConsistency() {
            return this.base.getConsistency();
        }

        @Override
        public boolean isOptional(int i) {
            return this.base.isOptional(i);
        }

        @Override
        public boolean checkSingleOperandType(SqlCallBinding binding, SqlNode operand, int index, boolean throwOnFailure) {
            if (HazelcastTypeSystem.typeName(binding.getOperandType(index)) == SqlTypeName.ANY) {
                if (throwOnFailure) {
                    throw binding.newValidationSignatureError();
                }
                return false;
            }
            return true;
        }
    }
}

