/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client;

import com.hazelcast.client.connection.nio.ClientConnectionManagerImpl;
import com.hazelcast.client.impl.clientside.HazelcastClientInstanceImpl;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.instance.DefaultOutOfMemoryHandler;
import com.hazelcast.util.EmptyStatement;

public class ClientOutOfMemoryHandler
extends DefaultOutOfMemoryHandler {
    public void onOutOfMemory(OutOfMemoryError oome, HazelcastInstance[] hazelcastInstances) {
        for (HazelcastInstance instance : hazelcastInstances) {
            if (!(instance instanceof HazelcastClientInstanceImpl)) continue;
            ClientHelper.cleanResources((HazelcastClientInstanceImpl)instance);
        }
        try {
            oome.printStackTrace(System.err);
        }
        catch (Throwable ignored) {
            EmptyStatement.ignore((Throwable)ignored);
        }
    }

    private static final class ClientHelper {
        private ClientHelper() {
        }

        static void cleanResources(HazelcastClientInstanceImpl client) {
            ClientHelper.closeSockets(client);
            ClientHelper.tryShutdown(client);
        }

        private static void closeSockets(HazelcastClientInstanceImpl client) {
            ClientConnectionManagerImpl connectionManager = (ClientConnectionManagerImpl)client.getConnectionManager();
            if (connectionManager != null) {
                try {
                    connectionManager.shutdown();
                }
                catch (Throwable ignored) {
                    EmptyStatement.ignore((Throwable)ignored);
                }
            }
        }

        private static void tryShutdown(HazelcastClientInstanceImpl client) {
            try {
                client.doShutdown();
            }
            catch (Throwable ignored) {
                EmptyStatement.ignore((Throwable)ignored);
            }
        }
    }
}

