/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.util;

import com.hazelcast.client.impl.ClientMessageDecoder;
import com.hazelcast.client.impl.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.ExecutorServiceCancelOnPartitionCodec;
import com.hazelcast.client.spi.ClientContext;
import com.hazelcast.client.spi.impl.ClientInvocation;
import com.hazelcast.client.spi.impl.ClientInvocationFuture;
import com.hazelcast.client.util.ClientCancellableDelegatingFuture;
import com.hazelcast.util.ExceptionUtil;
import java.util.concurrent.CancellationException;

public class ClientPartitionCancellableDelegatingFuture<T>
extends ClientCancellableDelegatingFuture<T> {
    private final int partitionId;

    public ClientPartitionCancellableDelegatingFuture(ClientInvocationFuture future, ClientContext context, String uuid, int partitionId, T defaultValue, ClientMessageDecoder resultDecoder) {
        super(future, context, uuid, defaultValue, resultDecoder);
        this.partitionId = partitionId;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        if (this.isDone() || this.cancelled) {
            return false;
        }
        boolean cancelSuccessful = false;
        try {
            cancelSuccessful = this.invokeCancelRequest(mayInterruptIfRunning);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        try {
            if (cancelSuccessful) {
                this.setError(new CancellationException());
                this.cancelled = true;
                boolean e = true;
                return e;
            }
            boolean e = false;
            return e;
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow((Throwable)e);
        }
        finally {
            this.setDone();
        }
    }

    private boolean invokeCancelRequest(boolean mayInterruptIfRunning) throws InterruptedException {
        this.waitForRequestToBeSend();
        HazelcastClientInstanceImpl client = (HazelcastClientInstanceImpl)this.context.getHazelcastInstance();
        ClientMessage request = ExecutorServiceCancelOnPartitionCodec.encodeRequest((String)this.uuid, (int)this.partitionId, (boolean)mayInterruptIfRunning);
        ClientInvocation clientInvocation = new ClientInvocation(client, request, this.partitionId);
        try {
            ClientInvocationFuture f = clientInvocation.invoke();
            return ExecutorServiceCancelOnPartitionCodec.decodeResponse((ClientMessage)((ClientMessage)f.get())).response;
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow((Throwable)e);
        }
    }
}

