/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.spi;

import com.hazelcast.client.cache.impl.nearcache.invalidation.ClientCacheMetaDataFetcher;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.impl.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.querycache.ClientQueryCacheContext;
import com.hazelcast.client.map.impl.nearcache.invalidation.ClientMapMetaDataFetcher;
import com.hazelcast.client.spi.ClientClusterService;
import com.hazelcast.client.spi.ClientExecutionService;
import com.hazelcast.client.spi.ClientInvocationService;
import com.hazelcast.client.spi.ClientListenerService;
import com.hazelcast.client.spi.ClientPartitionService;
import com.hazelcast.client.spi.ClientProxy;
import com.hazelcast.client.spi.ClientTransactionManagerService;
import com.hazelcast.client.spi.ProxyManager;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.internal.nearcache.NearCacheManager;
import com.hazelcast.internal.nearcache.impl.invalidation.MetaDataFetcher;
import com.hazelcast.internal.nearcache.impl.invalidation.MinimalPartitionService;
import com.hazelcast.internal.nearcache.impl.invalidation.RepairingTask;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.LoggingService;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.TaskScheduler;
import com.hazelcast.spi.properties.HazelcastProperties;
import com.hazelcast.spi.serialization.SerializationService;
import com.hazelcast.util.ConcurrencyUtil;
import com.hazelcast.util.ConstructorFunction;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public final class ClientContext {
    private final String localUuid;
    private final SerializationService serializationService;
    private final ClientClusterService clusterService;
    private final ClientPartitionService partitionService;
    private final ClientInvocationService invocationService;
    private final ClientExecutionService executionService;
    private final ClientListenerService listenerService;
    private final ClientTransactionManagerService transactionManager;
    private final ProxyManager proxyManager;
    private final ClientConfig clientConfig;
    private final LoggingService loggingService;
    private final HazelcastProperties properties;
    private final NearCacheManager nearCacheManager;
    private final MinimalPartitionService minimalPartitionService;
    private final ClientQueryCacheContext queryCacheContext;
    private final ConcurrentMap<String, RepairingTask> repairingTasks = new ConcurrentHashMap<String, RepairingTask>();
    private final ConstructorFunction<String, RepairingTask> repairingTaskConstructor = new ConstructorFunction<String, RepairingTask>(){

        public RepairingTask createNew(String serviceName) {
            return ClientContext.this.newRepairingTask(serviceName);
        }
    };

    ClientContext(HazelcastClientInstanceImpl client, ProxyManager proxyManager) {
        this.serializationService = client.getSerializationService();
        this.clusterService = client.getClientClusterService();
        this.partitionService = client.getClientPartitionService();
        this.invocationService = client.getInvocationService();
        this.executionService = client.getClientExecutionService();
        this.listenerService = client.getListenerService();
        this.proxyManager = proxyManager;
        this.clientConfig = client.getClientConfig();
        this.transactionManager = client.getTransactionManager();
        this.loggingService = client.getLoggingService();
        this.nearCacheManager = client.getNearCacheManager();
        this.properties = client.getProperties();
        this.localUuid = client.getLocalEndpoint().getUuid();
        this.minimalPartitionService = new ClientMinimalPartitionService();
        this.queryCacheContext = new ClientQueryCacheContext(this);
    }

    public ClientQueryCacheContext getQueryCacheContext() {
        return this.queryCacheContext;
    }

    public RepairingTask getRepairingTask(String serviceName) {
        return (RepairingTask)ConcurrencyUtil.getOrPutIfAbsent(this.repairingTasks, (Object)serviceName, this.repairingTaskConstructor);
    }

    private RepairingTask newRepairingTask(String serviceName) {
        MetaDataFetcher metaDataFetcher = this.newMetaDataFetcher(serviceName);
        ILogger logger = this.loggingService.getLogger(RepairingTask.class);
        return new RepairingTask(metaDataFetcher, (TaskScheduler)this.executionService, this.minimalPartitionService, this.properties, this.localUuid, logger);
    }

    private MetaDataFetcher newMetaDataFetcher(String serviceName) {
        if ("hz:impl:mapService".equals(serviceName)) {
            return new ClientMapMetaDataFetcher(this);
        }
        if ("hz:impl:cacheService".equals(serviceName)) {
            return new ClientCacheMetaDataFetcher(this);
        }
        throw new IllegalArgumentException(String.format("%s is not a known service-name to fetch metadata for", serviceName));
    }

    public HazelcastInstance getHazelcastInstance() {
        return this.proxyManager.getHazelcastInstance();
    }

    public SerializationService getSerializationService() {
        return this.serializationService;
    }

    public ClientClusterService getClusterService() {
        return this.clusterService;
    }

    public ClientPartitionService getPartitionService() {
        return this.partitionService;
    }

    public ClientTransactionManagerService getTransactionManager() {
        return this.transactionManager;
    }

    public ClientExecutionService getExecutionService() {
        return this.executionService;
    }

    public ClientListenerService getListenerService() {
        return this.listenerService;
    }

    public NearCacheManager getNearCacheManager() {
        return this.nearCacheManager;
    }

    public LoggingService getLoggingService() {
        return this.loggingService;
    }

    public ClientInvocationService getInvocationService() {
        return this.invocationService;
    }

    public void removeProxy(ClientProxy proxy) {
        this.proxyManager.removeProxy(proxy.getServiceName(), proxy.getDistributedObjectName());
    }

    public ClientConfig getClientConfig() {
        return this.clientConfig;
    }

    public boolean isActive() {
        return this.getHazelcastInstance().getLifecycleService().isRunning();
    }

    private class ClientMinimalPartitionService
    implements MinimalPartitionService {
        private ClientMinimalPartitionService() {
        }

        public int getPartitionId(Data key) {
            return ClientContext.this.partitionService.getPartitionId(key);
        }

        public int getPartitionId(Object key) {
            return ClientContext.this.partitionService.getPartitionId(key);
        }

        public int getPartitionCount() {
            return ClientContext.this.partitionService.getPartitionCount();
        }
    }
}

