/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.gcp;

import com.hazelcast.gcp.GcpAddress;
import com.hazelcast.gcp.Label;
import com.hazelcast.gcp.RestClient;
import com.hazelcast.gcp.Utils;
import com.hazelcast.internal.json.Json;
import com.hazelcast.internal.json.JsonArray;
import com.hazelcast.internal.json.JsonValue;
import java.util.ArrayList;
import java.util.List;

class GcpComputeApi {
    private static final String GOOGLE_API_ENDPOINT = "https://www.googleapis.com";
    private final String endpoint;

    GcpComputeApi() {
        this.endpoint = GOOGLE_API_ENDPOINT;
    }

    GcpComputeApi(String endpoint) {
        this.endpoint = endpoint;
    }

    List<GcpAddress> instances(String project, String zone, Label label, String accessToken) {
        String response = RestClient.create(this.urlFor(project, zone, label)).withHeader("Authorization", String.format("OAuth %s", accessToken)).get();
        ArrayList<GcpAddress> result = new ArrayList<GcpAddress>();
        for (JsonValue item : GcpComputeApi.toJsonArray(Json.parse((String)response).asObject().get("items"))) {
            if (!"RUNNING".equals(item.asObject().get("status").asString())) continue;
            String privateAddress = null;
            String publicAddress = null;
            for (JsonValue networkInterface : GcpComputeApi.toJsonArray(item.asObject().get("networkInterfaces"))) {
                privateAddress = networkInterface.asObject().getString("networkIP", null);
                for (JsonValue accessConfig : GcpComputeApi.toJsonArray(networkInterface.asObject().get("accessConfigs"))) {
                    publicAddress = accessConfig.asObject().getString("natIP", null);
                }
            }
            if (privateAddress == null) continue;
            result.add(new GcpAddress(privateAddress, publicAddress));
        }
        return result;
    }

    List<String> zones(String project, String region, String accessToken) {
        String url = String.format("%s/compute/v1/projects/%s/regions/%s?alt=json&fields=zones", this.endpoint, project, region);
        String response = RestClient.create(url).withHeader("Authorization", String.format("OAuth %s", accessToken)).get();
        JsonArray zoneUrls = GcpComputeApi.toJsonArray(Json.parse((String)response).asObject().get("zones"));
        ArrayList<String> zones = new ArrayList<String>();
        for (JsonValue value : zoneUrls) {
            zones.add(Utils.lastPartOf(value.asString(), "/"));
        }
        return zones;
    }

    private String urlFor(String project, String zone, Label label) {
        String url = String.format("%s/compute/v1/projects/%s/zones/%s/instances", this.endpoint, project, zone);
        if (label != null) {
            url = String.format("%s?filter=labels.%s+eq+%s", url, label.getKey(), label.getValue());
        }
        return url;
    }

    private static JsonArray toJsonArray(JsonValue jsonValue) {
        if (jsonValue == null || jsonValue.isNull()) {
            return new JsonArray();
        }
        return jsonValue.asArray();
    }
}

