/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spring.cache;

import com.hazelcast.core.DistributedObject;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.internal.util.StringUtil;
import com.hazelcast.map.IMap;
import com.hazelcast.spring.cache.HazelcastCache;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;
import org.springframework.util.Assert;

public class HazelcastCacheManager
implements CacheManager {
    public static final String CACHE_PROP = "hazelcast.spring.cache.prop";
    private final ConcurrentMap<String, Cache> caches = new ConcurrentHashMap<String, Cache>();
    private HazelcastInstance hazelcastInstance;
    private long defaultReadTimeout;
    private final Map<String, Long> readTimeoutMap = new HashMap<String, Long>();

    public HazelcastCacheManager() {
    }

    public HazelcastCacheManager(HazelcastInstance hazelcastInstance) {
        this.hazelcastInstance = hazelcastInstance;
    }

    public Cache getCache(String name) {
        Cache cache = (Cache)this.caches.get(name);
        if (cache == null) {
            IMap map = this.hazelcastInstance.getMap(name);
            cache = new HazelcastCache((IMap<Object, Object>)map);
            long cacheTimeout = this.calculateCacheReadTimeout(name);
            ((HazelcastCache)cache).setReadTimeout(cacheTimeout);
            Cache currentCache = this.caches.putIfAbsent(name, cache);
            if (currentCache != null) {
                cache = currentCache;
            }
        }
        return cache;
    }

    public Collection<String> getCacheNames() {
        HashSet<String> cacheNames = new HashSet<String>();
        Collection distributedObjects = this.hazelcastInstance.getDistributedObjects();
        for (DistributedObject distributedObject : distributedObjects) {
            if (!(distributedObject instanceof IMap)) continue;
            IMap map = (IMap)distributedObject;
            cacheNames.add(map.getName());
        }
        return cacheNames;
    }

    private long calculateCacheReadTimeout(String name) {
        Long timeout = this.getReadTimeoutMap().get(name);
        return timeout == null ? this.defaultReadTimeout : timeout;
    }

    public HazelcastInstance getHazelcastInstance() {
        return this.hazelcastInstance;
    }

    public void setHazelcastInstance(HazelcastInstance hazelcastInstance) {
        this.hazelcastInstance = hazelcastInstance;
    }

    private void parseOptions(String options) {
        if (StringUtil.isNullOrEmptyAfterTrim((String)options)) {
            return;
        }
        for (String option : options.split(",")) {
            this.parseOption(option);
        }
    }

    private void parseOption(String option) {
        String[] keyValue = option.split("=");
        Assert.isTrue((keyValue.length != 0 ? 1 : 0) != 0, (String)"blank key-value pair");
        Assert.isTrue((keyValue.length <= 2 ? 1 : 0) != 0, (String)String.format("key-value pair %s with more than one equals sign", option));
        String key = keyValue[0].trim();
        String value = keyValue.length == 1 ? null : keyValue[1].trim();
        Assert.isTrue((value != null && !value.isEmpty() ? 1 : 0) != 0, (String)String.format("value for %s must not be null or empty", key));
        if ("defaultReadTimeout".equals(key)) {
            this.defaultReadTimeout = Long.parseLong(value);
        } else {
            this.readTimeoutMap.put(key, Long.parseLong(value));
        }
    }

    public long getDefaultReadTimeout() {
        return this.defaultReadTimeout;
    }

    public void setDefaultReadTimeout(long defaultReadTimeout) {
        this.defaultReadTimeout = defaultReadTimeout;
    }

    public Map<String, Long> getReadTimeoutMap() {
        return this.readTimeoutMap;
    }

    @Autowired
    public void setCacheOptions(@Value(value="${hazelcast.spring.cache.prop:}") String options) {
        this.parseOptions(options);
    }
}

