/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cache.impl.operation;

import com.hazelcast.cache.CacheEntryView;
import com.hazelcast.cache.impl.CacheDataSerializerHook;
import com.hazelcast.cache.impl.CacheEntryViews;
import com.hazelcast.cache.impl.ICacheRecordStore;
import com.hazelcast.cache.impl.ICacheService;
import com.hazelcast.cache.impl.event.CacheWanEventPublisher;
import com.hazelcast.cache.impl.operation.CachePutAllBackupOperation;
import com.hazelcast.cache.impl.record.CacheRecord;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.BackupAwareOperation;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.ServiceNamespace;
import com.hazelcast.spi.ServiceNamespaceAware;
import com.hazelcast.spi.impl.AbstractNamedOperation;
import com.hazelcast.spi.merge.SplitBrainMergePolicy;
import com.hazelcast.spi.merge.SplitBrainMergeTypes;
import com.hazelcast.spi.serialization.SerializationService;
import com.hazelcast.util.MapUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class CacheMergeOperation
extends AbstractNamedOperation
implements BackupAwareOperation,
ServiceNamespaceAware {
    private List<SplitBrainMergeTypes.CacheMergeTypes> mergingEntries;
    private SplitBrainMergePolicy<Data, SplitBrainMergeTypes.CacheMergeTypes> mergePolicy;
    private transient SerializationService serializationService;
    private transient ICacheRecordStore cache;
    private transient CacheWanEventPublisher wanEventPublisher;
    private transient boolean hasBackups;
    private transient Map<Data, CacheRecord> backupRecords;

    public CacheMergeOperation() {
    }

    public CacheMergeOperation(String name, List<SplitBrainMergeTypes.CacheMergeTypes> mergingEntries, SplitBrainMergePolicy<Data, SplitBrainMergeTypes.CacheMergeTypes> mergePolicy) {
        super(name);
        this.mergingEntries = mergingEntries;
        this.mergePolicy = mergePolicy;
    }

    @Override
    public void beforeRun() throws Exception {
        this.serializationService = this.getNodeEngine().getSerializationService();
        ICacheService cacheService = (ICacheService)this.getService();
        this.cache = cacheService.getOrCreateRecordStore(this.name, this.getPartitionId());
        if (this.cache.isWanReplicationEnabled()) {
            this.wanEventPublisher = cacheService.getCacheWanEventPublisher();
        }
        boolean bl = this.hasBackups = this.getSyncBackupCount() + this.getAsyncBackupCount() > 0;
        if (this.hasBackups) {
            this.backupRecords = MapUtil.createHashMap(this.mergingEntries.size());
        }
    }

    @Override
    public void run() {
        for (SplitBrainMergeTypes.CacheMergeTypes mergingEntry : this.mergingEntries) {
            this.merge(mergingEntry);
        }
    }

    private void merge(SplitBrainMergeTypes.CacheMergeTypes mergingEntry) {
        Data dataKey = (Data)mergingEntry.getKey();
        CacheRecord backupRecord = this.cache.merge(mergingEntry, this.mergePolicy);
        if (backupRecord != null) {
            this.backupRecords.put(dataKey, backupRecord);
        }
        if (this.cache.isWanReplicationEnabled()) {
            if (backupRecord != null) {
                CacheEntryView<Data, Data> entryView = CacheEntryViews.createDefaultEntryView(dataKey, this.serializationService.toData(backupRecord.getValue()), backupRecord);
                this.wanEventPublisher.publishWanReplicationUpdate(this.name, entryView);
            } else {
                this.wanEventPublisher.publishWanReplicationRemove(this.name, dataKey);
            }
        }
    }

    @Override
    public Object getResponse() {
        return !this.backupRecords.isEmpty();
    }

    @Override
    public boolean shouldBackup() {
        return this.hasBackups && !this.backupRecords.isEmpty();
    }

    @Override
    public int getSyncBackupCount() {
        return this.cache != null ? this.cache.getConfig().getBackupCount() : 0;
    }

    @Override
    public int getAsyncBackupCount() {
        return this.cache != null ? this.cache.getConfig().getAsyncBackupCount() : 0;
    }

    @Override
    public Operation getBackupOperation() {
        return new CachePutAllBackupOperation(this.name, this.backupRecords);
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeInt(this.mergingEntries.size());
        for (SplitBrainMergeTypes.CacheMergeTypes mergingEntry : this.mergingEntries) {
            out.writeObject(mergingEntry);
        }
        out.writeObject(this.mergePolicy);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        int size = in.readInt();
        this.mergingEntries = new ArrayList<SplitBrainMergeTypes.CacheMergeTypes>(size);
        for (int i = 0; i < size; ++i) {
            SplitBrainMergeTypes.CacheMergeTypes mergingEntry = (SplitBrainMergeTypes.CacheMergeTypes)in.readObject();
            this.mergingEntries.add(mergingEntry);
        }
        this.mergePolicy = (SplitBrainMergePolicy)in.readObject();
    }

    @Override
    public int getFactoryId() {
        return CacheDataSerializerHook.F_ID;
    }

    @Override
    public int getId() {
        return 65;
    }

    @Override
    public ServiceNamespace getServiceNamespace() {
        ICacheRecordStore recordStore = this.cache;
        if (recordStore == null) {
            ICacheService service = (ICacheService)this.getService();
            recordStore = service.getOrCreateRecordStore(this.name, this.getPartitionId());
        }
        return recordStore.getObjectNamespace();
    }
}

