/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.datamodel;

import com.hazelcast.jet.impl.util.Util;
import java.util.Map;
import javax.annotation.Nonnull;

public final class TimestampedEntry<K, V>
implements Map.Entry<K, V> {
    private final long timestamp;
    @Nonnull
    private final K key;
    @Nonnull
    private final V value;

    public TimestampedEntry(long timestamp, @Nonnull K key, @Nonnull V value) {
        this.timestamp = timestamp;
        this.key = key;
        this.value = value;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    @Override
    @Nonnull
    public K getKey() {
        return this.key;
    }

    @Override
    @Nonnull
    public V getValue() {
        return this.value;
    }

    @Override
    public V setValue(V value) {
        throw new UnsupportedOperationException("");
    }

    @Override
    public int hashCode() {
        int hc = 17;
        hc = 73 * hc + Long.hashCode(this.timestamp);
        hc = 73 * hc + this.key.hashCode();
        hc = 73 * hc + this.value.hashCode();
        return hc;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (!(obj instanceof TimestampedEntry)) return false;
        TimestampedEntry that = (TimestampedEntry)obj;
        if (this.timestamp != that.timestamp) return false;
        if (!this.key.equals(that.key)) return false;
        if (!this.value.equals(that.value)) return false;
        return true;
    }

    public String toString() {
        return String.format("{ts=%s, key='%s', value='%s'}", Util.toLocalTime(this.timestamp), this.key, this.value);
    }

    public static <K, V> TimestampedEntry<K, V> fromWindowResult(long winStart, long winEnd, @Nonnull K key, @Nonnull V value) {
        return new TimestampedEntry<K, V>(winEnd, key, value);
    }
}

