/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.operation;

import com.hazelcast.jet.impl.JetService;
import com.hazelcast.jet.impl.execution.ExecutionContext;
import com.hazelcast.jet.impl.execution.init.JetInitDataSerializerHook;
import com.hazelcast.jet.impl.operation.AsyncJobOperation;
import com.hazelcast.jet.impl.util.ExceptionUtil;
import com.hazelcast.jet.impl.util.LoggingUtil;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

public class SnapshotOperation
extends AsyncJobOperation {
    public static volatile boolean postponeResponses;
    private static final int RETRY_MS = 100;
    private long executionId;
    private long snapshotId;
    private boolean isTerminal;

    public SnapshotOperation() {
    }

    public SnapshotOperation(long jobId, long executionId, long snapshotId, boolean isTerminal) {
        super(jobId);
        this.executionId = executionId;
        this.snapshotId = snapshotId;
        this.isTerminal = isTerminal;
    }

    @Override
    protected void doRun() {
        JetService service = (JetService)this.getService();
        ExecutionContext ctx = service.getJobExecutionService().assertExecutionContext(this.getCallerAddress(), this.jobId(), this.executionId, this.getClass().getSimpleName());
        ctx.beginSnapshot(this.snapshotId, this.isTerminal).whenComplete(ExceptionUtil.withTryCatch(this.getLogger(), (result, exc) -> {
            if (exc != null) {
                result = new SnapshotOperationResult(0L, 0L, 0L, (Throwable)exc);
            }
            if (result.getError() == null) {
                LoggingUtil.logFine(this.getLogger(), "Snapshot %s for %s finished successfully on member", this.snapshotId, ctx.jobNameAndExecutionId());
            } else {
                this.getLogger().warning(String.format("Snapshot %d for %s finished with an error on member: %s", this.snapshotId, ctx.jobNameAndExecutionId(), result.getError()));
            }
            this.maybeSendResponse((SnapshotOperationResult)result);
        }));
    }

    private void maybeSendResponse(SnapshotOperationResult result) {
        if (postponeResponses) {
            this.getNodeEngine().getExecutionService().schedule(() -> this.maybeSendResponse(result), 100L, TimeUnit.MILLISECONDS);
            return;
        }
        this.doSendResponse(result);
    }

    @Override
    public int getId() {
        return 10;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeLong(this.executionId);
        out.writeLong(this.snapshotId);
        out.writeBoolean(this.isTerminal);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.executionId = in.readLong();
        this.snapshotId = in.readLong();
        this.isTerminal = in.readBoolean();
    }

    public static final class SnapshotOperationResult
    implements IdentifiedDataSerializable {
        private long numBytes;
        private long numKeys;
        private long numChunks;
        private String error;

        public SnapshotOperationResult() {
        }

        public SnapshotOperationResult(long numBytes, long numKeys, long numChunks, Throwable error) {
            this.numBytes = numBytes;
            this.numKeys = numKeys;
            this.numChunks = numChunks;
            this.error = error == null ? null : Objects.requireNonNull(error.toString());
        }

        public long getNumBytes() {
            return this.numBytes;
        }

        public long getNumKeys() {
            return this.numKeys;
        }

        public long getNumChunks() {
            return this.numChunks;
        }

        public String getError() {
            return this.error;
        }

        public void merge(SnapshotOperationResult other) {
            this.numBytes += other.numBytes;
            this.numKeys += other.numKeys;
            this.numChunks += other.numChunks;
            if (this.error == null) {
                this.error = other.error;
            }
        }

        public String toString() {
            return "SnapshotOperationResult{numBytes=" + this.numBytes + ", numKeys=" + this.numKeys + ", numChunks=" + this.numChunks + ", error=" + this.error + '}';
        }

        @Override
        public int getFactoryId() {
            return JetInitDataSerializerHook.FACTORY_ID;
        }

        @Override
        public int getId() {
            return 29;
        }

        @Override
        public void writeData(ObjectDataOutput out) throws IOException {
            out.writeLong(this.numBytes);
            out.writeLong(this.numKeys);
            out.writeLong(this.numChunks);
            out.writeUTF(this.error);
        }

        @Override
        public void readData(ObjectDataInput in) throws IOException {
            this.numBytes = in.readLong();
            this.numKeys = in.readLong();
            this.numChunks = in.readLong();
            this.error = in.readUTF();
        }
    }
}

