/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.pipeline;

import com.hazelcast.jet.Traverser;
import com.hazelcast.jet.aggregate.AggregateOperation1;
import com.hazelcast.jet.core.Inbox;
import com.hazelcast.jet.core.Processor;
import com.hazelcast.jet.core.ProcessorMetaSupplier;
import com.hazelcast.jet.function.DistributedBiFunction;
import com.hazelcast.jet.function.DistributedBiPredicate;
import com.hazelcast.jet.function.DistributedFunction;
import com.hazelcast.jet.function.DistributedPredicate;
import com.hazelcast.jet.function.DistributedTriFunction;
import com.hazelcast.jet.function.KeyedWindowResultFunction;
import com.hazelcast.jet.function.WindowResultFunction;
import com.hazelcast.jet.impl.JetEvent;
import com.hazelcast.jet.impl.processor.ProcessorWrapper;
import com.hazelcast.jet.impl.util.WrappingProcessorMetaSupplier;
import com.hazelcast.jet.pipeline.JoinClause;
import java.util.BitSet;
import javax.annotation.Nonnull;

public class FunctionAdapter {
    @Nonnull
    <T, K> DistributedFunction<?, ? extends K> adaptKeyFn(@Nonnull DistributedFunction<? super T, ? extends K> keyFn) {
        return keyFn;
    }

    @Nonnull
    <T, R> DistributedFunction<?, ?> adaptMapFn(@Nonnull DistributedFunction<? super T, ? extends R> mapFn) {
        return mapFn;
    }

    @Nonnull
    <T> DistributedPredicate<?> adaptFilterFn(@Nonnull DistributedPredicate<? super T> filterFn) {
        return filterFn;
    }

    @Nonnull
    <T, R> DistributedFunction<?, ? extends Traverser<?>> adaptFlatMapFn(@Nonnull DistributedFunction<? super T, ? extends Traverser<? extends R>> flatMapFn) {
        return flatMapFn;
    }

    @Nonnull
    <C, T, R> DistributedBiFunction<? super C, ?, ?> adaptMapUsingContextFn(@Nonnull DistributedBiFunction<? super C, ? super T, ? extends R> mapFn) {
        return mapFn;
    }

    @Nonnull
    <C, T> DistributedBiPredicate<? super C, ?> adaptFilterUsingContextFn(@Nonnull DistributedBiPredicate<? super C, ? super T> filterFn) {
        return filterFn;
    }

    @Nonnull
    <C, T, R> DistributedBiFunction<? super C, ?, ? extends Traverser<?>> adaptFlatMapUsingContextFn(@Nonnull DistributedBiFunction<? super C, ? super T, ? extends Traverser<? extends R>> flatMapFn) {
        return flatMapFn;
    }

    @Nonnull
    <T, R extends CharSequence> DistributedFunction<?, ? extends R> adaptToStringFn(@Nonnull DistributedFunction<? super T, ? extends R> toStringFn) {
        return toStringFn;
    }

    @Nonnull
    public <K, T0, T1, T1_OUT> JoinClause<? extends K, ?, ? super T1, ? extends T1_OUT> adaptJoinClause(@Nonnull JoinClause<? extends K, ? super T0, ? super T1, ? extends T1_OUT> joinClause) {
        return joinClause;
    }

    @Nonnull
    public <T, T1, R> DistributedBiFunction<?, ? super T1, ?> adaptHashJoinOutputFn(@Nonnull DistributedBiFunction<? super T, ? super T1, ? extends R> mapToOutputFn) {
        return mapToOutputFn;
    }

    @Nonnull
    <T, T1, T2, R> DistributedTriFunction<?, ? super T1, ? super T2, ?> adaptHashJoinOutputFn(@Nonnull DistributedTriFunction<? super T, ? super T1, ? super T2, ? extends R> mapToOutputFn) {
        return mapToOutputFn;
    }

    @Nonnull
    <R, OUT> WindowResultFunction<? super R, ?> adaptWindowResultFn(@Nonnull WindowResultFunction<? super R, ? extends OUT> windowResultFn) {
        return windowResultFn;
    }

    @Nonnull
    <K, R, OUT> KeyedWindowResultFunction<? super K, ? super R, ?> adaptKeyedWindowResultFn(@Nonnull KeyedWindowResultFunction<? super K, ? super R, ? extends OUT> keyedWindowResultFn) {
        return keyedWindowResultFn;
    }

    @Nonnull
    <T, A, R> AggregateOperation1<?, A, ? extends R> adaptAggregateOperation1(@Nonnull AggregateOperation1<? super T, A, ? extends R> aggrOp) {
        return aggrOp;
    }

    @Nonnull
    <T, K, R, OUT> DistributedTriFunction<?, ? super K, ? super R, ?> adaptRollingAggregateOutputFn(@Nonnull DistributedBiFunction<? super K, ? super R, ? extends OUT> mapToOutputFn) {
        return (t, k, r) -> mapToOutputFn.apply((Object)k, (Object)r);
    }

    @Nonnull
    public static ProcessorMetaSupplier adaptingMetaSupplier(ProcessorMetaSupplier metaSup, int[] ordinalsToAdapt) {
        return new WrappingProcessorMetaSupplier(metaSup, p -> new AdaptingProcessor((Processor)p, ordinalsToAdapt));
    }

    private static final class AdaptingInbox
    implements Inbox {
        private Inbox wrapped;

        private AdaptingInbox() {
        }

        void setWrappedInbox(@Nonnull Inbox wrapped) {
            this.wrapped = wrapped;
        }

        @Override
        public boolean isEmpty() {
            return this.wrapped.isEmpty();
        }

        @Override
        public Object peek() {
            return AdaptingInbox.unwrapPayload(this.wrapped.peek());
        }

        @Override
        public Object poll() {
            return AdaptingInbox.unwrapPayload(this.wrapped.poll());
        }

        @Override
        public void remove() {
            this.wrapped.remove();
        }

        private static Object unwrapPayload(Object jetEvent) {
            return jetEvent != null ? ((JetEvent)jetEvent).payload() : null;
        }
    }

    private static final class AdaptingProcessor
    extends ProcessorWrapper {
        private final AdaptingInbox adaptingInbox = new AdaptingInbox();
        private final BitSet shouldAdaptOrdinal = new BitSet();

        AdaptingProcessor(Processor wrapped, int[] ordinalsToAdapt) {
            super(wrapped);
            for (int ordinal : ordinalsToAdapt) {
                this.shouldAdaptOrdinal.set(ordinal);
            }
        }

        @Override
        public void process(int ordinal, @Nonnull Inbox inbox) {
            Inbox inboxToUse;
            if (this.shouldAdaptOrdinal.get(ordinal)) {
                inboxToUse = this.adaptingInbox;
                this.adaptingInbox.setWrappedInbox(inbox);
            } else {
                inboxToUse = inbox;
            }
            super.process(ordinal, inboxToUse);
        }
    }
}

