/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.pipeline;

import com.hazelcast.jet.Traverser;
import com.hazelcast.jet.function.DistributedFunction;
import com.hazelcast.jet.function.DistributedTriFunction;
import com.hazelcast.jet.function.DistributedTriPredicate;
import com.hazelcast.jet.impl.pipeline.ComputeStageImplBase;
import com.hazelcast.jet.impl.pipeline.transform.Transform;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.jet.pipeline.ContextFactory;
import com.hazelcast.jet.pipeline.GeneralStageWithKey;
import javax.annotation.Nonnull;

class StageWithGroupingBase<T, K> {
    final ComputeStageImplBase<T> computeStage;
    private final DistributedFunction<? super T, ? extends K> keyFn;

    StageWithGroupingBase(@Nonnull ComputeStageImplBase<T> computeStage, @Nonnull DistributedFunction<? super T, ? extends K> keyFn) {
        Util.checkSerializable(keyFn, "keyFn");
        this.computeStage = computeStage;
        this.keyFn = keyFn;
    }

    @Nonnull
    public DistributedFunction<? super T, ? extends K> keyFn() {
        return this.keyFn;
    }

    @Nonnull
    <C, R, RET> RET attachMapUsingContext(@Nonnull ContextFactory<C> contextFactory, @Nonnull DistributedTriFunction<? super C, ? super K, ? super T, ? extends R> mapFn) {
        DistributedFunction keyFn = this.keyFn();
        return this.computeStage.attachMapUsingPartitionedContext(contextFactory, keyFn, (c, t) -> {
            Object k = keyFn.apply(t);
            return mapFn.apply((Object)c, (Object)k, (Object)t);
        });
    }

    @Nonnull
    <C, RET> RET attachFilterUsingContext(@Nonnull ContextFactory<C> contextFactory, @Nonnull DistributedTriPredicate<? super C, ? super K, ? super T> filterFn) {
        DistributedFunction keyFn = this.keyFn();
        return this.computeStage.attachFilterUsingPartitionedContext(contextFactory, keyFn, (c, t) -> {
            Object k = keyFn.apply(t);
            return filterFn.test((Object)c, (Object)k, (Object)t);
        });
    }

    @Nonnull
    public <C, R, RET> RET attachFlatMapUsingContext(@Nonnull ContextFactory<C> contextFactory, @Nonnull DistributedTriFunction<? super C, ? super K, ? super T, ? extends Traverser<? extends R>> flatMapFn) {
        DistributedFunction keyFn = this.keyFn();
        return this.computeStage.attachFlatMapUsingPartitionedContext(contextFactory, keyFn, (c, t) -> {
            Object k = keyFn.apply(t);
            return (Traverser)flatMapFn.apply((Object)c, (Object)k, (Object)t);
        });
    }

    static Transform transformOf(GeneralStageWithKey stage) {
        return ((StageWithGroupingBase)((Object)stage)).computeStage.transform;
    }
}

