/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.pipeline;

import com.hazelcast.core.ReplicatedMap;
import com.hazelcast.jet.IMapJet;
import com.hazelcast.jet.pipeline.ContextFactory;
import javax.annotation.Nonnull;

public final class ContextFactories {
    private ContextFactories() {
    }

    @Nonnull
    public static <K, V> ContextFactory<ReplicatedMap<K, V>> replicatedMapContext(@Nonnull String mapName) {
        return ContextFactory.withCreateFn(jet -> jet.getHazelcastInstance().getReplicatedMap(mapName));
    }

    @Nonnull
    public static <K, V> ContextFactory<IMapJet<K, V>> iMapContext(@Nonnull String mapName) {
        return ContextFactory.withCreateFn(jet -> jet.getMap(mapName)).shareLocally().nonCooperative();
    }
}

