/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.pipeline;

import com.hazelcast.jet.JetInstance;
import com.hazelcast.jet.function.DistributedConsumer;
import com.hazelcast.jet.function.DistributedFunction;
import java.io.Serializable;
import javax.annotation.Nonnull;

public final class ContextFactory<C>
implements Serializable {
    private static final boolean COOPERATIVE_DEFAULT = true;
    private static final boolean SHARE_LOCALLY_DEFAULT = false;
    private final DistributedFunction<JetInstance, ? extends C> createFn;
    private final DistributedConsumer<? super C> destroyFn;
    private final boolean isCooperative;
    private final boolean isSharedLocally;

    private ContextFactory(DistributedFunction<JetInstance, ? extends C> createFn, DistributedConsumer<? super C> destroyFn, boolean isCooperative, boolean isSharedLocally) {
        this.createFn = createFn;
        this.destroyFn = destroyFn;
        this.isCooperative = isCooperative;
        this.isSharedLocally = isSharedLocally;
    }

    @Nonnull
    public static <C> ContextFactory<C> withCreateFn(@Nonnull DistributedFunction<JetInstance, ? extends C> createContextFn) {
        return new ContextFactory<C>(createContextFn, DistributedConsumer.noop(), true, false);
    }

    @Nonnull
    public ContextFactory<C> withDestroyFn(@Nonnull DistributedConsumer<? super C> destroyFn) {
        return new ContextFactory<C>(this.createFn, destroyFn, this.isCooperative, this.isSharedLocally);
    }

    @Nonnull
    public ContextFactory<C> nonCooperative() {
        return new ContextFactory<C>(this.createFn, this.destroyFn, false, this.isSharedLocally);
    }

    @Nonnull
    public ContextFactory<C> shareLocally() {
        return new ContextFactory<C>(this.createFn, this.destroyFn, this.isCooperative, true);
    }

    @Nonnull
    public DistributedFunction<JetInstance, ? extends C> createFn() {
        return this.createFn;
    }

    @Nonnull
    public DistributedConsumer<? super C> destroyFn() {
        return this.destroyFn;
    }

    public boolean isCooperative() {
        return this.isCooperative;
    }

    public boolean isSharedLocally() {
        return this.isSharedLocally;
    }
}

