/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.operation;

import com.hazelcast.core.IMapEvent;
import com.hazelcast.instance.BuildInfoProvider;
import com.hazelcast.instance.MemberImpl;
import com.hazelcast.internal.cluster.ClusterService;
import com.hazelcast.internal.cluster.Versions;
import com.hazelcast.map.MapInterceptor;
import com.hazelcast.map.impl.InterceptorRegistry;
import com.hazelcast.map.impl.ListenerAdapter;
import com.hazelcast.map.impl.MapContainer;
import com.hazelcast.map.impl.MapDataSerializerHook;
import com.hazelcast.map.impl.MapService;
import com.hazelcast.map.impl.MapServiceContext;
import com.hazelcast.map.impl.PartitionContainer;
import com.hazelcast.map.impl.querycache.QueryCacheContext;
import com.hazelcast.map.impl.querycache.accumulator.AccumulatorInfo;
import com.hazelcast.map.impl.querycache.accumulator.AccumulatorInfoSupplier;
import com.hazelcast.map.impl.querycache.publisher.MapPublisherRegistry;
import com.hazelcast.map.impl.querycache.publisher.PublisherContext;
import com.hazelcast.map.impl.querycache.publisher.PublisherRegistry;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.nio.serialization.impl.Versioned;
import com.hazelcast.query.impl.Index;
import com.hazelcast.query.impl.IndexInfo;
import com.hazelcast.query.impl.Indexes;
import com.hazelcast.query.impl.MapIndexInfo;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.impl.operationservice.TargetAware;
import com.hazelcast.util.MapUtil;
import com.hazelcast.version.Version;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class PostJoinMapOperation
extends Operation
implements IdentifiedDataSerializable,
Versioned,
TargetAware {
    private static final transient ThreadLocal<Address> TARGET = new ThreadLocal();
    private List<MapIndexInfo> indexInfoList = new LinkedList<MapIndexInfo>();
    private List<InterceptorInfo> interceptorInfoList = new LinkedList<InterceptorInfo>();
    private List<AccumulatorInfo> infoList;

    @Override
    public String getServiceName() {
        return "hz:impl:mapService";
    }

    public void addMapInterceptors(MapContainer mapContainer) {
        InterceptorRegistry interceptorRegistry = mapContainer.getInterceptorRegistry();
        List<MapInterceptor> interceptorList = interceptorRegistry.getInterceptors();
        Map<String, MapInterceptor> interceptorMap = interceptorRegistry.getId2InterceptorMap();
        Map<MapInterceptor, String> revMap = MapUtil.createHashMap(interceptorMap.size());
        for (Map.Entry<String, MapInterceptor> entry : interceptorMap.entrySet()) {
            revMap.put(entry.getValue(), entry.getKey());
        }
        InterceptorInfo interceptorInfo = new InterceptorInfo(mapContainer.getName());
        for (MapInterceptor interceptor : interceptorList) {
            interceptorInfo.addInterceptor((String)revMap.get(interceptor), interceptor);
        }
        this.interceptorInfoList.add(interceptorInfo);
    }

    @Override
    public void run() throws Exception {
        MapContainer mapContainer;
        MapService mapService = (MapService)this.getService();
        MapServiceContext mapServiceContext = mapService.getMapServiceContext();
        if (this.indexInfoList != null) {
            for (MapIndexInfo mapIndex : this.indexInfoList) {
                mapContainer = mapServiceContext.getMapContainer(mapIndex.getMapName());
                for (IndexInfo indexInfo : mapIndex.getIndexInfos()) {
                    if (mapContainer.isGlobalIndexEnabled()) {
                        Indexes indexes = mapContainer.getIndexes();
                        indexes.addOrGetIndex(indexInfo.getAttributeName(), indexInfo.isOrdered());
                        continue;
                    }
                    mapContainer.addPartitionIndexToAdd(indexInfo);
                }
            }
        }
        for (InterceptorInfo interceptorInfo : this.interceptorInfoList) {
            mapContainer = mapServiceContext.getMapContainer(interceptorInfo.mapName);
            InterceptorRegistry interceptorRegistry = mapContainer.getInterceptorRegistry();
            Map<String, MapInterceptor> interceptorMap = interceptorRegistry.getId2InterceptorMap();
            List entryList = interceptorInfo.interceptors;
            for (Map.Entry entry : entryList) {
                if (interceptorMap.containsKey(entry.getKey())) continue;
                interceptorRegistry.register((String)entry.getKey(), (MapInterceptor)entry.getValue());
            }
        }
        this.createQueryCaches();
    }

    private void createQueryCaches() {
        MapService mapService = (MapService)this.getService();
        MapServiceContext mapServiceContext = mapService.getMapServiceContext();
        QueryCacheContext queryCacheContext = mapServiceContext.getQueryCacheContext();
        PublisherContext publisherContext = queryCacheContext.getPublisherContext();
        MapPublisherRegistry mapPublisherRegistry = publisherContext.getMapPublisherRegistry();
        for (AccumulatorInfo info : this.infoList) {
            this.addAccumulatorInfo(queryCacheContext, info);
            PublisherRegistry publisherRegistry = mapPublisherRegistry.getOrCreate(info.getMapName());
            publisherRegistry.getOrCreate(info.getCacheId());
            mapServiceContext.addLocalListenerAdapter(new ListenerAdapter<IMapEvent>(){

                @Override
                public void onEvent(IMapEvent event) {
                }
            }, info.getMapName());
        }
    }

    private void addAccumulatorInfo(QueryCacheContext context, AccumulatorInfo info) {
        PublisherContext publisherContext = context.getPublisherContext();
        AccumulatorInfoSupplier infoSupplier = publisherContext.getAccumulatorInfoSupplier();
        infoSupplier.putIfAbsent(info.getMapName(), info.getCacheId(), info);
    }

    public void setInfoList(List<AccumulatorInfo> infoList) {
        this.infoList = infoList;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        if (this.mustWriteIndexInfos(out.getVersion())) {
            out.writeInt(this.indexInfoList.size());
            for (MapIndexInfo mapIndex : this.indexInfoList) {
                mapIndex.writeData(out);
            }
        }
        out.writeInt(this.interceptorInfoList.size());
        for (InterceptorInfo interceptorInfo : this.interceptorInfoList) {
            interceptorInfo.writeData(out);
        }
        int size = this.infoList.size();
        out.writeInt(size);
        for (AccumulatorInfo info : this.infoList) {
            out.writeObject(info);
        }
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        int i;
        super.readInternal(in);
        Version inputversion = in.getVersion();
        if (inputversion.isUnknownOrLessThan(Versions.V3_10) && BuildInfoProvider.getBuildInfo().isEnterprise()) {
            int indexesCount = in.readInt();
            for (i = 0; i < indexesCount; ++i) {
                MapIndexInfo mapIndexInfo = new MapIndexInfo();
                mapIndexInfo.readData(in);
                this.indexInfoList.add(mapIndexInfo);
            }
        }
        int interceptorsCount = in.readInt();
        for (i = 0; i < interceptorsCount; ++i) {
            InterceptorInfo info = new InterceptorInfo();
            info.readData(in);
            this.interceptorInfoList.add(info);
        }
        int accumulatorsCount = in.readInt();
        if (accumulatorsCount < 1) {
            this.infoList = Collections.emptyList();
            return;
        }
        this.infoList = new ArrayList<AccumulatorInfo>(accumulatorsCount);
        for (int i2 = 0; i2 < accumulatorsCount; ++i2) {
            AccumulatorInfo info = (AccumulatorInfo)in.readObject();
            this.infoList.add(info);
        }
    }

    @Override
    public int getFactoryId() {
        return MapDataSerializerHook.F_ID;
    }

    @Override
    public int getId() {
        return 97;
    }

    public void addMapIndex(MapServiceContext mapServiceContext, MapContainer mapContainer) {
        if (mapContainer.isGlobalIndexEnabled()) {
            MapIndexInfo mapIndexInfo = new MapIndexInfo(mapContainer.getName());
            for (Index index : mapContainer.getIndexes().getIndexes()) {
                mapIndexInfo.addIndexInfo(index.getAttributeName(), index.isOrdered());
            }
            this.indexInfoList.add(mapIndexInfo);
        } else {
            HashSet<IndexInfo> indexInfos = new HashSet<IndexInfo>();
            for (PartitionContainer partitionContainer : mapServiceContext.getPartitionContainers()) {
                Indexes indexes = mapContainer.getIndexes(partitionContainer.getPartitionId());
                if (indexes == null || !indexes.hasIndex()) continue;
                for (Index index : indexes.getIndexes()) {
                    indexInfos.add(new IndexInfo(index.getAttributeName(), index.isOrdered()));
                }
            }
            indexInfos.addAll(mapContainer.getPartitionIndexesToAdd());
            MapIndexInfo mapIndexInfo = new MapIndexInfo(mapContainer.getName());
            mapIndexInfo.addIndexInfos(indexInfos);
            this.indexInfoList.add(mapIndexInfo);
        }
    }

    @Override
    public void setTarget(Address address) {
        TARGET.set(address);
    }

    private boolean mustWriteIndexInfos(Version clusterVersion) {
        if (!BuildInfoProvider.getBuildInfo().isEnterprise() || clusterVersion.isGreaterOrEqual(Versions.V3_10)) {
            return false;
        }
        ClusterService clusterService = this.getNodeEngine().getClusterService();
        MemberImpl targetMember = clusterService.getMember(TARGET.get());
        return targetMember.getVersion().asVersion().isEqualTo(Versions.V3_10) && clusterVersion.isEqualTo(Versions.V3_9);
    }

    public static class InterceptorInfo
    implements IdentifiedDataSerializable {
        private String mapName;
        private final List<Map.Entry<String, MapInterceptor>> interceptors = new LinkedList<Map.Entry<String, MapInterceptor>>();

        InterceptorInfo(String mapName) {
            this.mapName = mapName;
        }

        public InterceptorInfo() {
        }

        void addInterceptor(String id, MapInterceptor interceptor) {
            this.interceptors.add(new AbstractMap.SimpleImmutableEntry<String, MapInterceptor>(id, interceptor));
        }

        @Override
        public void writeData(ObjectDataOutput out) throws IOException {
            out.writeUTF(this.mapName);
            out.writeInt(this.interceptors.size());
            for (Map.Entry<String, MapInterceptor> entry : this.interceptors) {
                out.writeUTF(entry.getKey());
                out.writeObject(entry.getValue());
            }
        }

        @Override
        public void readData(ObjectDataInput in) throws IOException {
            this.mapName = in.readUTF();
            int size = in.readInt();
            for (int i = 0; i < size; ++i) {
                String id = in.readUTF();
                MapInterceptor interceptor = (MapInterceptor)in.readObject();
                this.interceptors.add(new AbstractMap.SimpleImmutableEntry<String, MapInterceptor>(id, interceptor));
            }
        }

        @Override
        public int getFactoryId() {
            return MapDataSerializerHook.F_ID;
        }

        @Override
        public int getId() {
            return 100;
        }
    }
}

