/*
 * Decompiled with CFR 0.152.
 */
package com.helger.dao.wal;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.DevelopersNote;
import com.helger.commons.annotation.ELockType;
import com.helger.commons.annotation.IsLocked;
import com.helger.commons.annotation.MustBeLocked;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.callback.CallbackList;
import com.helger.commons.collection.CollectionHelper;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.CommonsHashMap;
import com.helger.commons.collection.impl.CommonsLinkedHashMap;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.collection.impl.ICommonsMap;
import com.helger.commons.collection.impl.ICommonsSet;
import com.helger.commons.functional.Predicates;
import com.helger.commons.id.IHasID;
import com.helger.commons.io.relative.IFileRelativeIO;
import com.helger.commons.lang.ClassHelper;
import com.helger.commons.state.EChange;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.commons.wrapper.Wrapper;
import com.helger.dao.DAOException;
import com.helger.dao.EDAOActionType;
import com.helger.dao.wal.AbstractWALDAO;
import com.helger.dao.wal.IDAOChangeCallback;
import com.helger.dao.wal.IDAOReadChangeAware;
import com.helger.dao.wal.IMapBasedDAO;
import com.helger.xml.microdom.IMicroDocument;
import com.helger.xml.microdom.IMicroElement;
import com.helger.xml.microdom.IMicroNode;
import com.helger.xml.microdom.MicroDocument;
import com.helger.xml.microdom.convert.MicroTypeConverter;
import java.util.Collection;
import java.util.Comparator;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public abstract class AbstractMapBasedWALDAO<INTERFACETYPE extends IHasID<String>, IMPLTYPE extends INTERFACETYPE>
extends AbstractWALDAO<IMPLTYPE>
implements IMapBasedDAO<INTERFACETYPE> {
    protected static final String ELEMENT_ROOT = "root";
    protected static final String ELEMENT_ITEM = "item";
    @GuardedBy(value="m_aRWLock")
    private final ICommonsMap<String, IMPLTYPE> m_aMap;
    private final CallbackList<IDAOChangeCallback<INTERFACETYPE>> m_aCallbacks = new CallbackList();
    private final Predicate<IMicroElement> m_aReadElementFilter;

    protected AbstractMapBasedWALDAO(@Nonnull Class<IMPLTYPE> clazz, @Nonnull IFileRelativeIO iFileRelativeIO, @Nullable String string, @Nonnull InitSettings<IMPLTYPE> initSettings) throws DAOException {
        super(clazz, iFileRelativeIO, () -> string);
        this.m_aMap = initSettings.m_aMapSupplier.get();
        this.m_aReadElementFilter = initSettings.m_aReadElementFilter;
        if (initSettings.m_bDoInitialRead) {
            this.initialRead();
        }
    }

    @Override
    @MustBeLocked(value=ELockType.WRITE)
    protected void onRecoveryCreate(@Nonnull IMPLTYPE IMPLTYPE) {
        this._addItem(IMPLTYPE, EDAOActionType.CREATE);
    }

    @Override
    @MustBeLocked(value=ELockType.WRITE)
    protected void onRecoveryUpdate(@Nonnull IMPLTYPE IMPLTYPE) {
        this._addItem(IMPLTYPE, EDAOActionType.UPDATE);
    }

    @Override
    @MustBeLocked(value=ELockType.WRITE)
    protected void onRecoveryDelete(@Nonnull IMPLTYPE IMPLTYPE) {
        this.m_aMap.remove(IMPLTYPE.getID(), IMPLTYPE);
    }

    @Override
    @Nonnull
    protected EChange onRead(@Nonnull IMicroDocument iMicroDocument) {
        Class clazz = this.getDataTypeClass();
        Wrapper wrapper = new Wrapper((Object)EChange.UNCHANGED);
        iMicroDocument.getDocumentElement().forAllChildElements(this.m_aReadElementFilter, iMicroElement -> {
            IHasID iHasID = (IHasID)MicroTypeConverter.convertToNative((IMicroElement)iMicroElement, (Class)clazz);
            this._addItem(iHasID, EDAOActionType.CREATE);
            if (iHasID instanceof IDAOReadChangeAware && ((IDAOReadChangeAware)iHasID).isReadChanged()) {
                wrapper.set((Object)EChange.CHANGED);
            }
        });
        return (EChange)wrapper.get();
    }

    @MustBeLocked(value=ELockType.READ)
    @CodingStyleguideUnaware
    protected final Collection<IMPLTYPE> internalGetAllSortedByKey() {
        return this.m_aMap.getSortedByKey(Comparator.naturalOrder()).values();
    }

    @Override
    @Nonnull
    @MustBeLocked(value=ELockType.READ)
    protected IMicroDocument createWriteData() {
        MicroDocument microDocument = new MicroDocument();
        IMicroElement iMicroElement = microDocument.appendElement(ELEMENT_ROOT);
        for (IHasID iHasID : this.internalGetAllSortedByKey()) {
            iMicroElement.appendChild((IMicroNode)MicroTypeConverter.convertToMicroElement((Object)iHasID, (String)ELEMENT_ITEM));
        }
        return microDocument;
    }

    @Nonnull
    @ReturnsMutableObject
    public final CallbackList<IDAOChangeCallback<INTERFACETYPE>> callbacks() {
        return this.m_aCallbacks;
    }

    @MustBeLocked(value=ELockType.WRITE)
    private void _addItem(@Nonnull IMPLTYPE IMPLTYPE, @Nonnull EDAOActionType eDAOActionType) {
        ValueEnforcer.notNull(IMPLTYPE, (String)"Item");
        ValueEnforcer.isTrue((eDAOActionType == EDAOActionType.CREATE || eDAOActionType == EDAOActionType.UPDATE ? 1 : 0) != 0, (String)"Invalid action type provided!");
        String string = (String)IMPLTYPE.getID();
        IHasID iHasID = (IHasID)this.m_aMap.get((Object)string);
        if (eDAOActionType == EDAOActionType.CREATE) {
            if (iHasID != null) {
                throw new IllegalArgumentException(ClassHelper.getClassLocalName(this.getDataTypeClass()) + " with ID '" + string + "' is already in use and can therefore not be created again. Old item = " + iHasID + "; New item = " + IMPLTYPE);
            }
        } else if (iHasID == null) {
            throw new IllegalArgumentException(ClassHelper.getClassLocalName(this.getDataTypeClass()) + " with ID '" + string + "' is not yet in use and can therefore not be updated! Updated item = " + IMPLTYPE);
        }
        this.m_aMap.put((Object)string, IMPLTYPE);
    }

    @Override
    @Deprecated
    @MustBeLocked(value=ELockType.WRITE)
    @DevelopersNote(value="Avoid that this method is overridden")
    protected final void markAsChanged(@Nonnull IMPLTYPE IMPLTYPE, @Nonnull EDAOActionType eDAOActionType) {
        super.markAsChanged(IMPLTYPE, eDAOActionType);
    }

    @Nonnull
    @MustBeLocked(value=ELockType.WRITE)
    protected final IMPLTYPE internalCreateItem(@Nonnull IMPLTYPE IMPLTYPE) {
        return this.internalCreateItem(IMPLTYPE, true);
    }

    @Nonnull
    @MustBeLocked(value=ELockType.WRITE)
    protected final IMPLTYPE internalCreateItem(@Nonnull IMPLTYPE IMPLTYPE, boolean bl) {
        this._addItem(IMPLTYPE, EDAOActionType.CREATE);
        super.markAsChanged(IMPLTYPE, EDAOActionType.CREATE);
        if (bl) {
            this.m_aCallbacks.forEach(iDAOChangeCallback -> iDAOChangeCallback.onCreateItem(IMPLTYPE));
        }
        return IMPLTYPE;
    }

    @MustBeLocked(value=ELockType.WRITE)
    protected final void internalUpdateItem(@Nonnull IMPLTYPE IMPLTYPE) {
        this.internalUpdateItem(IMPLTYPE, true);
    }

    @MustBeLocked(value=ELockType.WRITE)
    protected final void internalUpdateItem(@Nonnull IMPLTYPE IMPLTYPE, boolean bl) {
        this._addItem(IMPLTYPE, EDAOActionType.UPDATE);
        super.markAsChanged(IMPLTYPE, EDAOActionType.UPDATE);
        if (bl) {
            this.m_aCallbacks.forEach(iDAOChangeCallback -> iDAOChangeCallback.onUpdateItem(IMPLTYPE));
        }
    }

    @Nullable
    @MustBeLocked(value=ELockType.WRITE)
    protected final IMPLTYPE internalDeleteItem(@Nullable String string) {
        return this.internalDeleteItem(string, true);
    }

    @Nullable
    @MustBeLocked(value=ELockType.WRITE)
    protected final IMPLTYPE internalDeleteItem(@Nullable String string, boolean bl) {
        if (StringHelper.hasNoText((String)string)) {
            return null;
        }
        IHasID iHasID = (IHasID)this.m_aMap.remove((Object)string);
        if (iHasID == null) {
            return null;
        }
        super.markAsChanged(iHasID, EDAOActionType.DELETE);
        if (bl) {
            this.m_aCallbacks.forEach(iDAOChangeCallback -> iDAOChangeCallback.onDeleteItem(iHasID));
        }
        return (IMPLTYPE)iHasID;
    }

    @MustBeLocked(value=ELockType.WRITE)
    protected final void internalMarkItemDeleted(@Nonnull IMPLTYPE IMPLTYPE) {
        this.internalMarkItemDeleted(IMPLTYPE, true);
    }

    @MustBeLocked(value=ELockType.WRITE)
    protected final void internalMarkItemDeleted(@Nonnull IMPLTYPE IMPLTYPE, boolean bl) {
        super.markAsChanged(IMPLTYPE, EDAOActionType.UPDATE);
        if (bl) {
            this.m_aCallbacks.forEach(iDAOChangeCallback -> iDAOChangeCallback.onMarkItemDeleted(IMPLTYPE));
        }
    }

    @MustBeLocked(value=ELockType.WRITE)
    protected final void internalMarkItemUndeleted(@Nonnull IMPLTYPE IMPLTYPE) {
        this.internalMarkItemUndeleted(IMPLTYPE, true);
    }

    @MustBeLocked(value=ELockType.WRITE)
    protected final void internalMarkItemUndeleted(@Nonnull IMPLTYPE IMPLTYPE, boolean bl) {
        super.markAsChanged(IMPLTYPE, EDAOActionType.UPDATE);
        if (bl) {
            this.m_aCallbacks.forEach(iDAOChangeCallback -> iDAOChangeCallback.onMarkItemUndeleted(IMPLTYPE));
        }
    }

    @Nonnull
    @MustBeLocked(value=ELockType.WRITE)
    protected final EChange internalRemoveAllItemsNoCallback() {
        return this.m_aMap.removeAll();
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public final <T> ICommonsList<T> getNone() {
        return new CommonsArrayList();
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    @IsLocked(value=ELockType.READ)
    public final ICommonsList<INTERFACETYPE> getAll() {
        return (ICommonsList)this.m_aRWLock.readLockedGet(() -> new CommonsArrayList(this.m_aMap.values()));
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    @IsLocked(value=ELockType.READ)
    public final ICommonsList<INTERFACETYPE> getAll(@Nullable Predicate<? super INTERFACETYPE> predicate) {
        if (predicate == null) {
            return this.getAll();
        }
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        this.m_aRWLock.readLocked(() -> this.lambda$getAll$8(predicate, (ICommonsList)commonsArrayList));
        return commonsArrayList;
    }

    @Nonnull
    @ReturnsMutableCopy
    @IsLocked(value=ELockType.READ)
    protected final Iterable<IMPLTYPE> internalDirectGetAll() {
        return (Iterable)this.m_aRWLock.readLockedGet(() -> this.m_aMap.values());
    }

    @Nonnull
    @ReturnsMutableCopy
    @IsLocked(value=ELockType.READ)
    protected final ICommonsList<IMPLTYPE> internalGetAll(@Nullable Predicate<? super IMPLTYPE> predicate) {
        return (ICommonsList)this.m_aRWLock.readLockedGet(() -> this.m_aMap.copyOfValues(predicate));
    }

    @Override
    @IsLocked(value=ELockType.READ)
    public final void findAll(@Nullable Predicate<? super INTERFACETYPE> predicate, @Nonnull Consumer<? super INTERFACETYPE> consumer) {
        this.m_aRWLock.readLocked(() -> CollectionHelper.findAll((Iterable)this.m_aMap.values(), (Predicate)predicate, (Consumer)consumer));
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    @IsLocked(value=ELockType.READ)
    public final <RETTYPE> ICommonsList<RETTYPE> getAllMapped(@Nullable Predicate<? super INTERFACETYPE> predicate, @Nonnull Function<? super INTERFACETYPE, ? extends RETTYPE> function) {
        return (ICommonsList)this.m_aRWLock.readLockedGet(() -> this.m_aMap.copyOfValuesMapped(predicate, function));
    }

    @Override
    @IsLocked(value=ELockType.READ)
    public final <RETTYPE> void findAllMapped(@Nullable Predicate<? super INTERFACETYPE> predicate, @Nonnull Function<? super INTERFACETYPE, ? extends RETTYPE> function, @Nonnull Consumer<? super RETTYPE> consumer) {
        this.m_aRWLock.readLocked(() -> CollectionHelper.findAllMapped((Iterable)this.m_aMap.values(), (Predicate)predicate, (Function)function, (Consumer)consumer));
    }

    @Override
    @Nullable
    @IsLocked(value=ELockType.READ)
    public final INTERFACETYPE findFirst(@Nullable Predicate<? super INTERFACETYPE> predicate) {
        return (INTERFACETYPE)((IHasID)this.m_aRWLock.readLockedGet(() -> (IHasID)CollectionHelper.findFirst((Iterable)this.m_aMap.values(), (Predicate)predicate)));
    }

    @Override
    @Nullable
    @IsLocked(value=ELockType.READ)
    public final <RETTYPE> RETTYPE findFirstMapped(@Nullable Predicate<? super INTERFACETYPE> predicate, @Nonnull Function<? super INTERFACETYPE, ? extends RETTYPE> function) {
        return (RETTYPE)this.m_aRWLock.readLockedGet(() -> CollectionHelper.findFirstMapped((Iterable)this.m_aMap.values(), (Predicate)predicate, (Function)function));
    }

    @IsLocked(value=ELockType.READ)
    public final boolean isNotEmpty() {
        return this.m_aRWLock.readLockedBoolean(() -> this.m_aMap.isNotEmpty());
    }

    @Override
    @IsLocked(value=ELockType.READ)
    public final boolean containsAny(@Nullable Predicate<? super INTERFACETYPE> predicate) {
        return this.m_aRWLock.readLockedBoolean(() -> CollectionHelper.containsAny((Iterable)this.m_aMap.values(), (Predicate)predicate));
    }

    @IsLocked(value=ELockType.READ)
    public final boolean isEmpty() {
        return this.m_aRWLock.readLockedBoolean(() -> this.m_aMap.isEmpty());
    }

    @Override
    @IsLocked(value=ELockType.READ)
    public final boolean containsNone(@Nullable Predicate<? super INTERFACETYPE> predicate) {
        return this.m_aRWLock.readLockedBoolean(() -> CollectionHelper.containsNone((Iterable)this.m_aMap.values(), (Predicate)predicate));
    }

    @Override
    @IsLocked(value=ELockType.READ)
    public final boolean containsOnly(@Nullable Predicate<? super INTERFACETYPE> predicate) {
        return this.m_aRWLock.readLockedBoolean(() -> CollectionHelper.containsOnly((Iterable)this.m_aMap.values(), (Predicate)predicate));
    }

    @Override
    @IsLocked(value=ELockType.READ)
    public final void forEach(@Nullable BiConsumer<? super String, ? super INTERFACETYPE> biConsumer) {
        this.m_aRWLock.readLocked(() -> this.m_aMap.forEach(biConsumer));
    }

    @Override
    @IsLocked(value=ELockType.READ)
    public final void forEach(@Nullable BiPredicate<? super String, ? super INTERFACETYPE> biPredicate, @Nullable BiConsumer<? super String, ? super INTERFACETYPE> biConsumer) {
        this.m_aRWLock.readLocked(() -> this.m_aMap.forEach(biPredicate, biConsumer));
    }

    @Override
    @IsLocked(value=ELockType.READ)
    public final void forEachKey(@Nullable Consumer<? super String> consumer) {
        this.m_aRWLock.readLocked(() -> this.m_aMap.forEachKey(consumer));
    }

    @Override
    @IsLocked(value=ELockType.READ)
    public final void forEachKey(@Nullable Predicate<? super String> predicate, @Nullable Consumer<? super String> consumer) {
        this.m_aRWLock.readLocked(() -> this.m_aMap.forEachKey(predicate, consumer));
    }

    @Override
    @IsLocked(value=ELockType.READ)
    public final void forEachValue(@Nullable Consumer<? super INTERFACETYPE> consumer) {
        this.m_aRWLock.readLocked(() -> this.m_aMap.forEachValue(consumer));
    }

    @IsLocked(value=ELockType.READ)
    protected final void internalForEachValue(@Nullable Consumer<? super IMPLTYPE> consumer) {
        this.m_aRWLock.readLocked(() -> this.m_aMap.forEachValue(consumer));
    }

    @Override
    @IsLocked(value=ELockType.READ)
    public final void forEachValue(@Nullable Predicate<? super INTERFACETYPE> predicate, @Nullable Consumer<? super INTERFACETYPE> consumer) {
        this.m_aRWLock.readLocked(() -> this.m_aMap.forEachValue(predicate, consumer));
    }

    @IsLocked(value=ELockType.READ)
    protected final void internalForEachValue(@Nullable Predicate<? super IMPLTYPE> predicate, @Nullable Consumer<? super IMPLTYPE> consumer) {
        this.m_aRWLock.readLocked(() -> this.m_aMap.forEachValue(predicate, consumer));
    }

    @Nullable
    @MustBeLocked(value=ELockType.READ)
    protected final IMPLTYPE internalGetOfID(@Nullable String string) {
        if (StringHelper.hasNoText((String)string)) {
            return null;
        }
        return (IMPLTYPE)((IHasID)this.m_aMap.get((Object)string));
    }

    @Nullable
    @IsLocked(value=ELockType.READ)
    protected final IMPLTYPE getOfID(@Nullable String string) {
        if (StringHelper.hasNoText((String)string)) {
            return null;
        }
        return (IMPLTYPE)((IHasID)this.m_aRWLock.readLockedGet(() -> (IHasID)this.m_aMap.get((Object)string)));
    }

    @Nullable
    @IsLocked(value=ELockType.READ)
    protected final INTERFACETYPE getAtIndex(@Nonnegative int n) {
        return (INTERFACETYPE)((IHasID)this.m_aRWLock.readLockedGet(() -> (IHasID)CollectionHelper.getAtIndex((Iterable)this.m_aMap.values(), (int)n)));
    }

    @MustBeLocked(value=ELockType.READ)
    protected final boolean internalContainsWithID(@Nullable String string) {
        if (StringHelper.hasNoText((String)string)) {
            return false;
        }
        return this.m_aMap.containsKey((Object)string);
    }

    @Override
    @IsLocked(value=ELockType.READ)
    public final boolean containsWithID(@Nullable String string) {
        if (StringHelper.hasNoText((String)string)) {
            return false;
        }
        return this.m_aRWLock.readLockedBoolean(() -> this.m_aMap.containsKey((Object)string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @IsLocked(value=ELockType.READ)
    public final boolean containsAllIDs(@Nullable Iterable<String> iterable) {
        if (iterable != null) {
            this.m_aRWLock.readLock().lock();
            try {
                for (String string : iterable) {
                    if (this.m_aMap.containsKey((Object)string)) continue;
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                this.m_aRWLock.readLock().unlock();
            }
        }
        return true;
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public final ICommonsSet<String> getAllIDs() {
        return (ICommonsSet)this.m_aRWLock.readLockedGet(() -> this.m_aMap.copyOfKeySet());
    }

    @Nonnegative
    public final int size() {
        return this.m_aRWLock.readLockedInt(() -> this.m_aMap.size());
    }

    @Override
    @Nonnegative
    public final int getCount(@Nullable Predicate<? super INTERFACETYPE> predicate) {
        return this.m_aRWLock.readLockedInt(() -> CollectionHelper.getCount((Collection)this.m_aMap.values(), (Predicate)predicate));
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).append("Map", this.m_aMap).getToString();
    }

    private /* synthetic */ void lambda$getAll$8(Predicate predicate, ICommonsList iCommonsList) {
        CollectionHelper.findAll((Iterable)this.m_aMap.values(), (Predicate)predicate, arg_0 -> iCommonsList.add(arg_0));
    }

    public static final class InitSettings<IMPLTYPE> {
        private boolean m_bDoInitialRead = true;
        private Supplier<ICommonsMap<String, IMPLTYPE>> m_aMapSupplier = CommonsHashMap::new;
        private Predicate<IMicroElement> m_aReadElementFilter = Predicates.all();

        @Nonnull
        public InitSettings<IMPLTYPE> setDoInitialRead(boolean bl) {
            this.m_bDoInitialRead = bl;
            return this;
        }

        @Nonnull
        public InitSettings<IMPLTYPE> setMapSupplier(@Nonnull Supplier<ICommonsMap<String, IMPLTYPE>> supplier) {
            this.m_aMapSupplier = (Supplier)ValueEnforcer.notNull(supplier, (String)"MapSupplier");
            return this;
        }

        @Nonnull
        public InitSettings<IMPLTYPE> setOrderedMapSupplier() {
            return this.setMapSupplier(CommonsLinkedHashMap::new);
        }

        @Nonnull
        public InitSettings<IMPLTYPE> setReadElementFilter(@Nonnull Predicate<IMicroElement> predicate) {
            this.m_aReadElementFilter = (Predicate)ValueEnforcer.notNull(predicate, (String)"ReadElementFilter");
            return this;
        }
    }
}

