/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.javacc;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;

class UrlUtils {
    private static final Charset UTF8 = Charset.forName("UTF-8");
    private static final String JAR = "jar:";
    private static final String FILE = "file:";
    private static final String JAR_FILE = "jar:file:";

    UrlUtils() {
    }

    public static File getResourceRoot(URL uRL, String string) {
        String string2 = null;
        if (uRL != null) {
            String string3 = uRL.toExternalForm();
            if (JAR_FILE.regionMatches(true, 0, string3, 0, JAR_FILE.length())) {
                URL uRL2;
                try {
                    uRL2 = new URL(string3.substring(JAR.length(), string3.lastIndexOf("!/")));
                }
                catch (MalformedURLException malformedURLException) {
                    throw new IllegalArgumentException("Invalid JAR URL: " + uRL + ", " + malformedURLException.getMessage());
                }
                string2 = UrlUtils.decodeUrl(uRL2.getPath());
            } else if (FILE.regionMatches(true, 0, string3, 0, FILE.length())) {
                string2 = UrlUtils.decodeUrl(uRL.getPath());
                string2 = string2.substring(0, string2.length() - string.length());
            } else {
                throw new IllegalArgumentException("Invalid class path URL: " + uRL);
            }
        }
        return string2 != null ? new File(string2) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String decodeUrl(String string) {
        String string2 = string;
        if (string != null && string.indexOf(37) >= 0) {
            int n = string.length();
            StringBuffer stringBuffer = new StringBuffer();
            ByteBuffer byteBuffer = ByteBuffer.allocate(n);
            int n2 = 0;
            while (n2 < n) {
                if (string.charAt(n2) == '%') {
                    try {
                        do {
                            byte by = (byte)Integer.parseInt(string.substring(n2 + 1, n2 + 3), 16);
                            byteBuffer.put(by);
                        } while ((n2 += 3) < n && string.charAt(n2) == '%');
                        continue;
                    }
                    catch (RuntimeException runtimeException) {
                    }
                    finally {
                        if (byteBuffer.position() <= 0) continue;
                        byteBuffer.flip();
                        stringBuffer.append(UTF8.decode(byteBuffer).toString());
                        byteBuffer.clear();
                        continue;
                    }
                }
                stringBuffer.append(string.charAt(n2++));
            }
            string2 = stringBuffer.toString();
        }
        return string2;
    }
}

