/*
 * Decompiled with CFR 0.152.
 */
package com.helger.maven.schematron;

import com.helger.commons.io.resource.FileSystemResource;
import com.helger.commons.io.resource.IReadableResource;
import com.helger.schematron.SchematronException;
import com.helger.schematron.pure.binding.IPSQueryBinding;
import com.helger.schematron.pure.binding.PSQueryBindingRegistry;
import com.helger.schematron.pure.exchange.PSReader;
import com.helger.schematron.pure.model.PSNS;
import com.helger.schematron.pure.model.PSSchema;
import com.helger.schematron.pure.preprocess.PSPreprocessor;
import com.helger.schematron.pure.preprocess.SchematronPreprocessException;
import com.helger.xml.microdom.IMicroNode;
import com.helger.xml.microdom.MicroDocument;
import com.helger.xml.microdom.serialize.MicroWriter;
import com.helger.xml.namespace.INamespaceContext;
import com.helger.xml.namespace.MapBasedNamespaceContext;
import com.helger.xml.serialize.write.EXMLSerializeIndent;
import com.helger.xml.serialize.write.IXMLWriterSettings;
import com.helger.xml.serialize.write.XMLWriterSettings;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.util.Iterator;
import javax.annotation.Nonnull;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.slf4j.impl.StaticLoggerBinder;
import org.sonatype.plexus.build.incremental.BuildContext;

@SuppressFBWarnings(value={"NP_UNWRITTEN_FIELD", "UWF_UNWRITTEN_FIELD"})
@Mojo(name="preprocess", defaultPhase=LifecyclePhase.GENERATE_RESOURCES, threadSafe=true)
public final class SchematronPreprocessMojo
extends AbstractMojo {
    @Component
    private BuildContext buildContext;
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject project;
    @Parameter(name="sourceFile", required=true)
    private File m_aSourceFile;
    @Parameter(name="targetFile", required=true)
    private File m_aTargetFile;
    @Parameter(name="overwriteWithoutNotice", defaultValue="true")
    private boolean m_bOverwriteWithoutNotice;
    @Parameter(name="keepTitles", defaultValue="false")
    private boolean m_bKeepTitles;
    @Parameter(name="keepDiagnostics", defaultValue="false")
    private boolean m_bKeepDiagnostics;
    @Parameter(name="keepReports", defaultValue="false")
    private boolean m_bKeepReports;
    @Parameter(name="keepEmptyPatterns", defaultValue="false")
    private boolean m_bKeepEmptyPatterns;

    public void setSourceFile(@Nonnull File file) {
        this.m_aSourceFile = file;
        if (!this.m_aSourceFile.isAbsolute()) {
            this.m_aSourceFile = new File(this.project.getBasedir(), file.getPath());
        }
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("Using Source file '" + this.m_aSourceFile + "'"));
        }
    }

    public void setTargetFile(@Nonnull File file) {
        this.m_aTargetFile = file;
        if (!this.m_aTargetFile.isAbsolute()) {
            this.m_aTargetFile = new File(this.project.getBasedir(), file.getPath());
        }
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("Using Target file '" + this.m_aTargetFile + "'"));
        }
    }

    public void setOverwriteWithoutNotice(boolean bl) {
        this.m_bOverwriteWithoutNotice = bl;
        if (this.m_bOverwriteWithoutNotice) {
            this.getLog().debug((CharSequence)"Overwriting Target file without notice");
        } else {
            this.getLog().debug((CharSequence)"Ignoring existing Target file");
        }
    }

    public void setKeepTitles(boolean bl) {
        this.m_bKeepTitles = bl;
        if (bl) {
            this.getLog().debug((CharSequence)"Keeping <title> elements");
        } else {
            this.getLog().debug((CharSequence)"Removing <title> elements");
        }
    }

    public void setKeepDiagnostics(boolean bl) {
        this.m_bKeepDiagnostics = bl;
        if (bl) {
            this.getLog().debug((CharSequence)"Keeping <diagnostic> elements");
        } else {
            this.getLog().debug((CharSequence)"Removing <diagnostic> elements");
        }
    }

    public void setKeepReports(boolean bl) {
        this.m_bKeepReports = bl;
        if (bl) {
            this.getLog().debug((CharSequence)"Keeping <report> elements");
        } else {
            this.getLog().debug((CharSequence)"Converting <report> to <assert> elements");
        }
    }

    public void setKeepEmptyPatterns(boolean bl) {
        this.m_bKeepEmptyPatterns = bl;
        if (bl) {
            this.getLog().debug((CharSequence)"Keeping <pattern> elements without rules");
        } else {
            this.getLog().debug((CharSequence)"Removing <pattern> elements without rules");
        }
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        StaticLoggerBinder.getSingleton().setMavenLog(this.getLog());
        if (this.m_aSourceFile == null) {
            throw new MojoExecutionException("No Source file specified!");
        }
        if (this.m_aSourceFile.exists() && !this.m_aSourceFile.isFile()) {
            throw new MojoExecutionException("The specified Source file " + this.m_aSourceFile + " is not a file!");
        }
        if (this.m_aTargetFile == null) {
            throw new MojoExecutionException("No Target file specified!");
        }
        if (this.m_aTargetFile.exists()) {
            if (!this.m_bOverwriteWithoutNotice) {
                this.getLog().debug((CharSequence)("Skipping Target file '" + this.m_aTargetFile.getPath() + "' because it already exists!"));
            } else if (!this.m_aTargetFile.isFile()) {
                throw new MojoExecutionException("The specified Target file " + this.m_aTargetFile + " is not a file!");
            }
        }
        try {
            PSNS pSNS2;
            PSSchema pSSchema = new PSReader((IReadableResource)new FileSystemResource(this.m_aSourceFile), null, null).readSchema();
            IPSQueryBinding iPSQueryBinding = PSQueryBindingRegistry.getQueryBindingOfNameOrThrow((String)pSSchema.getQueryBinding());
            PSPreprocessor pSPreprocessor = new PSPreprocessor(iPSQueryBinding);
            pSPreprocessor.setKeepTitles(this.m_bKeepTitles);
            pSPreprocessor.setKeepDiagnostics(this.m_bKeepDiagnostics);
            pSPreprocessor.setKeepReports(this.m_bKeepReports);
            pSPreprocessor.setKeepEmptyPatterns(this.m_bKeepEmptyPatterns);
            PSSchema pSSchema2 = pSPreprocessor.getForcedPreprocessedSchema(pSSchema);
            if (pSSchema2 == null) {
                throw new SchematronPreprocessException("Failed to preprocess schema " + pSSchema + " with query binding " + iPSQueryBinding);
            }
            MapBasedNamespaceContext mapBasedNamespaceContext = new MapBasedNamespaceContext();
            mapBasedNamespaceContext.addDefaultNamespaceURI("http://purl.oclc.org/dsdl/schematron");
            mapBasedNamespaceContext.addMapping("xsl", "http://www.w3.org/1999/XSL/Transform");
            mapBasedNamespaceContext.addMapping("svrl", "http://purl.oclc.org/dsdl/svrl");
            for (PSNS pSNS2 : pSSchema.getAllNSs()) {
                mapBasedNamespaceContext.setMapping(pSNS2.getPrefix(), pSNS2.getUri());
            }
            Iterator iterator = new XMLWriterSettings().setIndent(EXMLSerializeIndent.INDENT_AND_ALIGN).setNamespaceContext((INamespaceContext)mapBasedNamespaceContext);
            pSNS2 = new MicroDocument();
            pSNS2.appendChild((IMicroNode)pSSchema2.getAsMicroElement());
            if (MicroWriter.writeToFile((IMicroNode)pSNS2, (File)this.m_aTargetFile, (IXMLWriterSettings)iterator).isSuccess()) {
                this.getLog().info((CharSequence)("Successfully wrote preprocessed Schematron file '" + this.m_aTargetFile.getPath() + "'"));
            } else {
                this.getLog().error((CharSequence)("Error writing preprocessed Schematron file to '" + this.m_aTargetFile.getPath() + "'"));
            }
        }
        catch (SchematronException schematronException) {
            throw new MojoExecutionException("Error preprocessing Schematron file '" + this.m_aSourceFile + "'", (Exception)((Object)schematronException));
        }
    }
}

