/*
 * Decompiled with CFR 0.152.
 */
package com.helger.peppol.utils;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.cache.Cache;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.datetime.PDTFactory;
import com.helger.commons.io.stream.NonBlockingByteArrayInputStream;
import com.helger.commons.io.stream.StreamHelper;
import com.helger.commons.string.StringHelper;
import com.helger.commons.timing.StopWatch;
import com.helger.commons.url.EURLProtocol;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URL;
import java.security.cert.CRL;
import java.security.cert.CRLException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.time.LocalDateTime;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.bouncycastle.asn1.ASN1IA5String;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.x509.CRLDistPoint;
import org.bouncycastle.asn1.x509.DistributionPoint;
import org.bouncycastle.asn1.x509.DistributionPointName;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public final class CRLHelper {
    private CRLHelper() {
    }

    @Nonnull
    public static X509CRL convertToCRL(@Nonnull @Nonempty byte[] byArray) {
        X509CRL x509CRL;
        ValueEnforcer.notEmpty((byte[])byArray, (String)"CRLBytes");
        NonBlockingByteArrayInputStream nonBlockingByteArrayInputStream = new NonBlockingByteArrayInputStream(byArray);
        try {
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            x509CRL = (X509CRL)certificateFactory.generateCRL((InputStream)nonBlockingByteArrayInputStream);
        }
        catch (Throwable throwable) {
            try {
                try {
                    nonBlockingByteArrayInputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (CertificateException certificateException) {
                throw new IllegalArgumentException(certificateException);
            }
            catch (CRLException cRLException) {
                throw new IllegalArgumentException("Cannot generate X509CRL from the stream data", cRLException);
            }
        }
        nonBlockingByteArrayInputStream.close();
        return x509CRL;
    }

    @Nonnull
    public static ICommonsList<String> getAllDistributionPoints(@Nonnull X509Certificate x509Certificate) {
        ValueEnforcer.notNull((Object)x509Certificate, (String)"Certificate");
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        byte[] byArray = x509Certificate.getExtensionValue(Extension.cRLDistributionPoints.getId());
        if (byArray != null) {
            try (ASN1InputStream aSN1InputStream = new ASN1InputStream(byArray);){
                CRLDistPoint cRLDistPoint;
                try {
                    DistributionPoint[] distributionPointArray = (DistributionPoint[])aSN1InputStream.readObject();
                    try (ASN1InputStream aSN1InputStream2 = new ASN1InputStream(distributionPointArray.getOctets());){
                        ASN1Primitive aSN1Primitive = aSN1InputStream2.readObject();
                        cRLDistPoint = CRLDistPoint.getInstance((Object)aSN1Primitive);
                    }
                }
                catch (IOException iOException) {
                    throw new UncheckedIOException(iOException);
                }
                for (DistributionPoint distributionPoint : cRLDistPoint.getDistributionPoints()) {
                    GeneralName[] generalNameArray;
                    DistributionPointName distributionPointName = distributionPoint.getDistributionPoint();
                    if (distributionPointName == null || distributionPointName.getType() != 0) continue;
                    for (GeneralName generalName : generalNameArray = GeneralNames.getInstance((Object)distributionPointName.getName()).getNames()) {
                        if (generalName.getTagNo() != 6) continue;
                        String string = ASN1IA5String.getInstance((Object)generalName.getName()).getString().trim();
                        commonsArrayList.add((Object)string);
                    }
                }
            }
            catch (IOException iOException) {
                throw new UncheckedIOException(iOException);
            }
        }
        return commonsArrayList;
    }

    @Nullable
    public static CRL getCRLFromURL(@Nullable String string) {
        TimedCRL timedCRL;
        if (StringHelper.hasText((String)string) && (timedCRL = (TimedCRL)CRLCache.INSTANCE.getFromCache(string)) != null) {
            return timedCRL.getCRL();
        }
        return null;
    }

    public static final class CRLCache
    extends Cache<String, TimedCRL> {
        public static final CRLCache INSTANCE = new CRLCache();
        private static final Logger LOGGER = LoggerFactory.getLogger(CRLCache.class);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        private static TimedCRL _loadCRL(@Nonnull String string) {
            if (EURLProtocol.HTTP.isUsedInURL(string) || EURLProtocol.HTTPS.isUsedInURL(string) || EURLProtocol.FTP.isUsedInURL(string)) {
                LOGGER.info("Trying to download CRL from URL '" + string + "'");
                StopWatch stopWatch = StopWatch.createdStarted();
                int n = 0;
                try (InputStream inputStream = new URL(string).openStream();){
                    byte[] byArray = StreamHelper.getAllBytes((InputStream)inputStream);
                    if (byArray != null) {
                        n = byArray.length;
                        TimedCRL timedCRL = TimedCRL.ofNow(CRLHelper.convertToCRL(byArray));
                        return timedCRL;
                    }
                }
                catch (Exception exception) {
                    LOGGER.error("Error downloading CRL from URL '" + string + "'", (Throwable)exception);
                }
                finally {
                    stopWatch.stop();
                    LOGGER.info("Downloading the CRL took " + stopWatch.getMillis() + " milliseconds for " + n + " bytes");
                }
            }
            return null;
        }

        protected CRLCache() {
            super(CRLCache::_loadCRL, 100, "CRL Cache");
        }
    }

    public static class TimedCRL {
        private final LocalDateTime m_aReadDateTime;
        private final CRL m_aCRL;

        public TimedCRL(@Nonnull LocalDateTime localDateTime, @Nonnull CRL cRL) {
            this.m_aReadDateTime = localDateTime;
            this.m_aCRL = cRL;
        }

        @Nonnull
        public final LocalDateTime getReadDateTime() {
            return this.m_aReadDateTime;
        }

        @Nonnull
        public final CRL getCRL() {
            return this.m_aCRL;
        }

        @Nonnull
        public static TimedCRL ofNow(@Nonnull CRL cRL) {
            return new TimedCRL(PDTFactory.getCurrentLocalDateTime(), cRL);
        }
    }
}

