/*
 * Decompiled with CFR 0.152.
 */
package com.helger.peppol.utils;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.builder.IBuilder;
import com.helger.commons.callback.IThrowingRunnable;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.CommonsHashSet;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.concurrent.SimpleReadWriteLock;
import com.helger.commons.datetime.PDTFactory;
import com.helger.commons.state.ETriState;
import com.helger.commons.timing.StopWatch;
import com.helger.commons.traits.IGenericImplTrait;
import com.helger.peppol.utils.CRLHelper;
import com.helger.peppol.utils.ERevocationCheckMode;
import com.helger.peppol.utils.ERevoked;
import java.security.GeneralSecurityException;
import java.security.Security;
import java.security.cert.CertPathBuilder;
import java.security.cert.CertPathParameters;
import java.security.cert.CertPathValidator;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.PKIXCertPathBuilderResult;
import java.security.cert.PKIXCertPathValidatorResult;
import java.security.cert.PKIXRevocationChecker;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.NotThreadSafe;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class CertificateRevocationChecker {
    public static final ERevocationCheckMode DEFAULT_REVOCATION_CHECK_MODE = ERevocationCheckMode.OCSP;
    public static final boolean DEFAULT_ALLOW_SOFT_FAIL = false;
    public static final boolean DEFAULT_ALLOW_EXEC_SYNC = true;
    private static final Logger LOGGER = LoggerFactory.getLogger(CertificateRevocationChecker.class);
    private static final SimpleReadWriteLock RW_LOCK = new SimpleReadWriteLock();
    @GuardedBy(value="RW_LOCK")
    private static ERevocationCheckMode s_eRevocationCheckMode = DEFAULT_REVOCATION_CHECK_MODE;
    @GuardedBy(value="RW_LOCK")
    private static Consumer<? super GeneralSecurityException> s_aExceptionHdl = generalSecurityException -> LOGGER.warn("Certificate is revoked", (Throwable)generalSecurityException);
    private static final AtomicBoolean ALLOW_SOFT_FAIL = new AtomicBoolean(false);
    @GuardedBy(value="RW_LOCK")
    private static Consumer<? super List<? extends CertPathValidatorException>> s_aSoftFailExceptionHdl = list -> LOGGER.warn("Certificate revocation check succeeded but has messages: " + list);
    private static final AtomicBoolean ALLOW_EXEC_SYNC = new AtomicBoolean(true);

    private CertificateRevocationChecker() {
    }

    @Nonnull
    public static ERevocationCheckMode getRevocationCheckMode() {
        return (ERevocationCheckMode)((Object)RW_LOCK.readLockedGet(() -> s_eRevocationCheckMode));
    }

    public static void setRevocationCheckMode(@Nonnull ERevocationCheckMode eRevocationCheckMode) {
        ValueEnforcer.notNull((Object)((Object)eRevocationCheckMode), (String)"RevocationCheckMode");
        RW_LOCK.writeLocked(() -> {
            s_eRevocationCheckMode = eRevocationCheckMode;
        });
        LOGGER.info("Global CertificateRevocationChecker revocation mode was set to: " + eRevocationCheckMode);
    }

    @Nonnull
    public static Consumer<? super GeneralSecurityException> getExceptionHdl() {
        return (Consumer)RW_LOCK.readLockedGet(() -> s_aExceptionHdl);
    }

    public static void setExceptionHdl(@Nonnull Consumer<? super GeneralSecurityException> consumer) {
        ValueEnforcer.notNull(consumer, (String)"ExceptionHdl");
        RW_LOCK.writeLocked(() -> {
            s_aExceptionHdl = consumer;
        });
    }

    public static boolean isAllowSoftFail() {
        return ALLOW_SOFT_FAIL.get();
    }

    public static void setAllowSoftFail(boolean bl) {
        ALLOW_SOFT_FAIL.set(bl);
        LOGGER.info("Global CertificateRevocationChecker allows for soft fail: " + bl);
    }

    @Nonnull
    public static Consumer<? super List<CertPathValidatorException>> getSoftFailExceptionHdl() {
        return (Consumer)RW_LOCK.readLockedGet(() -> s_aSoftFailExceptionHdl);
    }

    public static void setSoftFailExceptionHdl(@Nonnull Consumer<? super List<? extends CertPathValidatorException>> consumer) {
        ValueEnforcer.notNull(consumer, (String)"SoftFailExceptionHdl");
        RW_LOCK.writeLocked(() -> {
            s_aSoftFailExceptionHdl = consumer;
        });
    }

    public static boolean isExecuteInSynchronizedBlock() {
        return ALLOW_EXEC_SYNC.get();
    }

    public static void setExecuteInSynchronizedBlock(boolean bl) {
        ALLOW_EXEC_SYNC.set(bl);
        LOGGER.info("Global CertificateRevocationChecker is executed synchronously: " + bl);
    }

    public static RevocationCheckBuilder revocationCheck() {
        return new RevocationCheckBuilder();
    }

    @NotThreadSafe
    public static class RevocationCheckBuilder
    extends AbstractRevocationCheckBuilder<RevocationCheckBuilder> {
    }

    @NotThreadSafe
    public static abstract class AbstractRevocationCheckBuilder<IMPLTYPE extends AbstractRevocationCheckBuilder<IMPLTYPE>>
    implements IBuilder<ERevoked>,
    IGenericImplTrait<IMPLTYPE> {
        private X509Certificate m_aCert;
        private final ICommonsList<X509Certificate> m_aValidCAs = new CommonsArrayList();
        private Date m_aCheckDate;
        private ERevocationCheckMode m_eCheckMode;
        private Consumer<? super GeneralSecurityException> m_aExceptionHdl;
        private ETriState m_eAllowSoftFail = ETriState.UNDEFINED;
        private Consumer<? super List<CertPathValidatorException>> m_aSoftFailExceptionHdl;
        private ETriState m_eExecuteInSynchronizedBlock = ETriState.UNDEFINED;
        private long m_nExecutionDurationWarnMS = 500L;

        @Nullable
        public final X509Certificate certificate() {
            return this.m_aCert;
        }

        @Nonnull
        public final IMPLTYPE certificate(@Nullable X509Certificate x509Certificate) {
            this.m_aCert = x509Certificate;
            return (IMPLTYPE)((AbstractRevocationCheckBuilder)this.thisAsT());
        }

        @Nonnull
        public final IMPLTYPE validCA(@Nullable X509Certificate x509Certificate) {
            this.m_aValidCAs.set((Object)x509Certificate);
            return (IMPLTYPE)((AbstractRevocationCheckBuilder)this.thisAsT());
        }

        @Nonnull
        public final IMPLTYPE validCAs(@Nullable Iterable<? extends X509Certificate> iterable) {
            this.m_aValidCAs.setAll(iterable);
            return (IMPLTYPE)((AbstractRevocationCheckBuilder)this.thisAsT());
        }

        @Nonnull
        public final IMPLTYPE addValidCA(@Nullable X509Certificate x509Certificate) {
            if (x509Certificate != null) {
                this.m_aValidCAs.add((Object)x509Certificate);
            }
            return (IMPLTYPE)((AbstractRevocationCheckBuilder)this.thisAsT());
        }

        @Nonnull
        public final IMPLTYPE addValidCAs(@Nullable Iterable<? extends X509Certificate> iterable) {
            this.m_aValidCAs.addAll(iterable);
            return (IMPLTYPE)((AbstractRevocationCheckBuilder)this.thisAsT());
        }

        @Nullable
        public final Date checkDate() {
            return this.m_aCheckDate;
        }

        @Nonnull
        public final IMPLTYPE checkDateNow() {
            return this.checkDate((Date)null);
        }

        @Nonnull
        public final IMPLTYPE checkDate(@Nullable LocalDateTime localDateTime) {
            return this.checkDate(localDateTime == null ? null : PDTFactory.createDate((LocalDateTime)localDateTime));
        }

        @Nonnull
        public final IMPLTYPE checkDate(@Nullable OffsetDateTime offsetDateTime) {
            return this.checkDate(offsetDateTime == null ? null : PDTFactory.createDate((OffsetDateTime)offsetDateTime));
        }

        @Nonnull
        public final IMPLTYPE checkDate(@Nullable ZonedDateTime zonedDateTime) {
            return this.checkDate(zonedDateTime == null ? null : PDTFactory.createDate((ZonedDateTime)zonedDateTime));
        }

        @Nonnull
        public final IMPLTYPE checkDate(@Nullable Date date) {
            this.m_aCheckDate = date;
            return (IMPLTYPE)((AbstractRevocationCheckBuilder)this.thisAsT());
        }

        @Nonnull
        public final IMPLTYPE checkMode(@Nullable ERevocationCheckMode eRevocationCheckMode) {
            this.m_eCheckMode = eRevocationCheckMode;
            return (IMPLTYPE)((AbstractRevocationCheckBuilder)this.thisAsT());
        }

        @Nonnull
        public final IMPLTYPE exceptionHandler(@Nullable Consumer<? super GeneralSecurityException> consumer) {
            this.m_aExceptionHdl = consumer;
            return (IMPLTYPE)((AbstractRevocationCheckBuilder)this.thisAsT());
        }

        @Nonnull
        public final IMPLTYPE allowSoftFail(boolean bl) {
            this.m_eAllowSoftFail = ETriState.valueOf((boolean)bl);
            return (IMPLTYPE)((AbstractRevocationCheckBuilder)this.thisAsT());
        }

        @Nonnull
        public final IMPLTYPE allowSoftFailUndefined() {
            this.m_eAllowSoftFail = ETriState.UNDEFINED;
            return (IMPLTYPE)((AbstractRevocationCheckBuilder)this.thisAsT());
        }

        @Nonnull
        public final IMPLTYPE softFailExceptionHandler(@Nullable Consumer<? super List<CertPathValidatorException>> consumer) {
            this.m_aSoftFailExceptionHdl = consumer;
            return (IMPLTYPE)((AbstractRevocationCheckBuilder)this.thisAsT());
        }

        @Nonnull
        public final IMPLTYPE executeInSynchronizedBlock(boolean bl) {
            this.m_eExecuteInSynchronizedBlock = ETriState.valueOf((boolean)bl);
            return (IMPLTYPE)((AbstractRevocationCheckBuilder)this.thisAsT());
        }

        @Nonnull
        public final IMPLTYPE executionDurationWarnMS(long l) {
            this.m_nExecutionDurationWarnMS = l;
            return (IMPLTYPE)((AbstractRevocationCheckBuilder)this.thisAsT());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nonnull
        public ERevoked build() {
            boolean bl;
            ERevocationCheckMode eRevocationCheckMode = this.m_eCheckMode != null ? this.m_eCheckMode : CertificateRevocationChecker.getRevocationCheckMode();
            Consumer<? super GeneralSecurityException> consumer = this.m_aExceptionHdl != null ? this.m_aExceptionHdl : CertificateRevocationChecker.getExceptionHdl();
            boolean bl2 = this.m_eAllowSoftFail.isDefined() ? this.m_eAllowSoftFail.getAsBooleanValue() : CertificateRevocationChecker.isAllowSoftFail();
            Consumer<? super List<CertPathValidatorException>> consumer2 = this.m_aSoftFailExceptionHdl != null ? this.m_aSoftFailExceptionHdl : CertificateRevocationChecker.getSoftFailExceptionHdl();
            boolean bl3 = bl = this.m_eExecuteInSynchronizedBlock.isDefined() ? this.m_eExecuteInSynchronizedBlock.getAsBooleanValue() : CertificateRevocationChecker.isExecuteInSynchronizedBlock();
            if (this.m_aCert == null) {
                throw new IllegalStateException("The certificate to be checked must be set");
            }
            if (this.m_aValidCAs.isEmpty()) {
                throw new IllegalStateException("At least one valid CAs must be present");
            }
            if (this.m_nExecutionDurationWarnMS <= 0L) {
                throw new IllegalStateException("The number of milliseconds for warning on long execution must be greater than zero");
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Performing certificate revocation check on certificate '" + this.m_aCert.getSubjectX500Principal().getName() + "' " + (String)(this.m_aCheckDate != null ? "for datetime " + this.m_aCheckDate : "without a datetime") + (bl ? " [synchronized]" : " [not synchronized]"));
            }
            StopWatch stopWatch = StopWatch.createdStarted();
            try {
                Object object;
                if (eRevocationCheckMode.isNone()) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Certificate revocation check is disabled");
                    }
                } else {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Certificate revocation check is performed using mode " + eRevocationCheckMode);
                    }
                    object = new X509CertSelector();
                    ((X509CertSelector)object).setCertificate(this.m_aCert);
                    CommonsHashSet commonsHashSet = new CommonsHashSet(this.m_aValidCAs, x509Certificate -> new TrustAnchor((X509Certificate)x509Certificate, null));
                    PKIXBuilderParameters pKIXBuilderParameters = new PKIXBuilderParameters((Set<TrustAnchor>)commonsHashSet, (CertSelector)object);
                    pKIXBuilderParameters.setRevocationEnabled(true);
                    if (this.m_aCheckDate != null) {
                        pKIXBuilderParameters.setDate(this.m_aCheckDate);
                    }
                    IThrowingRunnable iThrowingRunnable = () -> {
                        List<CertPathValidatorException> list;
                        Object object;
                        Object object22;
                        PKIXRevocationChecker pKIXRevocationChecker;
                        ICommonsList<String> iCommonsList;
                        try {
                            boolean bl2 = eRevocationCheckMode.isOCSP();
                            if (LOGGER.isDebugEnabled()) {
                                LOGGER.debug("Setting system property 'ocsp.enable' to " + bl2);
                            }
                            Security.setProperty("ocsp.enable", Boolean.toString(bl2));
                        }
                        catch (SecurityException securityException) {
                            LOGGER.warn("Failed to set Security property 'ocsp.enable' to '" + eRevocationCheckMode.isOCSP() + "'");
                        }
                        CertStore certStore = CertStore.getInstance("Collection", new CollectionCertStoreParameters((Collection<?>)this.m_aValidCAs));
                        pKIXBuilderParameters.addCertStore(certStore);
                        if (eRevocationCheckMode.isCRL()) {
                            if (LOGGER.isDebugEnabled()) {
                                LOGGER.debug("Setting up CRL check data");
                            }
                            iCommonsList = CRLHelper.getAllDistributionPoints(this.m_aCert);
                            pKIXRevocationChecker = new CommonsArrayList();
                            for (Object object22 : iCommonsList) {
                                object = CRLHelper.getCRLFromURL((String)object22);
                                if (object == null) continue;
                                pKIXRevocationChecker.add(object);
                            }
                            if (pKIXRevocationChecker.isNotEmpty()) {
                                pKIXBuilderParameters.addCertStore(CertStore.getInstance("Collection", new CollectionCertStoreParameters((Collection<?>)((Object)pKIXRevocationChecker))));
                            }
                        }
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug("Checking certificate\n" + this.m_aCert + "\n\nagainst " + this.m_aValidCAs.size() + " valid CAs:\n" + this.m_aValidCAs);
                        }
                        iCommonsList = CertPathBuilder.getInstance("PKIX");
                        pKIXRevocationChecker = (PKIXRevocationChecker)iCommonsList.getRevocationChecker();
                        EnumSet<PKIXRevocationChecker.Option> enumSet = EnumSet.of(PKIXRevocationChecker.Option.ONLY_END_ENTITY);
                        if (bl2) {
                            enumSet.add(PKIXRevocationChecker.Option.SOFT_FAIL);
                        }
                        eRevocationCheckMode.addAllOptionsTo((Collection<? super PKIXRevocationChecker.Option>)enumSet);
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug("OCSP/CLR effective options = " + (EnumSet)enumSet);
                        }
                        pKIXRevocationChecker.setOptions((Set<PKIXRevocationChecker.Option>)enumSet);
                        object22 = (PKIXCertPathBuilderResult)iCommonsList.build((CertPathParameters)pKIXBuilderParameters);
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug("OCSP/CLR builder result = " + (PKIXCertPathBuilderResult)object22);
                        }
                        object = CertPathValidator.getInstance("PKIX");
                        PKIXCertPathValidatorResult pKIXCertPathValidatorResult = (PKIXCertPathValidatorResult)((CertPathValidator)object).validate(((PKIXCertPathBuilderResult)object22).getCertPath(), pKIXBuilderParameters);
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug("OCSP/CLR validation result = " + pKIXCertPathValidatorResult);
                        }
                        if (bl2 && !(list = pKIXRevocationChecker.getSoftFailExceptions()).isEmpty()) {
                            consumer2.accept(list);
                        }
                    };
                    if (bl) {
                        Class<CertificateRevocationChecker> clazz = CertificateRevocationChecker.class;
                        synchronized (CertificateRevocationChecker.class) {
                            iThrowingRunnable.run();
                            // ** MonitorExit[var11_15] (shouldn't be in output)
                        }
                    } else {
                        iThrowingRunnable.run();
                    }
                }
                {
                    object = ERevoked.NOT_REVOKED;
                    return object;
                }
            }
            catch (GeneralSecurityException generalSecurityException) {
                LOGGER.error("Error running certification revocation check: " + generalSecurityException.getClass().getName() + " - " + generalSecurityException.getMessage());
                consumer.accept(generalSecurityException);
                ERevoked eRevoked = ERevoked.REVOKED;
                return eRevoked;
            }
            finally {
                long l = stopWatch.stopAndGetMillis();
                if (l > this.m_nExecutionDurationWarnMS) {
                    LOGGER.warn("OCSP/CLR revocation check took " + l + " milliseconds which is too long");
                } else if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("OCSP/CLR revocation check took " + l + " milliseconds");
                }
            }
        }
    }
}

