/*
 * Decompiled with CFR 0.152.
 */
package com.helger.peppol.utils;

import java.security.cert.X509Certificate;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;

@Immutable
public final class PeppolCertificateHelper {
    private PeppolCertificateHelper() {
    }

    @Nullable
    public static String getSubjectCN(@Nullable X509Certificate x509Certificate) {
        return x509Certificate != null ? PeppolCertificateHelper.getCNOrNull(x509Certificate.getSubjectX500Principal().getName()) : null;
    }

    @Nullable
    public static String getCNOrNull(@Nullable String string) {
        try {
            return PeppolCertificateHelper.getCN(string);
        }
        catch (InvalidNameException invalidNameException) {
            return null;
        }
    }

    @Nullable
    public static String getCN(@Nullable String string) throws InvalidNameException {
        if (string != null) {
            for (Rdn rdn : new LdapName(string).getRdns()) {
                if (!rdn.getType().equalsIgnoreCase("CN")) continue;
                return (String)rdn.getValue();
            }
        }
        return null;
    }
}

