/*
 * Decompiled with CFR 0.152.
 */
package com.helger.peppol.utils;

import com.helger.commons.annotation.Nonempty;
import com.helger.commons.text.util.TextHelper;
import com.helger.security.keystore.EKeyStoreType;
import com.helger.security.keystore.IKeyStoreType;
import com.helger.security.keystore.KeyStoreHelper;
import com.helger.security.keystore.LoadedKey;
import com.helger.security.keystore.LoadedKeyStore;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.X509Certificate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public final class PeppolKeyStoreHelper {
    public static final EKeyStoreType TRUSTSTORE_TYPE = EKeyStoreType.JKS;
    public static final String TRUSTSTORE_COMPLETE_CLASSPATH = "truststore/complete-truststore.jks";
    public static final String TRUSTSTORE_PASSWORD = "peppol";
    private static final Logger LOGGER = LoggerFactory.getLogger(PeppolKeyStoreHelper.class);
    private static final PeppolKeyStoreHelper INSTANCE = new PeppolKeyStoreHelper();

    @Nullable
    private static X509Certificate _resolveCert(@Nonnull KeyStore keyStore, @Nonnull @Nonempty String string) {
        try {
            X509Certificate x509Certificate = (X509Certificate)keyStore.getCertificate(string);
            if (x509Certificate == null) {
                LOGGER.warn("Failed to resolve alias '" + string + "' in trust store");
            }
            return x509Certificate;
        }
        catch (KeyStoreException keyStoreException) {
            LOGGER.warn("Failed to resolve alias '" + string + "' in trust store.", (Throwable)keyStoreException);
            return null;
        }
    }

    private PeppolKeyStoreHelper() {
    }

    @Nullable
    public static String getLoadError(@Nonnull LoadedKeyStore loadedKeyStore) {
        return loadedKeyStore == null ? null : loadedKeyStore.getErrorText(TextHelper.EN);
    }

    @Nullable
    public static String getLoadError(@Nonnull LoadedKey<?> loadedKey) {
        return loadedKey == null ? null : loadedKey.getErrorText(TextHelper.EN);
    }

    @Immutable
    public static final class Config2018 {
        public static final String TRUSTSTORE_PRODUCTION_CLASSPATH = "truststore/2018/prod-truststore.jks";
        public static final KeyStore TRUSTSTORE_PRODUCTION = KeyStoreHelper.loadKeyStore((IKeyStoreType)TRUSTSTORE_TYPE, (String)"truststore/2018/prod-truststore.jks", (String)"peppol").getKeyStore();
        public static final String TRUSTSTORE_PRODUCTION_ALIAS_ROOT = "peppol root ca - g2";
        public static final X509Certificate CERTIFICATE_PRODUCTION_ROOT;
        public static final String TRUSTSTORE_PRODUCTION_ALIAS_AP = "peppol access point ca - g2 (peppol root ca - g2)";
        public static final X509Certificate CERTIFICATE_PRODUCTION_AP;
        public static final String TRUSTSTORE_PRODUCTION_ALIAS_SMP = "peppol service metadata publisher ca - g2 (peppol root ca - g2)";
        public static final X509Certificate CERTIFICATE_PRODUCTION_SMP;
        public static final String TRUSTSTORE_SMP_PRODUCTION_CLASSPATH = "truststore/2018/smp-prod-truststore.jks";
        public static final KeyStore TRUSTSTORE_SMP_PRODUCTION;
        public static final String TRUSTSTORE_PILOT_CLASSPATH = "truststore/2018/pilot-truststore.jks";
        public static final KeyStore TRUSTSTORE_PILOT;
        public static final String TRUSTSTORE_PILOT_ALIAS_ROOT = "peppol root test ca - g2";
        public static final X509Certificate CERTIFICATE_PILOT_ROOT;
        public static final String TRUSTSTORE_PILOT_ALIAS_AP = "peppol access point test ca - g2 (peppol root test ca - g2)";
        public static final X509Certificate CERTIFICATE_PILOT_AP;
        public static final String TRUSTSTORE_PILOT_ALIAS_SMP = "peppol service metadata publisher test ca - g2 (peppol root test ca - g2)";
        public static final X509Certificate CERTIFICATE_PILOT_SMP;
        public static final String TRUSTSTORE_SMP_PILOT_CLASSPATH = "truststore/2018/smp-pilot-truststore.jks";
        public static final KeyStore TRUSTSTORE_SMP_PILOT;

        private Config2018() {
        }

        static {
            if (TRUSTSTORE_PRODUCTION == null) {
                throw new IllegalStateException("Failed to load pre-configured production trust store");
            }
            CERTIFICATE_PRODUCTION_ROOT = PeppolKeyStoreHelper._resolveCert(TRUSTSTORE_PRODUCTION, TRUSTSTORE_PRODUCTION_ALIAS_ROOT);
            CERTIFICATE_PRODUCTION_AP = PeppolKeyStoreHelper._resolveCert(TRUSTSTORE_PRODUCTION, TRUSTSTORE_PRODUCTION_ALIAS_AP);
            CERTIFICATE_PRODUCTION_SMP = PeppolKeyStoreHelper._resolveCert(TRUSTSTORE_PRODUCTION, TRUSTSTORE_PRODUCTION_ALIAS_SMP);
            TRUSTSTORE_SMP_PRODUCTION = KeyStoreHelper.loadKeyStore((IKeyStoreType)TRUSTSTORE_TYPE, (String)TRUSTSTORE_SMP_PRODUCTION_CLASSPATH, (String)PeppolKeyStoreHelper.TRUSTSTORE_PASSWORD).getKeyStore();
            if (TRUSTSTORE_SMP_PRODUCTION == null) {
                throw new IllegalStateException("Failed to load pre-configured SMP production trust store");
            }
            TRUSTSTORE_PILOT = KeyStoreHelper.loadKeyStore((IKeyStoreType)TRUSTSTORE_TYPE, (String)TRUSTSTORE_PILOT_CLASSPATH, (String)PeppolKeyStoreHelper.TRUSTSTORE_PASSWORD).getKeyStore();
            if (TRUSTSTORE_PILOT == null) {
                throw new IllegalStateException("Failed to load pre-configured pilot trust store");
            }
            CERTIFICATE_PILOT_ROOT = PeppolKeyStoreHelper._resolveCert(TRUSTSTORE_PILOT, TRUSTSTORE_PILOT_ALIAS_ROOT);
            CERTIFICATE_PILOT_AP = PeppolKeyStoreHelper._resolveCert(TRUSTSTORE_PILOT, TRUSTSTORE_PILOT_ALIAS_AP);
            CERTIFICATE_PILOT_SMP = PeppolKeyStoreHelper._resolveCert(TRUSTSTORE_PILOT, TRUSTSTORE_PILOT_ALIAS_SMP);
            TRUSTSTORE_SMP_PILOT = KeyStoreHelper.loadKeyStore((IKeyStoreType)TRUSTSTORE_TYPE, (String)TRUSTSTORE_SMP_PILOT_CLASSPATH, (String)PeppolKeyStoreHelper.TRUSTSTORE_PASSWORD).getKeyStore();
            if (TRUSTSTORE_SMP_PILOT == null) {
                throw new IllegalStateException("Failed to load pre-configured SMP pilot trust store");
            }
        }
    }
}

