/*
 * Decompiled with CFR 0.152.
 */
package com.helger.smpclient.bdxr1;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.http.basicauth.BasicAuthClientCredentials;
import com.helger.peppol.sml.ISMLInfo;
import com.helger.peppolid.CIdentifier;
import com.helger.peppolid.IDocumentTypeIdentifier;
import com.helger.peppolid.IParticipantIdentifier;
import com.helger.peppolid.bdxr.smp1.participant.BDXR1ParticipantIdentifier;
import com.helger.smpclient.bdxr1.BDXRClientReadOnly;
import com.helger.smpclient.bdxr1.marshal.BDXR1MarshallerServiceGroupType;
import com.helger.smpclient.bdxr1.marshal.BDXR1MarshallerServiceMetadataType;
import com.helger.smpclient.exception.SMPClientException;
import com.helger.smpclient.httpclient.SMPHttpResponseHandlerWriteOperations;
import com.helger.smpclient.url.ISMPURLProvider;
import com.helger.smpclient.url.SMPDNSResolutionException;
import com.helger.xsds.bdxr.smp1.DocumentIdentifierType;
import com.helger.xsds.bdxr.smp1.ParticipantIdentifierType;
import com.helger.xsds.bdxr.smp1.RedirectType;
import com.helger.xsds.bdxr.smp1.ServiceGroupType;
import com.helger.xsds.bdxr.smp1.ServiceInformationType;
import com.helger.xsds.bdxr.smp1.ServiceMetadataReferenceCollectionType;
import com.helger.xsds.bdxr.smp1.ServiceMetadataType;
import java.net.URI;
import javax.annotation.Nonnull;
import org.apache.hc.client5.http.classic.methods.HttpDelete;
import org.apache.hc.client5.http.classic.methods.HttpPut;
import org.apache.hc.client5.http.classic.methods.HttpUriRequestBase;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BDXRClient
extends BDXRClientReadOnly {
    private static final Logger LOGGER = LoggerFactory.getLogger(BDXRClient.class);

    public BDXRClient(@Nonnull ISMPURLProvider iSMPURLProvider, @Nonnull IParticipantIdentifier iParticipantIdentifier, @Nonnull ISMLInfo iSMLInfo) throws SMPDNSResolutionException {
        super(iSMPURLProvider, iParticipantIdentifier, iSMLInfo);
    }

    public BDXRClient(@Nonnull ISMPURLProvider iSMPURLProvider, @Nonnull IParticipantIdentifier iParticipantIdentifier, @Nonnull @Nonempty String string) throws SMPDNSResolutionException {
        super(iSMPURLProvider, iParticipantIdentifier, string);
    }

    public BDXRClient(@Nonnull URI uRI) {
        super(uRI);
    }

    public void saveServiceGroup(@Nonnull ServiceGroupType serviceGroupType, @Nonnull BasicAuthClientCredentials basicAuthClientCredentials) throws SMPClientException {
        ValueEnforcer.notNull((Object)serviceGroupType, (String)"ServiceGroup");
        ValueEnforcer.notNull((Object)basicAuthClientCredentials, (String)"Credentials");
        String string = new BDXR1MarshallerServiceGroupType().setUseSchema(this.isXMLSchemaValidation()).getAsString((Object)serviceGroupType);
        if (string == null) {
            throw new IllegalArgumentException("Failed to serialize ServiceGroup: " + serviceGroupType);
        }
        String string2 = this.getSMPHostURI() + CIdentifier.getURIPercentEncoded((ParticipantIdentifierType)serviceGroupType.getParticipantIdentifier());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("BDXRClient saveServiceGroup@" + string2);
        }
        HttpPut httpPut = new HttpPut(string2);
        httpPut.addHeader("Authorization", (Object)basicAuthClientCredentials.getRequestValue());
        httpPut.setEntity((HttpEntity)new StringEntity(string, CONTENT_TYPE_TEXT_XML));
        this.executeGenericRequest((HttpUriRequestBase)httpPut, new SMPHttpResponseHandlerWriteOperations());
    }

    @Nonnull
    public ServiceGroupType saveServiceGroup(@Nonnull IParticipantIdentifier iParticipantIdentifier, @Nonnull BasicAuthClientCredentials basicAuthClientCredentials) throws SMPClientException {
        ValueEnforcer.notNull((Object)iParticipantIdentifier, (String)"ParticipantID");
        ValueEnforcer.notNull((Object)basicAuthClientCredentials, (String)"Credentials");
        ServiceGroupType serviceGroupType = new ServiceGroupType();
        serviceGroupType.setParticipantIdentifier((ParticipantIdentifierType)new BDXR1ParticipantIdentifier(iParticipantIdentifier));
        serviceGroupType.setServiceMetadataReferenceCollection(new ServiceMetadataReferenceCollectionType());
        this.saveServiceGroup(serviceGroupType, basicAuthClientCredentials);
        return serviceGroupType;
    }

    public void deleteServiceGroup(@Nonnull IParticipantIdentifier iParticipantIdentifier, @Nonnull BasicAuthClientCredentials basicAuthClientCredentials) throws SMPClientException {
        ValueEnforcer.notNull((Object)basicAuthClientCredentials, (String)"Credentials");
        String string = this.getSMPHostURI() + iParticipantIdentifier.getURIPercentEncoded();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("BDXRClient deleteServiceGroup@" + string);
        }
        HttpDelete httpDelete = new HttpDelete(string);
        httpDelete.addHeader("Authorization", (Object)basicAuthClientCredentials.getRequestValue());
        this.executeGenericRequest((HttpUriRequestBase)httpDelete, new SMPHttpResponseHandlerWriteOperations());
    }

    private void _saveServiceInformation(@Nonnull ParticipantIdentifierType participantIdentifierType, @Nonnull DocumentIdentifierType documentIdentifierType, @Nonnull ServiceMetadataType serviceMetadataType, @Nonnull BasicAuthClientCredentials basicAuthClientCredentials) throws SMPClientException {
        String string = new BDXR1MarshallerServiceMetadataType().setUseSchema(this.isXMLSchemaValidation()).getAsString((Object)serviceMetadataType);
        if (string == null) {
            throw new IllegalArgumentException("Failed to serialize ServiceMetadata: " + serviceMetadataType);
        }
        String string2 = this.getSMPHostURI() + CIdentifier.getURIPercentEncoded((ParticipantIdentifierType)participantIdentifierType) + "/services/" + CIdentifier.getURIPercentEncoded((DocumentIdentifierType)documentIdentifierType);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("BDXRClient saveServiceRegistration@" + string2);
        }
        HttpPut httpPut = new HttpPut(string2);
        httpPut.addHeader("Authorization", (Object)basicAuthClientCredentials.getRequestValue());
        httpPut.setEntity((HttpEntity)new StringEntity(string, CONTENT_TYPE_TEXT_XML));
        this.executeGenericRequest((HttpUriRequestBase)httpPut, new SMPHttpResponseHandlerWriteOperations());
    }

    public void saveServiceInformation(@Nonnull ServiceInformationType serviceInformationType, @Nonnull BasicAuthClientCredentials basicAuthClientCredentials) throws SMPClientException {
        ValueEnforcer.notNull((Object)serviceInformationType, (String)"ServiceMetadata.ServiceInformation");
        ValueEnforcer.notNull((Object)serviceInformationType.getParticipantIdentifier(), (String)"ServiceMetadata.ServiceInformation.ParticipantIdentifier");
        ValueEnforcer.notNull((Object)serviceInformationType.getDocumentIdentifier(), (String)"ServiceMetadata.ServiceInformation.DocumentIdentifier");
        ValueEnforcer.notNull((Object)basicAuthClientCredentials, (String)"Credentials");
        ServiceMetadataType serviceMetadataType = new ServiceMetadataType();
        serviceMetadataType.setServiceInformation(serviceInformationType);
        this._saveServiceInformation(serviceInformationType.getParticipantIdentifier(), serviceInformationType.getDocumentIdentifier(), serviceMetadataType, basicAuthClientCredentials);
    }

    public void saveServiceRedirect(@Nonnull ParticipantIdentifierType participantIdentifierType, @Nonnull DocumentIdentifierType documentIdentifierType, @Nonnull RedirectType redirectType, @Nonnull BasicAuthClientCredentials basicAuthClientCredentials) throws SMPClientException {
        ValueEnforcer.notNull((Object)participantIdentifierType, (String)"ServiceGroupID");
        ValueEnforcer.notNull((Object)documentIdentifierType, (String)"DocumentTypeID");
        ValueEnforcer.notNull((Object)redirectType, (String)"Redirect");
        ValueEnforcer.notNull((Object)basicAuthClientCredentials, (String)"Credentials");
        ServiceMetadataType serviceMetadataType = new ServiceMetadataType();
        serviceMetadataType.setRedirect(redirectType);
        this._saveServiceInformation(participantIdentifierType, documentIdentifierType, serviceMetadataType, basicAuthClientCredentials);
    }

    public void deleteServiceRegistration(@Nonnull IParticipantIdentifier iParticipantIdentifier, @Nonnull IDocumentTypeIdentifier iDocumentTypeIdentifier, @Nonnull BasicAuthClientCredentials basicAuthClientCredentials) throws SMPClientException {
        ValueEnforcer.notNull((Object)iParticipantIdentifier, (String)"ServiceGroupID");
        ValueEnforcer.notNull((Object)iDocumentTypeIdentifier, (String)"DocumentTypeID");
        ValueEnforcer.notNull((Object)basicAuthClientCredentials, (String)"Credentials");
        String string = this.getSMPHostURI() + iParticipantIdentifier.getURIPercentEncoded() + "/services/" + iDocumentTypeIdentifier.getURIPercentEncoded();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("BDXRClient deleteServiceRegistration@" + string);
        }
        HttpDelete httpDelete = new HttpDelete(string);
        httpDelete.addHeader("Authorization", (Object)basicAuthClientCredentials.getRequestValue());
        this.executeGenericRequest((HttpUriRequestBase)httpDelete, new SMPHttpResponseHandlerWriteOperations());
    }
}

