/*
 * Decompiled with CFR 0.152.
 */
package com.helger.smpclient.httpclient;

import com.helger.smpclient.exception.SMPClientBadResponseException;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.hc.client5.http.ClientProtocolException;
import org.apache.hc.client5.http.HttpResponseException;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.HttpClientResponseHandler;

public abstract class AbstractSMPResponseHandler<T>
implements HttpClientResponseHandler<T> {
    @Nullable
    public abstract T handleEntity(@Nonnull HttpEntity var1) throws IOException, SMPClientBadResponseException;

    @Nullable
    public T handleResponse(@Nonnull ClassicHttpResponse classicHttpResponse) throws IOException {
        HttpEntity httpEntity = classicHttpResponse.getEntity();
        if (classicHttpResponse.getCode() >= 300) {
            throw new HttpResponseException(classicHttpResponse.getCode(), classicHttpResponse.getReasonPhrase());
        }
        try {
            return httpEntity == null ? null : (T)this.handleEntity(httpEntity);
        }
        catch (SMPClientBadResponseException sMPClientBadResponseException) {
            throw new ClientProtocolException((Throwable)sMPClientBadResponseException);
        }
    }
}

