/*
 * Decompiled with CFR 0.152.
 */
package com.helger.smpclient.peppol;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.CommonsHashSet;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.datetime.PDTFactory;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.state.EContinue;
import com.helger.commons.string.StringHelper;
import com.helger.commons.wrapper.Wrapper;
import com.helger.http.basicauth.BasicAuthClientCredentials;
import com.helger.jaxb.GenericJAXBMarshaller;
import com.helger.peppol.sml.ISMLInfo;
import com.helger.peppol.smp.ISMPTransportProfile;
import com.helger.peppolid.CIdentifier;
import com.helger.peppolid.IDocumentTypeIdentifier;
import com.helger.peppolid.IParticipantIdentifier;
import com.helger.peppolid.IProcessIdentifier;
import com.helger.peppolid.factory.IIdentifierFactory;
import com.helger.peppolid.factory.PeppolIdentifierFactory;
import com.helger.peppolid.peppol.doctype.IPeppolDocumentTypeIdentifierParts;
import com.helger.peppolid.peppol.doctype.PeppolDocumentTypeIdentifierParts;
import com.helger.security.certificate.CertificateHelper;
import com.helger.smpclient.exception.SMPClientException;
import com.helger.smpclient.exception.SMPClientNotFoundException;
import com.helger.smpclient.httpclient.AbstractGenericSMPClient;
import com.helger.smpclient.httpclient.SMPHttpResponseHandlerSigned;
import com.helger.smpclient.httpclient.SMPHttpResponseHandlerUnsigned;
import com.helger.smpclient.peppol.ISMPServiceGroupProvider;
import com.helger.smpclient.peppol.ISMPServiceMetadataProvider;
import com.helger.smpclient.peppol.marshal.SMPMarshallerCompleteServiceGroupType;
import com.helger.smpclient.peppol.marshal.SMPMarshallerServiceGroupReferenceListType;
import com.helger.smpclient.peppol.marshal.SMPMarshallerServiceGroupType;
import com.helger.smpclient.peppol.marshal.SMPMarshallerSignedServiceMetadataType;
import com.helger.smpclient.peppol.utils.W3CEndpointReferenceHelper;
import com.helger.smpclient.url.ISMPURLProvider;
import com.helger.smpclient.url.SMPDNSResolutionException;
import com.helger.xsds.peppol.id1.ParticipantIdentifierType;
import com.helger.xsds.peppol.id1.ProcessIdentifierType;
import com.helger.xsds.peppol.smp1.CompleteServiceGroupType;
import com.helger.xsds.peppol.smp1.EndpointType;
import com.helger.xsds.peppol.smp1.ProcessType;
import com.helger.xsds.peppol.smp1.ServiceGroupReferenceListType;
import com.helger.xsds.peppol.smp1.ServiceGroupType;
import com.helger.xsds.peppol.smp1.ServiceInformationType;
import com.helger.xsds.peppol.smp1.ServiceMetadataReferenceType;
import com.helger.xsds.peppol.smp1.ServiceMetadataType;
import com.helger.xsds.peppol.smp1.SignedServiceMetadataType;
import com.helger.xsds.xmldsig.X509DataType;
import jakarta.xml.bind.JAXBElement;
import java.net.URI;
import java.security.KeyStore;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.time.LocalDateTime;
import java.util.Locale;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpUriRequestBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SMPClientReadOnly
extends AbstractGenericSMPClient<SMPClientReadOnly>
implements ISMPServiceGroupProvider,
ISMPServiceMetadataProvider {
    public static final String URL_PART_COMPLETE = "complete";
    public static final String URL_PART_LIST = "list";
    public static final String URL_PART_SERVICES = "services";
    private static final Logger LOGGER = LoggerFactory.getLogger(SMPClientReadOnly.class);

    public SMPClientReadOnly(@Nonnull ISMPURLProvider iSMPURLProvider, @Nonnull IParticipantIdentifier iParticipantIdentifier, @Nonnull ISMLInfo iSMLInfo) throws SMPDNSResolutionException {
        this(iSMPURLProvider.getSMPURIOfParticipant(iParticipantIdentifier, iSMLInfo));
    }

    public SMPClientReadOnly(@Nonnull ISMPURLProvider iSMPURLProvider, @Nonnull IParticipantIdentifier iParticipantIdentifier, @Nonnull @Nonempty String string) throws SMPDNSResolutionException {
        this(iSMPURLProvider.getSMPURIOfParticipant(iParticipantIdentifier, string));
    }

    public SMPClientReadOnly(@Nonnull URI uRI) {
        super(uRI, true);
    }

    @Nonnull
    public ServiceGroupReferenceListType getServiceGroupReferenceList(@Nonnull String string, @Nonnull BasicAuthClientCredentials basicAuthClientCredentials) throws SMPClientException {
        ValueEnforcer.notNull((Object)string, (String)"UserID");
        ValueEnforcer.notNull((Object)basicAuthClientCredentials, (String)"Credentials");
        String string2 = this.getSMPHostURI() + "list/" + CIdentifier.createPercentEncoded((String)string);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("SMPClient getServiceGroupReferenceList@" + string2);
        }
        HttpGet httpGet = new HttpGet(string2);
        httpGet.addHeader("Authorization", (Object)basicAuthClientCredentials.getRequestValue());
        SMPMarshallerServiceGroupReferenceListType sMPMarshallerServiceGroupReferenceListType = new SMPMarshallerServiceGroupReferenceListType();
        sMPMarshallerServiceGroupReferenceListType.setUseSchema(this.isXMLSchemaValidation());
        this.customizeMarshaller(sMPMarshallerServiceGroupReferenceListType);
        return this.executeGenericRequest((HttpUriRequestBase)httpGet, new SMPHttpResponseHandlerUnsigned<ServiceGroupReferenceListType>(sMPMarshallerServiceGroupReferenceListType));
    }

    @Nullable
    public ServiceGroupReferenceListType getServiceGroupReferenceListOrNull(@Nonnull String string, @Nonnull BasicAuthClientCredentials basicAuthClientCredentials) throws SMPClientException {
        try {
            return this.getServiceGroupReferenceList(string, basicAuthClientCredentials);
        }
        catch (SMPClientNotFoundException sMPClientNotFoundException) {
            return null;
        }
    }

    @Nonnull
    public CompleteServiceGroupType getCompleteServiceGroup(@Nonnull String string) throws SMPClientException {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"CompleteURL");
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("SMPClient getCompleteServiceGroup@" + string);
        }
        HttpGet httpGet = new HttpGet(string);
        SMPMarshallerCompleteServiceGroupType sMPMarshallerCompleteServiceGroupType = new SMPMarshallerCompleteServiceGroupType();
        sMPMarshallerCompleteServiceGroupType.setUseSchema(this.isXMLSchemaValidation());
        this.customizeMarshaller(sMPMarshallerCompleteServiceGroupType);
        return this.executeGenericRequest((HttpUriRequestBase)httpGet, new SMPHttpResponseHandlerUnsigned<CompleteServiceGroupType>(sMPMarshallerCompleteServiceGroupType));
    }

    @Nonnull
    public CompleteServiceGroupType getCompleteServiceGroup(@Nonnull IParticipantIdentifier iParticipantIdentifier) throws SMPClientException {
        ValueEnforcer.notNull((Object)iParticipantIdentifier, (String)"ServiceGroupID");
        return this.getCompleteServiceGroup(this.getSMPHostURI() + "complete/" + iParticipantIdentifier.getURIPercentEncoded());
    }

    @Nullable
    public CompleteServiceGroupType getCompleteServiceGroupOrNull(@Nonnull IParticipantIdentifier iParticipantIdentifier) throws SMPClientException {
        try {
            return this.getCompleteServiceGroup(iParticipantIdentifier);
        }
        catch (SMPClientNotFoundException sMPClientNotFoundException) {
            return null;
        }
    }

    @Nonnull
    public ServiceGroupType getServiceGroup(@Nonnull IParticipantIdentifier iParticipantIdentifier) throws SMPClientException {
        ValueEnforcer.notNull((Object)iParticipantIdentifier, (String)"ServiceGroupID");
        String string = this.getSMPHostURI() + iParticipantIdentifier.getURIPercentEncoded();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("SMPClient getServiceGroup@" + string);
        }
        HttpGet httpGet = new HttpGet(string);
        SMPMarshallerServiceGroupType sMPMarshallerServiceGroupType = new SMPMarshallerServiceGroupType();
        sMPMarshallerServiceGroupType.setUseSchema(this.isXMLSchemaValidation());
        this.customizeMarshaller(sMPMarshallerServiceGroupType);
        ServiceGroupType serviceGroupType = this.executeGenericRequest((HttpUriRequestBase)httpGet, new SMPHttpResponseHandlerUnsigned<ServiceGroupType>(sMPMarshallerServiceGroupType));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Received response: " + serviceGroupType);
        }
        return serviceGroupType;
    }

    @Override
    @Nullable
    public ServiceGroupType getServiceGroupOrNull(@Nonnull IParticipantIdentifier iParticipantIdentifier) throws SMPClientException {
        try {
            return this.getServiceGroup(iParticipantIdentifier);
        }
        catch (SMPClientNotFoundException sMPClientNotFoundException) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Found no ServiceGroup");
            }
            return null;
        }
    }

    @Nonnull
    public static ICommonsList<IDocumentTypeIdentifier> getAllDocumentTypes(@Nullable ServiceGroupType serviceGroupType) {
        return SMPClientReadOnly.getAllDocumentTypes(serviceGroupType, (IIdentifierFactory)PeppolIdentifierFactory.INSTANCE, null);
    }

    @Nonnull
    public static ICommonsList<IDocumentTypeIdentifier> getAllDocumentTypes(@Nullable ServiceGroupType serviceGroupType, @Nonnull IIdentifierFactory iIdentifierFactory, @Nullable Consumer<String> consumer) {
        ValueEnforcer.notNull((Object)iIdentifierFactory, (String)"IdentifierFactory");
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        if (serviceGroupType != null && serviceGroupType.getParticipantIdentifier() != null && serviceGroupType.getServiceMetadataReferenceCollection() != null) {
            String string = "/" + CIdentifier.getURIEncoded((ParticipantIdentifierType)serviceGroupType.getParticipantIdentifier()) + "/services/";
            for (ServiceMetadataReferenceType serviceMetadataReferenceType : serviceGroupType.getServiceMetadataReferenceCollection().getServiceMetadataReference()) {
                String string2;
                IDocumentTypeIdentifier iDocumentTypeIdentifier;
                String string3 = serviceMetadataReferenceType.getHref();
                String string4 = CIdentifier.createPercentDecoded((String)string3);
                boolean bl = false;
                int n = StringHelper.getIndexOfIgnoreCase((String)string4, (String)string, (Locale)Locale.US);
                if (n >= 0 && (iDocumentTypeIdentifier = iIdentifierFactory.parseDocumentTypeIdentifier(string2 = string4.substring(n + string.length()))) != null) {
                    commonsArrayList.add((Object)iDocumentTypeIdentifier);
                    bl = true;
                }
                if (bl) continue;
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Failed to parse '" + string3 + "' as a document type identifier");
                }
                if (consumer == null) continue;
                consumer.accept(string3);
            }
        }
        return commonsArrayList;
    }

    @Nonnull
    public SignedServiceMetadataType getServiceMetadata(@Nonnull IParticipantIdentifier iParticipantIdentifier, @Nonnull IDocumentTypeIdentifier iDocumentTypeIdentifier) throws SMPClientException {
        ValueEnforcer.notNull((Object)iParticipantIdentifier, (String)"ServiceGroupID");
        ValueEnforcer.notNull((Object)iDocumentTypeIdentifier, (String)"DocumentTypeID");
        String string = this.getSMPHostURI() + iParticipantIdentifier.getURIPercentEncoded() + "/services/" + iDocumentTypeIdentifier.getURIPercentEncoded();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("SMPClient getServiceRegistration@" + string);
        }
        boolean bl = this.isXMLSchemaValidation();
        boolean bl2 = this.isVerifySignature();
        boolean bl3 = this.isSecureValidation();
        KeyStore keyStore = this.getTrustStore();
        if (bl2 && keyStore == null) {
            LOGGER.error("Peppol SMP client Verify Signature is enabled, but no TrustStore is provided. This will not work.");
        }
        HttpGet httpGet = new HttpGet(string);
        SMPMarshallerSignedServiceMetadataType sMPMarshallerSignedServiceMetadataType = new SMPMarshallerSignedServiceMetadataType();
        sMPMarshallerSignedServiceMetadataType.setUseSchema(bl);
        this.customizeMarshaller(sMPMarshallerSignedServiceMetadataType);
        Object object = new SMPHttpResponseHandlerSigned<SignedServiceMetadataType>(sMPMarshallerSignedServiceMetadataType, keyStore);
        object.setVerifySignature(bl2);
        object.setSecureValidation(bl3);
        SignedServiceMetadataType signedServiceMetadataType = this.executeGenericRequest((HttpUriRequestBase)httpGet, object);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Received response: " + signedServiceMetadataType);
        }
        if (this.isFollowSMPRedirects()) {
            if (signedServiceMetadataType.getServiceMetadata() != null && signedServiceMetadataType.getServiceMetadata().getRedirect() != null) {
                httpGet = signedServiceMetadataType.getServiceMetadata().getRedirect();
                LOGGER.info("Following a redirect from '" + string + "' to '" + httpGet.getHref() + "'");
                sMPMarshallerSignedServiceMetadataType = new HttpGet(httpGet.getHref());
                object = new SMPMarshallerSignedServiceMetadataType();
                object.setUseSchema(bl);
                this.customizeMarshaller((GenericJAXBMarshaller<?>)object);
                SMPHttpResponseHandlerSigned<SignedServiceMetadataType> sMPHttpResponseHandlerSigned = new SMPHttpResponseHandlerSigned<SignedServiceMetadataType>((GenericJAXBMarshaller<SignedServiceMetadataType>)object, keyStore);
                sMPHttpResponseHandlerSigned.setVerifySignature(bl2);
                sMPHttpResponseHandlerSigned.setSecureValidation(bl3);
                signedServiceMetadataType = this.executeGenericRequest((HttpUriRequestBase)sMPMarshallerSignedServiceMetadataType, sMPHttpResponseHandlerSigned);
                boolean bl4 = false;
                for (Object e : signedServiceMetadataType.getSignature().getKeyInfo().getContent()) {
                    X509DataType x509DataType;
                    Object object2;
                    if (!(e instanceof JAXBElement) || !((object2 = ((JAXBElement)e).getValue()) instanceof X509DataType) || !SMPClientReadOnly.containsRedirectSubject(x509DataType = (X509DataType)object2, httpGet.getCertificateUID())) continue;
                    bl4 = true;
                    break;
                }
                if (!bl4) {
                    throw new SMPClientException("The X509 certificate did not contain a certificate subject.");
                }
            }
        } else if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Following SMP redirects is disabled");
        }
        return signedServiceMetadataType;
    }

    @Override
    @Nullable
    public SignedServiceMetadataType getServiceMetadataOrNull(@Nonnull IParticipantIdentifier iParticipantIdentifier, @Nonnull IDocumentTypeIdentifier iDocumentTypeIdentifier) throws SMPClientException {
        try {
            return this.getServiceMetadata(iParticipantIdentifier, iDocumentTypeIdentifier);
        }
        catch (SMPClientNotFoundException sMPClientNotFoundException) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Found no ServiceMetadata");
            }
            return null;
        }
    }

    private static boolean _hasSameContent(@Nonnull ProcessIdentifierType processIdentifierType, @Nonnull IProcessIdentifier iProcessIdentifier) {
        return EqualsHelper.equals((Object)processIdentifierType.getScheme(), (Object)iProcessIdentifier.getScheme()) && EqualsHelper.equals((Object)processIdentifierType.getValue(), (Object)iProcessIdentifier.getValue());
    }

    @Nullable
    public static EndpointType getEndpoint(@Nonnull SignedServiceMetadataType signedServiceMetadataType, @Nonnull IProcessIdentifier iProcessIdentifier, @Nonnull ISMPTransportProfile iSMPTransportProfile) {
        ValueEnforcer.notNull((Object)signedServiceMetadataType, (String)"SignedServiceMetadata");
        return SMPClientReadOnly.getEndpoint(signedServiceMetadataType.getServiceMetadata(), iProcessIdentifier, iSMPTransportProfile);
    }

    @Nullable
    public static EndpointType getEndpointAt(@Nonnull SignedServiceMetadataType signedServiceMetadataType, @Nonnull IProcessIdentifier iProcessIdentifier, @Nonnull ISMPTransportProfile iSMPTransportProfile, @Nonnull LocalDateTime localDateTime) {
        ValueEnforcer.notNull((Object)signedServiceMetadataType, (String)"SignedServiceMetadata");
        return SMPClientReadOnly.getEndpointAt(signedServiceMetadataType.getServiceMetadata(), iProcessIdentifier, iSMPTransportProfile, localDateTime);
    }

    @Nullable
    public static EndpointType getEndpoint(@Nonnull ServiceMetadataType serviceMetadataType, @Nonnull IProcessIdentifier iProcessIdentifier, @Nonnull ISMPTransportProfile iSMPTransportProfile) {
        return SMPClientReadOnly.getEndpointAt(serviceMetadataType, iProcessIdentifier, iSMPTransportProfile, PDTFactory.getCurrentLocalDateTime());
    }

    public static boolean isEndpointValidAt(@Nonnull EndpointType endpointType, @Nonnull LocalDateTime localDateTime) {
        ValueEnforcer.notNull((Object)endpointType, (String)"Endpoint");
        ValueEnforcer.notNull((Object)localDateTime, (String)"CheckDT");
        LocalDateTime localDateTime2 = endpointType.getServiceActivationDateLocal();
        if (localDateTime2 != null && localDateTime.isBefore(localDateTime2)) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("SMP endpoint activation date " + localDateTime2 + " is after the check DT " + localDateTime);
            }
            return false;
        }
        LocalDateTime localDateTime3 = endpointType.getServiceExpirationDateLocal();
        if (localDateTime3 != null && localDateTime.isAfter(localDateTime3)) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("SMP endpoint expiration date " + localDateTime3 + " is before the check DT " + localDateTime);
            }
            return false;
        }
        return true;
    }

    @Nullable
    public static EndpointType getEndpointAt(@Nonnull ServiceMetadataType serviceMetadataType, @Nonnull IProcessIdentifier iProcessIdentifier, @Nonnull ISMPTransportProfile iSMPTransportProfile, @Nonnull LocalDateTime localDateTime) {
        ValueEnforcer.notNull((Object)serviceMetadataType, (String)"ServiceMetadata");
        ServiceInformationType serviceInformationType = serviceMetadataType.getServiceInformation();
        if (serviceInformationType == null) {
            return null;
        }
        ValueEnforcer.notNull((Object)serviceInformationType.getProcessList(), (String)"ServiceMetadata.ServiceInformation.ProcessList");
        ValueEnforcer.notNull((Object)iProcessIdentifier, (String)"ProcessID");
        ValueEnforcer.notNull((Object)iSMPTransportProfile, (String)"TransportProfile");
        ValueEnforcer.notNull((Object)localDateTime, (String)"CheckDT");
        CommonsHashSet commonsHashSet = new CommonsHashSet();
        for (ProcessType processType : serviceInformationType.getProcessList().getProcess()) {
            String string = CIdentifier.getURIEncoded((ProcessIdentifierType)processType.getProcessIdentifier());
            if (!commonsHashSet.add((Object)string)) {
                LOGGER.warn("The Process ID '" + string + "' is contained more then once within a ServiceMetadataType");
            }
            if (!SMPClientReadOnly._hasSameContent(processType.getProcessIdentifier(), iProcessIdentifier)) continue;
            CommonsArrayList commonsArrayList = new CommonsArrayList();
            CommonsHashSet commonsHashSet2 = new CommonsHashSet();
            for (EndpointType endpointType : processType.getServiceEndpointList().getEndpoint()) {
                String string2 = endpointType.getTransportProfile();
                if (!commonsHashSet2.add((Object)string2)) {
                    LOGGER.warn("The Transport Profile '" + string2 + "' is contained more then once within the Process '" + string + "'");
                }
                if (!iSMPTransportProfile.getID().equals(string2) || !SMPClientReadOnly.isEndpointValidAt(endpointType, localDateTime)) continue;
                commonsArrayList.add((Object)endpointType);
            }
            if (commonsArrayList.size() != 1) {
                LOGGER.warn("Found " + commonsArrayList.size() + " endpoints for process " + iProcessIdentifier + " and transport profile '" + iSMPTransportProfile.getID() + "' valid at " + localDateTime + (String)(commonsArrayList.isEmpty() ? "" : ": " + commonsArrayList.toString() + " - using the first one"));
            }
            EndpointType endpointType = (EndpointType)commonsArrayList.getFirst();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Found matching SMP endpoint: " + endpointType);
            }
            return endpointType;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Found no matching SMP endpoint");
        }
        return null;
    }

    @Nullable
    public static String getEndpointAddress(@Nullable EndpointType endpointType) {
        return endpointType == null || endpointType.getEndpointReference() == null ? null : W3CEndpointReferenceHelper.getAddress(endpointType.getEndpointReference());
    }

    @Nullable
    public static String getEndpointCertificateString(@Nullable EndpointType endpointType) {
        return endpointType == null ? null : endpointType.getCertificate();
    }

    @Nullable
    public static X509Certificate getEndpointCertificate(@Nullable EndpointType endpointType) throws CertificateException {
        String string = SMPClientReadOnly.getEndpointCertificateString(endpointType);
        return CertificateHelper.convertStringToCertficate((String)string);
    }

    public static void forEachMatchingWildcardDocumentType(@Nonnull ICommonsList<? extends IDocumentTypeIdentifier> iCommonsList, @Nonnull @Nonempty String string3, @Nonnull Function<? super IDocumentTypeIdentifier, EContinue> function) {
        ValueEnforcer.notNull(iCommonsList, (String)"BaseDocTypes");
        ValueEnforcer.notEmpty((CharSequence)string3, (String)"DocTypeValue");
        ValueEnforcer.notNull(function, (String)"MatchingDocTypeConsumer");
        BiFunction<String, String, IDocumentTypeIdentifier> biFunction = (string, string2) -> {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Checking if document type ID '" + CIdentifier.getURIEncoded((String)string, (String)string2) + "' is contained");
            }
            if (iCommonsList.containsAny(iDocumentTypeIdentifier -> iDocumentTypeIdentifier.hasScheme(string) && iDocumentTypeIdentifier.hasValue(string2))) {
                return PeppolIdentifierFactory.INSTANCE.createDocumentTypeIdentifier(string, string2);
            }
            return null;
        };
        IDocumentTypeIdentifier iDocumentTypeIdentifier = biFunction.apply("busdox-docid-qns", string3);
        if (iDocumentTypeIdentifier != null && function.apply((IDocumentTypeIdentifier)iDocumentTypeIdentifier).isBreak()) {
            return;
        }
        try {
            IPeppolDocumentTypeIdentifierParts iPeppolDocumentTypeIdentifierParts = PeppolDocumentTypeIdentifierParts.extractFromString((String)string3);
            Function<String, String> function2 = string -> new PeppolDocumentTypeIdentifierParts(iPeppolDocumentTypeIdentifierParts.getRootNS(), iPeppolDocumentTypeIdentifierParts.getLocalName(), string, iPeppolDocumentTypeIdentifierParts.getVersion()).getAsDocumentTypeIdentifierValue();
            String string4 = iPeppolDocumentTypeIdentifierParts.getCustomizationID();
            iDocumentTypeIdentifier = biFunction.apply("peppol-doctype-wildcard", function2.apply(string4 + "*"));
            if (iDocumentTypeIdentifier != null && function.apply((IDocumentTypeIdentifier)iDocumentTypeIdentifier).isBreak()) {
                return;
            }
            while (string4.indexOf(64) >= 0) {
                iDocumentTypeIdentifier = biFunction.apply("peppol-doctype-wildcard", function2.apply((string4 = string4.substring(0, string4.lastIndexOf(64))) + "*"));
                if (iDocumentTypeIdentifier == null || !function.apply((IDocumentTypeIdentifier)iDocumentTypeIdentifier).isBreak()) continue;
                return;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            LOGGER.error("Failed to split document type ID into pieces: " + illegalArgumentException.getMessage());
        }
    }

    @Nullable
    public SignedServiceMetadataType getWildcardServiceMetadataOrNull(@Nonnull IParticipantIdentifier iParticipantIdentifier, @Nonnull IDocumentTypeIdentifier iDocumentTypeIdentifier2) throws SMPClientException {
        SignedServiceMetadataType signedServiceMetadataType;
        ValueEnforcer.notNull((Object)iParticipantIdentifier, (String)"ReceiverID");
        ValueEnforcer.notNull((Object)iDocumentTypeIdentifier2, (String)"DocTypeID");
        LOGGER.info("Using SMP wildcard lookup for '" + iParticipantIdentifier.getURIEncoded() + "' on '" + iDocumentTypeIdentifier2.getURIEncoded() + "'");
        ServiceGroupType serviceGroupType = this.getServiceGroupOrNull(iParticipantIdentifier);
        if (serviceGroupType == null) {
            signedServiceMetadataType = null;
        } else {
            ICommonsList<IDocumentTypeIdentifier> iCommonsList = SMPClientReadOnly.getAllDocumentTypes(serviceGroupType);
            LOGGER.info("Found " + iCommonsList.size() + " supported document types for '" + iParticipantIdentifier.getURIEncoded() + "'");
            Wrapper wrapper = new Wrapper();
            SMPClientReadOnly.forEachMatchingWildcardDocumentType(iCommonsList, iDocumentTypeIdentifier2.getValue(), iDocumentTypeIdentifier -> {
                wrapper.set(iDocumentTypeIdentifier);
                return EContinue.BREAK;
            });
            IDocumentTypeIdentifier iDocumentTypeIdentifier3 = (IDocumentTypeIdentifier)wrapper.get();
            if (iDocumentTypeIdentifier3 != null) {
                LOGGER.info("Using '" + iDocumentTypeIdentifier3.getURIEncoded() + "' for defacto querying the SMP");
                signedServiceMetadataType = this.getServiceMetadataOrNull(iParticipantIdentifier, iDocumentTypeIdentifier3);
            } else {
                LOGGER.info("Found no matching document type ID to be queried via \u00b4Wildcard");
                signedServiceMetadataType = null;
            }
        }
        return signedServiceMetadataType;
    }

    @Nonnull
    public static CompleteServiceGroupType getCompleteServiceGroupByDNS(@Nonnull ISMPURLProvider iSMPURLProvider, @Nonnull ISMLInfo iSMLInfo, @Nonnull IParticipantIdentifier iParticipantIdentifier) throws SMPClientException, SMPDNSResolutionException {
        return new SMPClientReadOnly(iSMPURLProvider, iParticipantIdentifier, iSMLInfo).getCompleteServiceGroup(iParticipantIdentifier);
    }

    @Nonnull
    public static ServiceGroupType getServiceGroupByDNS(@Nonnull ISMPURLProvider iSMPURLProvider, @Nonnull ISMLInfo iSMLInfo, @Nonnull IParticipantIdentifier iParticipantIdentifier) throws SMPClientException, SMPDNSResolutionException {
        return new SMPClientReadOnly(iSMPURLProvider, iParticipantIdentifier, iSMLInfo).getServiceGroup(iParticipantIdentifier);
    }

    @Nonnull
    public static SignedServiceMetadataType getServiceRegistrationByDNS(@Nonnull ISMPURLProvider iSMPURLProvider, @Nonnull ISMLInfo iSMLInfo, @Nonnull IParticipantIdentifier iParticipantIdentifier, @Nonnull IDocumentTypeIdentifier iDocumentTypeIdentifier) throws SMPClientException, SMPDNSResolutionException {
        return new SMPClientReadOnly(iSMPURLProvider, iParticipantIdentifier, iSMLInfo).getServiceMetadata(iParticipantIdentifier, iDocumentTypeIdentifier);
    }
}

