/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.io.file;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.io.file.EFileIOErrorCode;
import com.helger.commons.io.file.EFileIOOperation;
import com.helger.commons.io.file.FileIOError;
import com.helger.commons.io.file.FilenameHelper;
import com.helger.commons.io.file.PathHelper;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class PathOperations {
    public static final boolean DEFAULT_EXCEPTION_ON_DELETE_ROOT = true;
    private static volatile boolean s_bExceptionOnDeleteRoot = true;
    private static final PathOperations s_aInstance = new PathOperations();

    private PathOperations() {
    }

    public static boolean isExceptionOnDeleteRoot() {
        return s_bExceptionOnDeleteRoot;
    }

    public static void setExceptionOnDeleteRoot(boolean bl) {
        s_bExceptionOnDeleteRoot = bl;
    }

    @Nonnull
    private static FileIOError _perform(@Nonnull EFileIOOperation eFileIOOperation, @Nonnull IOpPath iOpPath, @Nonnull Path path) {
        try {
            iOpPath.op(path);
            return EFileIOErrorCode.NO_ERROR.getAsIOError(eFileIOOperation, path);
        }
        catch (SecurityException securityException) {
            return EFileIOErrorCode.getSecurityAsIOError(eFileIOOperation, securityException);
        }
        catch (IOException iOException) {
            return EFileIOErrorCode.getAsIOError(eFileIOOperation, iOException);
        }
        catch (UncheckedIOException uncheckedIOException) {
            return EFileIOErrorCode.getAsIOError(eFileIOOperation, uncheckedIOException);
        }
    }

    @Nonnull
    private static FileIOError _perform(@Nonnull EFileIOOperation eFileIOOperation, @Nonnull IOpPath2 iOpPath2, @Nonnull Path path, @Nonnull Path path2) {
        try {
            iOpPath2.op(path, path2);
            return EFileIOErrorCode.NO_ERROR.getAsIOError(eFileIOOperation, path, path2);
        }
        catch (SecurityException securityException) {
            return EFileIOErrorCode.getSecurityAsIOError(eFileIOOperation, securityException);
        }
        catch (IOException iOException) {
            return EFileIOErrorCode.getAsIOError(eFileIOOperation, iOException);
        }
        catch (UncheckedIOException uncheckedIOException) {
            return EFileIOErrorCode.getAsIOError(eFileIOOperation, uncheckedIOException);
        }
    }

    @Nonnull
    private static Path _getUnifiedPath(Path path) {
        return path.toAbsolutePath().normalize();
    }

    @Nonnull
    public static FileIOError createDir(@Nonnull Path path2) {
        ValueEnforcer.notNull(path2, "Directory");
        Path path3 = PathOperations._getUnifiedPath(path2);
        if (Files.exists(path3, new LinkOption[0])) {
            return EFileIOErrorCode.TARGET_ALREADY_EXISTS.getAsIOError(EFileIOOperation.CREATE_DIR, path3);
        }
        Path path4 = path3.getParent();
        if (path4 != null && Files.exists(path4, new LinkOption[0]) && !Files.isWritable(path4)) {
            return EFileIOErrorCode.SOURCE_PARENT_NOT_WRITABLE.getAsIOError(EFileIOOperation.CREATE_DIR, path3);
        }
        return PathOperations._perform(EFileIOOperation.CREATE_DIR, path -> Files.createDirectory(path, new FileAttribute[0]), path3);
    }

    @Nonnull
    public static FileIOError createDirIfNotExisting(@Nonnull Path path) {
        FileIOError fileIOError = PathOperations.createDir(path);
        if (fileIOError.getErrorCode().equals(EFileIOErrorCode.TARGET_ALREADY_EXISTS)) {
            return fileIOError.withoutErrorCode();
        }
        return fileIOError;
    }

    @Nonnull
    public static FileIOError createDirRecursive(@Nonnull Path path2) {
        ValueEnforcer.notNull(path2, "Directory");
        Path path3 = PathOperations._getUnifiedPath(path2);
        if (Files.exists(path3, new LinkOption[0])) {
            return EFileIOErrorCode.TARGET_ALREADY_EXISTS.getAsIOError(EFileIOOperation.CREATE_DIR_RECURSIVE, path3);
        }
        Path path4 = path3.getParent();
        if (path4 != null && Files.exists(path4, new LinkOption[0]) && !Files.isWritable(path4)) {
            return EFileIOErrorCode.SOURCE_PARENT_NOT_WRITABLE.getAsIOError(EFileIOOperation.CREATE_DIR_RECURSIVE, path3);
        }
        return PathOperations._perform(EFileIOOperation.CREATE_DIR_RECURSIVE, path -> Files.createDirectories(path, new FileAttribute[0]), path3);
    }

    @Nonnull
    public static FileIOError createDirRecursiveIfNotExisting(@Nonnull Path path) {
        FileIOError fileIOError = PathOperations.createDirRecursive(path);
        if (fileIOError.getErrorCode().equals(EFileIOErrorCode.TARGET_ALREADY_EXISTS)) {
            return fileIOError.withoutErrorCode();
        }
        return fileIOError;
    }

    @Nonnull
    public static FileIOError deleteDir(@Nonnull Path path) {
        ValueEnforcer.notNull(path, "Directory");
        Path path2 = PathOperations._getUnifiedPath(path);
        if (!Files.isDirectory(path2, new LinkOption[0])) {
            return EFileIOErrorCode.SOURCE_DOES_NOT_EXIST.getAsIOError(EFileIOOperation.DELETE_DIR, path2);
        }
        if (PathOperations.isExceptionOnDeleteRoot() && (path2.getParent() == null || path2.getNameCount() == 0)) {
            throw new IllegalArgumentException("Aren't we deleting the full drive: '" + path2 + "'");
        }
        Path path3 = path2.getParent();
        if (path3 != null && !Files.isWritable(path3)) {
            return EFileIOErrorCode.SOURCE_PARENT_NOT_WRITABLE.getAsIOError(EFileIOOperation.DELETE_DIR, path2);
        }
        return PathOperations._perform(EFileIOOperation.DELETE_DIR, Files::delete, path2);
    }

    @Nonnull
    public static FileIOError deleteDirIfExisting(@Nonnull Path path) {
        FileIOError fileIOError = PathOperations.deleteDir(path);
        if (fileIOError.getErrorCode().equals(EFileIOErrorCode.SOURCE_DOES_NOT_EXIST)) {
            return fileIOError.withoutErrorCode();
        }
        return fileIOError;
    }

    @Nonnull
    public static FileIOError deleteDirRecursive(@Nonnull Path path) {
        ValueEnforcer.notNull(path, "Directory");
        Path path2 = PathOperations._getUnifiedPath(path);
        if (!Files.isDirectory(path2, new LinkOption[0])) {
            return EFileIOErrorCode.SOURCE_DOES_NOT_EXIST.getAsIOError(EFileIOOperation.DELETE_DIR_RECURSIVE, path2);
        }
        if (PathOperations.isExceptionOnDeleteRoot() && (path2.getParent() == null || path2.getNameCount() == 0)) {
            throw new IllegalArgumentException("Aren't we deleting the full drive: '" + path2 + "'");
        }
        Path path3 = path2.getParent();
        if (path3 != null && !Files.isWritable(path3)) {
            return EFileIOErrorCode.SOURCE_PARENT_NOT_WRITABLE.getAsIOError(EFileIOOperation.DELETE_DIR_RECURSIVE, path2);
        }
        for (Path path4 : PathHelper.getDirectoryContent(path2)) {
            FileIOError fileIOError;
            if (Files.isDirectory(path4, new LinkOption[0])) {
                if (FilenameHelper.isSystemInternalDirectory(path4) || !(fileIOError = PathOperations.deleteDirRecursive(path4)).isFailure()) continue;
                return fileIOError;
            }
            if (Files.isRegularFile(path4, new LinkOption[0])) {
                fileIOError = PathOperations.deleteFile(path4);
                if (!fileIOError.isFailure()) continue;
                return fileIOError;
            }
            return EFileIOErrorCode.OBJECT_CANNOT_BE_HANDLED.getAsIOError(EFileIOOperation.DELETE_DIR_RECURSIVE, path4);
        }
        return PathOperations.deleteDir(path2);
    }

    @Nonnull
    public static FileIOError deleteDirRecursiveIfExisting(@Nonnull Path path) {
        FileIOError fileIOError = PathOperations.deleteDirRecursive(path);
        if (fileIOError.getErrorCode().equals(EFileIOErrorCode.SOURCE_DOES_NOT_EXIST)) {
            return fileIOError.withoutErrorCode();
        }
        return fileIOError;
    }

    @Nonnull
    public static FileIOError deleteFile(@Nonnull Path path) {
        ValueEnforcer.notNull(path, "Path");
        Path path2 = PathOperations._getUnifiedPath(path);
        if (!Files.isRegularFile(path2, new LinkOption[0])) {
            return EFileIOErrorCode.SOURCE_DOES_NOT_EXIST.getAsIOError(EFileIOOperation.DELETE_FILE, path2);
        }
        Path path3 = path2.getParent();
        if (path3 != null && !Files.isWritable(path3)) {
            return EFileIOErrorCode.SOURCE_PARENT_NOT_WRITABLE.getAsIOError(EFileIOOperation.DELETE_FILE, path2);
        }
        return PathOperations._perform(EFileIOOperation.DELETE_FILE, Files::delete, path2);
    }

    @Nonnull
    public static FileIOError deleteFileIfExisting(@Nonnull Path path) {
        FileIOError fileIOError = PathOperations.deleteFile(path);
        if (fileIOError.getErrorCode().equals(EFileIOErrorCode.SOURCE_DOES_NOT_EXIST)) {
            return fileIOError.withoutErrorCode();
        }
        return fileIOError;
    }

    private static void _atomicMove(@Nonnull Path path, @Nonnull Path path2) throws IOException {
        Files.move(path, path2, StandardCopyOption.ATOMIC_MOVE);
    }

    @Nonnull
    public static FileIOError renameFile(@Nonnull Path path, @Nonnull Path path2) {
        ValueEnforcer.notNull(path, "SourceFile");
        ValueEnforcer.notNull(path2, "TargetFile");
        Path path3 = PathOperations._getUnifiedPath(path);
        Path path4 = PathOperations._getUnifiedPath(path2);
        if (!Files.isRegularFile(path3, new LinkOption[0])) {
            return EFileIOErrorCode.SOURCE_DOES_NOT_EXIST.getAsIOError(EFileIOOperation.RENAME_FILE, path3);
        }
        if (EqualsHelper.equals(path3, path4)) {
            return EFileIOErrorCode.SOURCE_EQUALS_TARGET.getAsIOError(EFileIOOperation.RENAME_FILE, path3);
        }
        if (Files.exists(path4, new LinkOption[0])) {
            return EFileIOErrorCode.TARGET_ALREADY_EXISTS.getAsIOError(EFileIOOperation.RENAME_FILE, path4);
        }
        Path path5 = path3.getParent();
        if (path5 != null && !Files.isWritable(path5)) {
            return EFileIOErrorCode.SOURCE_PARENT_NOT_WRITABLE.getAsIOError(EFileIOOperation.RENAME_FILE, path3);
        }
        Path path6 = path4.getParent();
        if (path6 != null && Files.exists(path6, new LinkOption[0]) && !Files.isWritable(path6)) {
            return EFileIOErrorCode.TARGET_PARENT_NOT_WRITABLE.getAsIOError(EFileIOOperation.RENAME_FILE, path4);
        }
        PathHelper.ensureParentDirectoryIsPresent(path4);
        return PathOperations._perform(EFileIOOperation.RENAME_FILE, PathOperations::_atomicMove, path3, path4);
    }

    @Nonnull
    public static FileIOError renameDir(@Nonnull Path path, @Nonnull Path path2) {
        ValueEnforcer.notNull(path, "SourceDirectory");
        ValueEnforcer.notNull(path2, "TargetDirectory");
        Path path3 = PathOperations._getUnifiedPath(path);
        Path path4 = PathOperations._getUnifiedPath(path2);
        if (!Files.isDirectory(path3, new LinkOption[0])) {
            return EFileIOErrorCode.SOURCE_DOES_NOT_EXIST.getAsIOError(EFileIOOperation.RENAME_DIR, path3);
        }
        if (EqualsHelper.equals(path3, path4)) {
            return EFileIOErrorCode.SOURCE_EQUALS_TARGET.getAsIOError(EFileIOOperation.RENAME_DIR, path3);
        }
        if (Files.exists(path4, new LinkOption[0])) {
            return EFileIOErrorCode.TARGET_ALREADY_EXISTS.getAsIOError(EFileIOOperation.RENAME_DIR, path4);
        }
        if (PathHelper.isParentDirectory(path3, path4)) {
            return EFileIOErrorCode.TARGET_IS_CHILD_OF_SOURCE.getAsIOError(EFileIOOperation.RENAME_DIR, path3, path4);
        }
        Path path5 = path3.getParent();
        if (path5 != null && !Files.isWritable(path5)) {
            return EFileIOErrorCode.SOURCE_PARENT_NOT_WRITABLE.getAsIOError(EFileIOOperation.RENAME_DIR, path3);
        }
        Path path6 = path4.getParent();
        if (path6 != null && Files.exists(path6, new LinkOption[0]) && !Files.isWritable(path6)) {
            return EFileIOErrorCode.TARGET_PARENT_NOT_WRITABLE.getAsIOError(EFileIOOperation.RENAME_DIR, path4);
        }
        PathHelper.ensureParentDirectoryIsPresent(path4);
        return PathOperations._perform(EFileIOOperation.RENAME_DIR, PathOperations::_atomicMove, path3, path4);
    }

    @Nonnull
    public static FileIOError copyFile(@Nonnull Path path3, @Nonnull Path path4) {
        ValueEnforcer.notNull(path3, "SourceFile");
        ValueEnforcer.notNull(path4, "TargetFile");
        Path path5 = PathOperations._getUnifiedPath(path3);
        Path path6 = PathOperations._getUnifiedPath(path4);
        if (!Files.isRegularFile(path5, new LinkOption[0])) {
            return EFileIOErrorCode.SOURCE_DOES_NOT_EXIST.getAsIOError(EFileIOOperation.COPY_FILE, path5);
        }
        if (EqualsHelper.equals(path5, path6)) {
            return EFileIOErrorCode.SOURCE_EQUALS_TARGET.getAsIOError(EFileIOOperation.COPY_FILE, path5);
        }
        if (Files.exists(path6, new LinkOption[0])) {
            return EFileIOErrorCode.TARGET_ALREADY_EXISTS.getAsIOError(EFileIOOperation.COPY_FILE, path6);
        }
        if (!Files.isReadable(path5)) {
            return EFileIOErrorCode.SOURCE_NOT_READABLE.getAsIOError(EFileIOOperation.COPY_FILE, path5);
        }
        Path path7 = path6.getParent();
        if (path7 != null && Files.exists(path7, new LinkOption[0]) && !Files.isWritable(path7)) {
            return EFileIOErrorCode.TARGET_PARENT_NOT_WRITABLE.getAsIOError(EFileIOOperation.COPY_FILE, path6);
        }
        PathHelper.ensureParentDirectoryIsPresent(path6);
        return PathOperations._perform(EFileIOOperation.COPY_FILE, (path, path2) -> Files.copy(path, path2, new CopyOption[0]), path5, path6);
    }

    @Nonnull
    public static FileIOError copyDirRecursive(@Nonnull Path path, @Nonnull Path path2) {
        ValueEnforcer.notNull(path, "SourceDirectory");
        ValueEnforcer.notNull(path2, "TargetDirectory");
        Path path3 = PathOperations._getUnifiedPath(path);
        Path path4 = PathOperations._getUnifiedPath(path2);
        if (!Files.isDirectory(path3, new LinkOption[0])) {
            return EFileIOErrorCode.SOURCE_DOES_NOT_EXIST.getAsIOError(EFileIOOperation.COPY_DIR_RECURSIVE, path3);
        }
        if (EqualsHelper.equals(path3, path4)) {
            return EFileIOErrorCode.SOURCE_EQUALS_TARGET.getAsIOError(EFileIOOperation.COPY_DIR_RECURSIVE, path3);
        }
        if (PathHelper.isParentDirectory(path3, path4)) {
            return EFileIOErrorCode.TARGET_IS_CHILD_OF_SOURCE.getAsIOError(EFileIOOperation.COPY_DIR_RECURSIVE, path3, path4);
        }
        if (Files.exists(path4, new LinkOption[0])) {
            return EFileIOErrorCode.TARGET_ALREADY_EXISTS.getAsIOError(EFileIOOperation.COPY_DIR_RECURSIVE, path4);
        }
        if (!Files.isReadable(path3)) {
            return EFileIOErrorCode.SOURCE_NOT_READABLE.getAsIOError(EFileIOOperation.COPY_DIR_RECURSIVE, path3);
        }
        Path path5 = path4.getParent();
        if (path5 != null && Files.exists(path5, new LinkOption[0]) && !Files.isWritable(path5)) {
            return EFileIOErrorCode.TARGET_PARENT_NOT_WRITABLE.getAsIOError(EFileIOOperation.COPY_DIR_RECURSIVE, path4);
        }
        FileIOError fileIOError = PathOperations.createDirRecursive(path4);
        if (fileIOError.isFailure()) {
            return fileIOError;
        }
        for (Path path6 : PathHelper.getDirectoryContent(path3)) {
            if (Files.isDirectory(path6, new LinkOption[0])) {
                if (FilenameHelper.isSystemInternalDirectory(path6) || !(fileIOError = PathOperations.copyDirRecursive(path6, path4.resolve(path6.getFileName()))).isFailure()) continue;
                return fileIOError;
            }
            if (Files.isRegularFile(path6, new LinkOption[0])) {
                fileIOError = PathOperations.copyFile(path6, path4.resolve(path6.getFileName()));
                if (!fileIOError.isFailure()) continue;
                return fileIOError;
            }
            return EFileIOErrorCode.OBJECT_CANNOT_BE_HANDLED.getAsIOError(EFileIOOperation.COPY_DIR_RECURSIVE, path6);
        }
        return EFileIOErrorCode.NO_ERROR.getAsIOError(EFileIOOperation.COPY_DIR_RECURSIVE, path3, path4);
    }

    @FunctionalInterface
    private static interface IOpPath2 {
        public void op(Path var1, Path var2) throws IOException;
    }

    @FunctionalInterface
    private static interface IOpPath {
        public void op(Path var1) throws IOException;
    }
}

